/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import java.io.UnsupportedEncodingException;

public class SM2UserID {
    private byte[] userID;
    private String charsetEncoding;

    public SM2UserID(byte[] userID) {
        this.userID = userID;
    }

    public SM2UserID(byte[] userID, String charsetEncoding) {
        this.userID = userID;
        this.charsetEncoding = charsetEncoding;
    }

    public byte[] getUserID() {
        return this.userID;
    }

    public int length() {
        return this.userID.length;
    }

    public byte[] getENTL() {
        byte[] entl = new byte[2];
        int entLen = this.length() * 8;
        entl[0] = (byte)(entLen >> 8 & 0xFF);
        entl[1] = (byte)(entLen & 0xFF);
        return entl;
    }

    public String getCharsetEncoding() {
        if (this.charsetEncoding == null) {
            return System.getProperty("file.encoding");
        }
        return this.charsetEncoding;
    }

    public String toString() {
        if (this.charsetEncoding != null) {
            try {
                return new String(this.userID, this.charsetEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(this.userID);
    }
}

