/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import java.security.MessageDigestSpi;

public class SM3MessageDigest
extends MessageDigestSpi
implements Cloneable {
    private static final int DIGEST_LENGTH = 32;
    private static final int[] v0 = new int[]{1937774191, 1226093241, 388252375, -628488704, -1452330820, 372324522, -477237683, -1325724082};
    private int[] v = new int[8];
    private int[] v_ = new int[8];
    private static final int[] X0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] X = new int[68];
    private int xOff;
    private int T_00_15 = 2043430169;
    private int T_16_63 = 2055708042;
    private static final int BYTE_LENGTH = 64;
    private byte[] xBuf = new byte[4];
    private int xBufOff = 0;
    private long byteCount;

    public SM3MessageDigest() {
        this.reset();
    }

    protected void engineUpdate(byte input) {
        this.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.update(input, offset, len);
    }

    protected byte[] engineDigest() {
        byte[] digest = new byte[32];
        if (this.doFinal(digest, 0) > 0) {
            return digest;
        }
        return null;
    }

    protected void engineReset() {
        this.reset();
    }

    protected void reset() {
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (int i = 0; i < this.xBuf.length; ++i) {
            this.xBuf[i] = 0;
        }
        System.arraycopy(v0, 0, this.v, 0, v0.length);
        this.xOff = 0;
        System.arraycopy(X0, 0, this.X, 0, X0.length);
    }

    protected void processBlock() {
        int TT2;
        int TT1;
        int SS2;
        int SS1;
        int aaa;
        int i;
        int[] ww = this.X;
        int[] ww_ = new int[64];
        for (i = 16; i < 68; ++i) {
            ww[i] = this.P1(ww[i - 16] ^ ww[i - 9] ^ this.ROTATE(ww[i - 3], 15)) ^ this.ROTATE(ww[i - 13], 7) ^ ww[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            ww_[i] = ww[i] ^ ww[i + 4];
        }
        int[] vv = this.v;
        int[] vv_ = this.v_;
        System.arraycopy(vv, 0, vv_, 0, v0.length);
        for (i = 0; i < 16; ++i) {
            aaa = this.ROTATE(vv_[0], 12);
            SS1 = aaa + vv_[4] + this.ROTATE(this.T_00_15, i);
            SS1 = this.ROTATE(SS1, 7);
            SS2 = SS1 ^ aaa;
            TT1 = this.FF_00_15(vv_[0], vv_[1], vv_[2]) + vv_[3] + SS2 + ww_[i];
            TT2 = this.GG_00_15(vv_[4], vv_[5], vv_[6]) + vv_[7] + SS1 + ww[i];
            vv_[3] = vv_[2];
            vv_[2] = this.ROTATE(vv_[1], 9);
            vv_[1] = vv_[0];
            vv_[0] = TT1;
            vv_[7] = vv_[6];
            vv_[6] = this.ROTATE(vv_[5], 19);
            vv_[5] = vv_[4];
            vv_[4] = this.P0(TT2);
        }
        for (i = 16; i < 64; ++i) {
            aaa = this.ROTATE(vv_[0], 12);
            SS1 = aaa + vv_[4] + this.ROTATE(this.T_16_63, i);
            SS1 = this.ROTATE(SS1, 7);
            SS2 = SS1 ^ aaa;
            TT1 = this.FF_16_63(vv_[0], vv_[1], vv_[2]) + vv_[3] + SS2 + ww_[i];
            TT2 = this.GG_16_63(vv_[4], vv_[5], vv_[6]) + vv_[7] + SS1 + ww[i];
            vv_[3] = vv_[2];
            vv_[2] = this.ROTATE(vv_[1], 9);
            vv_[1] = vv_[0];
            vv_[0] = TT1;
            vv_[7] = vv_[6];
            vv_[6] = this.ROTATE(vv_[5], 19);
            vv_[5] = vv_[4];
            vv_[4] = this.P0(TT2);
        }
        for (i = 0; i < 8; ++i) {
            int n = i;
            vv[n] = vv[n] ^ vv_[i];
        }
        this.xOff = 0;
        System.arraycopy(X0, 0, this.X, 0, X0.length);
    }

    protected void processWord(byte[] in, int inOff) {
        int n = in[inOff] << 24;
        n |= (in[++inOff] & 0xFF) << 16;
        n |= (in[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n |= in[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength >>> 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    protected static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    protected int doFinal(byte[] out, int outOff) {
        this.finish();
        for (int i = 0; i < 8; ++i) {
            SM3MessageDigest.intToBigEndian(this.v[i], out, outOff + i * 4);
        }
        this.reset();
        return 32;
    }

    protected String getAlgorithmName() {
        return "SM3";
    }

    protected int getDigestSize() {
        return 32;
    }

    private int ROTATE(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private int P0(int X) {
        return X ^ this.ROTATE(X, 9) ^ this.ROTATE(X, 17);
    }

    private int P1(int X) {
        return X ^ this.ROTATE(X, 15) ^ this.ROTATE(X, 23);
    }

    private int FF_00_15(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private int FF_16_63(int X, int Y, int Z) {
        return X & Y | X & Z | Y & Z;
    }

    private int GG_00_15(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private int GG_16_63(int X, int Y, int Z) {
        return X & Y | ~X & Z;
    }

    protected void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    protected void update(byte[] in, int inOff, int len) {
        while (this.xBufOff != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.xBuf.length) {
            this.processWord(in, inOff);
            inOff += this.xBuf.length;
            len -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    protected void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }

    protected int engineGetDigestLength() {
        return 32;
    }
}

