/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ConstructKeys;
import cn.topca.security.sm.PKCS5Padding;
import cn.topca.security.sm.Padding;
import cn.topca.security.sm.SM4Crypt;
import cn.topca.security.sm.SymmetricCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class SM4Cipher
extends CipherSpi {
    private byte[] buffer = null;
    private int blockSize = 0;
    private int unitBytes = 0;
    private int buffered = 0;
    private int minBytes = 0;
    private int diffBlocksize = 0;
    private Padding padding = null;
    private SymmetricCipher sm4Cipher = new SM4Crypt();
    private boolean decrypting = false;

    public SM4Cipher() {
        this.unitBytes = this.blockSize = this.sm4Cipher.getBlockSize();
        this.diffBlocksize = this.blockSize;
        this.buffer = new byte[this.blockSize * 2];
        this.padding = new PKCS5Padding(this.blockSize);
    }

    public SM4Cipher(String transformation) {
        this.unitBytes = this.blockSize = this.sm4Cipher.getBlockSize();
        this.diffBlocksize = this.blockSize;
        this.buffer = new byte[this.blockSize * 2];
        if (transformation.indexOf("ECB") < 0) {
            this.padding = new PKCS5Padding(this.blockSize);
        }
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(input, inputOffset, inputLen);
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.getOutputSize(inputLen);
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec = null;
        if (params != null) {
            try {
                ivSpec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
            }
        }
        this.engineInit(opmode, key, ivSpec, random);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    protected void engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (paddingName == null) {
            throw new NoSuchPaddingException("null padding");
        }
        if (paddingName.equalsIgnoreCase("NoPadding")) {
            this.padding = null;
        } else if (!paddingName.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Padding: " + paddingName + " not implemented");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.update(input, inputOffset, inputLen);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.update(input, inputOffset, inputLen, output, outputOffset);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (!SM4Crypt.isKeySizeValid(encoded.length)) {
            throw new InvalidKeyException("Invalid SM4 key length: " + encoded.length + " bytes");
        }
        return encoded.length * 8;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.wrap(key);
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    void init(int opmode, Key key) throws InvalidKeyException {
        this.decrypting = opmode == 2 || opmode == 4;
        byte[] keyBytes = SymmetricCipher.getKeyBytes(key);
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        String algorithm = key.getAlgorithm();
        if (keyBytes == null) {
            throw new InvalidKeyException("Internal error");
        }
        this.sm4Cipher.init(this.decrypting, algorithm, keyBytes);
    }

    byte[] update(byte[] input, int inputOffset, int inputLen) {
        byte[] output = null;
        byte[] out = null;
        try {
            output = new byte[this.getOutputSize(inputLen)];
            int len = this.update(input, inputOffset, inputLen, output, 0);
            if (len == output.length) {
                out = output;
            } else {
                out = new byte[len];
                System.arraycopy(output, 0, out, 0, len);
            }
        }
        catch (ShortBufferException e) {
            // empty catch block
        }
        return out;
    }

    int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int len = this.buffered + inputLen - this.minBytes;
        if (this.padding != null && this.decrypting) {
            len -= this.blockSize;
        }
        int n = len = len > 0 ? len - len % this.unitBytes : 0;
        if (output == null || output.length - outputOffset < len) {
            throw new ShortBufferException("Output buffer must be (at least) " + len + " bytes long");
        }
        if (len != 0) {
            byte[] in = new byte[len];
            int inputConsumed = len - this.buffered;
            int bufferedConsumed = this.buffered;
            if (inputConsumed < 0) {
                inputConsumed = 0;
                bufferedConsumed = len;
            }
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, in, 0, bufferedConsumed);
            }
            if (inputConsumed > 0) {
                System.arraycopy(input, inputOffset, in, bufferedConsumed, inputConsumed);
            }
            if (this.decrypting) {
                this.decrypt(in, 0, len, output, outputOffset);
            } else {
                this.encrypt(in, 0, len, output, outputOffset);
            }
            if (this.unitBytes != this.blockSize) {
                this.diffBlocksize = len < this.diffBlocksize ? (this.diffBlocksize -= len) : this.blockSize - (len - this.diffBlocksize) % this.blockSize;
            }
            inputLen -= inputConsumed;
            inputOffset += inputConsumed;
            outputOffset += len;
            this.buffered -= bufferedConsumed;
            if (this.buffered > 0) {
                System.arraycopy(this.buffer, bufferedConsumed, this.buffer, 0, this.buffered);
            }
        }
        if (inputLen > 0) {
            System.arraycopy(input, inputOffset, this.buffer, this.buffered, inputLen);
        }
        this.buffered += inputLen;
        return len;
    }

    byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = null;
        byte[] out = null;
        try {
            output = new byte[this.getOutputSize(inputLen)];
            int len = this.doFinal(input, inputOffset, inputLen, output, 0);
            if (len < output.length) {
                out = new byte[len];
                if (len != 0) {
                    System.arraycopy(output, 0, out, 0, len);
                }
            } else {
                out = output;
            }
        }
        catch (ShortBufferException e) {
            // empty catch block
        }
        return out;
    }

    int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int totalLen;
        int paddedLen = totalLen = this.buffered + inputLen;
        int paddingLen = 0;
        if (this.unitBytes != this.blockSize) {
            paddingLen = totalLen < this.diffBlocksize ? this.diffBlocksize - totalLen : this.blockSize - (totalLen - this.diffBlocksize) % this.blockSize;
        } else if (this.padding != null) {
            paddingLen = this.padding.padLength(totalLen);
        }
        if (paddingLen > 0 && paddingLen != this.blockSize && this.padding != null && this.decrypting) {
            throw new IllegalBlockSizeException("Input length must be multiple of " + this.blockSize + " when decrypting with padded cipher");
        }
        if (!this.decrypting && this.padding != null) {
            paddedLen += paddingLen;
        }
        if (output == null) {
            throw new ShortBufferException("Output buffer is null");
        }
        int outputCapacity = output.length - outputOffset;
        if ((!this.decrypting || this.padding == null) && outputCapacity < paddedLen || this.decrypting && outputCapacity < paddedLen - this.blockSize) {
            throw new ShortBufferException("Output buffer too short: " + outputCapacity + " bytes given, " + paddedLen + " bytes needed");
        }
        byte[] finalBuf = input;
        int finalOffset = inputOffset;
        if (this.buffered != 0 || !this.decrypting && this.padding != null) {
            finalOffset = 0;
            finalBuf = new byte[paddedLen];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
            }
            if (!this.decrypting && this.padding != null) {
                this.padding.padWithLen(finalBuf, totalLen, paddingLen);
            }
        }
        if (this.decrypting) {
            if (outputCapacity < paddedLen) {
                this.save();
            }
            byte[] outWithPadding = new byte[totalLen];
            totalLen = this.finalNoPadding(finalBuf, finalOffset, outWithPadding, 0, totalLen);
            if (this.padding != null) {
                int padStart = this.padding.unpad(outWithPadding, 0, totalLen);
                if (padStart < 0) {
                    throw new BadPaddingException("Given final block not properly padded");
                }
                totalLen = padStart;
            }
            if (output.length - outputOffset < totalLen) {
                this.restore();
                throw new ShortBufferException("Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + totalLen + " bytes needed");
            }
            for (int i = 0; i < totalLen; ++i) {
                output[outputOffset + i] = outWithPadding[i];
            }
        } else {
            totalLen = this.finalNoPadding(finalBuf, finalOffset, output, outputOffset, paddedLen);
        }
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        return totalLen;
    }

    private int finalNoPadding(byte[] in, int inOff, byte[] out, int outOff, int len) throws IllegalBlockSizeException {
        if (in == null || len == 0) {
            return 0;
        }
        if (len % this.unitBytes != 0) {
            if (this.padding != null) {
                throw new IllegalBlockSizeException("Input length (with padding) not multiple of " + this.unitBytes + " bytes");
            }
            throw new IllegalBlockSizeException("Input length not multiple of " + this.unitBytes + " bytes");
        }
        if (this.decrypting) {
            this.decrypt(in, inOff, len, out, outOff);
        } else {
            this.encrypt(in, inOff, len, out, outOff);
        }
        return len;
    }

    byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result = null;
        try {
            byte[] encodedKey = key.getEncoded();
            if (encodedKey == null || encodedKey.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            result = this.doFinal(encodedKey, 0, encodedKey.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return result;
    }

    Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        try {
            encodedKey = this.doFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            throw new InvalidKeyException("The wrapped key is not padded correctly");
        }
        catch (IllegalBlockSizeException eBlockSize) {
            throw new InvalidKeyException("The wrapped key does not have the correct length");
        }
        return ConstructKeys.constructKey(encodedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    int getOutputSize(int inputLen) {
        int totalLen = this.buffered + inputLen;
        if (this.padding == null) {
            return totalLen;
        }
        if (this.decrypting) {
            return totalLen;
        }
        if (this.unitBytes != this.blockSize) {
            if (totalLen < this.diffBlocksize) {
                return this.diffBlocksize;
            }
            return totalLen + this.blockSize - (totalLen - this.diffBlocksize) % this.blockSize;
        }
        return totalLen + this.padding.padLength(totalLen);
    }

    void encrypt(byte[] in, int inOff, int len, byte[] out, int outOff) {
        while (len >= this.blockSize) {
            this.sm4Cipher.encryptBlock(in, inOff, out, outOff);
            len -= this.blockSize;
            inOff += this.blockSize;
            outOff += this.blockSize;
        }
    }

    void decrypt(byte[] in, int inOff, int len, byte[] out, int outOff) {
        while (len >= this.blockSize) {
            this.sm4Cipher.decryptBlock(in, inOff, out, outOff);
            len -= this.blockSize;
            inOff += this.blockSize;
            outOff += this.blockSize;
        }
    }

    void save() {
    }

    void restore() {
    }
}

