/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.jca.JCAJCEUtil;
import cn.topca.security.sm.SM4Constants;
import cn.topca.security.sm.SM4Crypt;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SM4KeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keySize = 16;

    protected SecretKey engineGenerateKey() {
        SecretKeySpec sm4Key = null;
        if (this.random == null) {
            this.random = JCAJCEUtil.getSecureRandom();
        }
        byte[] keyBytes = new byte[this.keySize];
        this.random.nextBytes(keyBytes);
        sm4Key = new SecretKeySpec(keyBytes, "SM4");
        return sm4Key;
    }

    protected void engineInit(SecureRandom random) {
        this.random = random;
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("SM4 key generation does not take any parameters");
    }

    protected void engineInit(int keysize, SecureRandom random) {
        if (keysize % 8 != 0 || !SM4Crypt.isKeySizeValid(keysize / 8)) {
            throw new InvalidParameterException("Wrong keysize: must be equal to " + Arrays.toString(SM4Constants.SM4_KEYSIZES));
        }
        this.keySize = keysize / 8;
        this.engineInit(random);
    }
}

