/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import java.security.InvalidKeyException;
import java.security.Key;

abstract class SymmetricCipher {
    SymmetricCipher() {
    }

    abstract int getBlockSize();

    abstract void init(boolean var1, String var2, byte[] var3) throws InvalidKeyException;

    abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    static byte[] getKeyBytes(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] keyBytes = key.getEncoded();
        if (keyBytes == null) {
            throw new InvalidKeyException("RAW key bytes missing");
        }
        return keyBytes;
    }
}

