/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.tsp;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DERBoolean;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.tsp.TimeStampRequest;
import cn.topca.security.tsp.MessageImprint;
import cn.topca.security.tsp.TSAPolicyId;
import cn.topca.security.tsp.TSPExtensions;
import cn.topca.security.tsp.TimeStampReq;
import cn.topca.security.x509.X509ExtensionIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Vector;

public class TSPReqGenerator {
    private cn.topca.security.x509.X509Extensions extensions;
    private boolean certReq;
    private String identifier;

    public cn.topca.security.x509.X509Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(cn.topca.security.x509.X509Extensions extensions) {
        this.extensions = extensions;
    }

    public boolean isCertReq() {
        return this.certReq;
    }

    public void setCertReq(boolean certReq) {
        this.certReq = certReq;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public TimeStampReq generate(X509ExtensionIdentifier identifier, byte[] digest, BigInteger nonce) throws IOException {
        return this.generate(identifier.toString(), digest, nonce);
    }

    public TimeStampReq generate(String digestAlgorithmOID, byte[] digest, BigInteger nonce) throws IOException {
        TimeStampReq tsReq = new TimeStampReq();
        DERObjectIdentifier digestAlgOID = new DERObjectIdentifier(digestAlgorithmOID);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(digestAlgOID, new DERNull());
        cn.tca.TopBasicCrypto.asn1.tsp.MessageImprint mImprint = new cn.tca.TopBasicCrypto.asn1.tsp.MessageImprint(algID, digest);
        Vector<ASN1ObjectIdentifier> objectIDs = new Vector<ASN1ObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        for (String oid : this.extensions.getCriticalExtensionOIDs()) {
            objectIDs.add(new ASN1ObjectIdentifier(oid));
            values.add(new X509Extension(true, (ASN1OctetString)new DEROctetString(this.extensions.getExtensionValue(oid))));
        }
        Iterator<String> it = null;
        TimeStampRequest bcreq = new TimeStampRequest(new cn.tca.TopBasicCrypto.asn1.tsp.TimeStampReq(mImprint, new DERObjectIdentifier(this.identifier), new DERInteger(nonce), new DERBoolean(this.certReq), new X509Extensions(objectIDs, values)));
        if (bcreq.hasExtensions()) {
            tsReq.setExtensions(new TSPExtensions());
            for (String oid : bcreq.getCriticalExtensionOIDs()) {
                tsReq.getExtensions().add(oid, bcreq.getExtensionValue(oid), true);
            }
            Iterator its = null;
            for (String oid : bcreq.getNonCriticalExtensionOIDs()) {
                tsReq.getExtensions().add(oid, bcreq.getExtensionValue(oid), false);
            }
        }
        tsReq.setMessageImprint(new MessageImprint(bcreq.getMessageImprintAlgOID(), bcreq.getMessageImprintDigest()));
        tsReq.setReqPolicy(new TSAPolicyId(bcreq.getReqPolicy()));
        tsReq.setNonce(bcreq.getNonce());
        tsReq.setCertReq(bcreq.getCertReq());
        return tsReq;
    }
}

