/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.tsp;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DERBoolean;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.tsp.MessageImprint;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import cn.tca.TopBasicCrypto.tsp.TimeStampRequest;
import cn.tca.TopBasicCrypto.tsp.TimeStampTokenGenerator;
import cn.topca.security.pkix.PKIFailureInfo;
import cn.topca.security.pkix.PKIFreeText;
import cn.topca.security.pkix.PKIStatus;
import cn.topca.security.pkix.PKIStatusInfo;
import cn.topca.security.tsp.TSPException;
import cn.topca.security.tsp.TimeStampReq;
import cn.topca.security.tsp.TimeStampResp;
import cn.topca.security.tsp.TimeStampToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class TSPRespGenerator {
    private int status;
    private int failInfo;
    private String[] statusStrings;
    private PrivateKey privateKey;
    private X509Certificate x509Cert;
    private String tsaPolicyOID;
    private String provider;

    public TimeStampResp generate(TimeStampReq request, BigInteger serialNumber, Date genTime) throws IOException, TSPException, TSPException {
        TimeStampResp tsResp = null;
        ContentInfo tstTokenContentInfo = null;
        MessageImprint bcMsgImprint = null;
        DERObjectIdentifier derTSAPolicy = null;
        DERInteger derNonce = null;
        DERBoolean derCertReq = null;
        X509Extensions bcX509Extensions = null;
        bcMsgImprint = new MessageImprint(AlgorithmIdentifier.getInstance(request.getMessageImprint().getHashAlgorithm().toString()), request.getMessageImprint().getHashedMessage());
        if (request.getReqPolicy() != null) {
            derTSAPolicy = new DERObjectIdentifier(request.getReqPolicy().toString());
        }
        if (request.getNonce() != null) {
            derNonce = new DERInteger(request.getNonce());
        }
        derCertReq = new DERBoolean(request.isCertReq());
        if (request.getExtensions() != null) {
            Vector<ASN1ObjectIdentifier> objectIDs = new Vector<ASN1ObjectIdentifier>();
            Vector<X509Extension> values = new Vector<X509Extension>();
            for (String oid : request.getExtensions().getCriticalExtensionOIDs()) {
                objectIDs.add(new ASN1ObjectIdentifier(oid));
                values.add(new X509Extension(true, (ASN1OctetString)new DEROctetString(request.getExtensions().getExtensionValue(oid))));
            }
            Iterator<String> it = null;
        }
        TimeStampRequest bcreq = new TimeStampRequest(new cn.tca.TopBasicCrypto.asn1.tsp.TimeStampReq(bcMsgImprint, derTSAPolicy, derNonce, derCertReq, bcX509Extensions));
        try {
            TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", this.privateKey, this.x509Cert), new ASN1ObjectIdentifier(this.tsaPolicyOID));
            tsTokenGen.generate(bcreq, serialNumber, genTime);
            ByteArrayInputStream bIn = new ByteArrayInputStream(tsTokenGen.generate(bcreq, serialNumber, genTime, this.provider).toCMSSignedData().getEncoded());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            tstTokenContentInfo = ContentInfo.getInstance(aIn.readObject());
        }
        catch (Exception e) {
            throw new TSPException("Timestamp token received cannot be converted to ContentInfo", e);
        }
        try {
            PKIFreeText ifreeText = null;
            if (this.statusStrings != null && this.statusStrings.length <= 0) {
                ifreeText = new PKIFreeText(this.statusStrings);
            }
            PKIFailureInfo failureInfo = null;
            if (this.failInfo != 0) {
                failureInfo = new PKIFailureInfo(this.failInfo);
            }
            tsResp = new TimeStampResp(new PKIStatusInfo(new PKIStatus(this.status), ifreeText, failureInfo), new TimeStampToken(tstTokenContentInfo));
        }
        catch (cn.tca.TopBasicCrypto.tsp.TSPException e) {
            throw new TSPException(e.getMessage(), e);
        }
        return tsResp;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public X509Certificate getX509Cert() {
        return this.x509Cert;
    }

    public void setX509Cert(X509Certificate x509Cert) {
        this.x509Cert = x509Cert;
    }

    public String getTsaPolicyOID() {
        return this.tsaPolicyOID;
    }

    public void setTsaPolicyOID(String tsaPolicyOID) {
        this.tsaPolicyOID = tsaPolicyOID;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getFailInfo() {
        return this.failInfo;
    }

    public void setFailInfo(int failInfo) {
        this.failInfo = failInfo;
    }

    public String[] getStatusStrings() {
        return this.statusStrings;
    }

    public void setStatusStrings(String[] statusStrings) {
        this.statusStrings = statusStrings;
    }
}

