/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.util.calendar;

import cn.topca.security.util.calendar.CalendarDate;
import cn.topca.security.util.calendar.CalendarSystem;
import cn.topca.security.util.calendar.CalendarUtils;
import cn.topca.security.util.calendar.Era;
import java.util.TimeZone;

public abstract class AbstractCalendar
extends CalendarSystem {
    static final int SECOND_IN_MILLIS = 1000;
    static final int MINUTE_IN_MILLIS = 60000;
    static final int HOUR_IN_MILLIS = 3600000;
    static final int DAY_IN_MILLIS = 86400000;
    static final int EPOCH_OFFSET = 719163;
    private Era[] eras;

    protected AbstractCalendar() {
    }

    public Era getEra(String eraName) {
        if (this.eras != null) {
            for (int i = 0; i < this.eras.length; ++i) {
                if (!this.eras[i].equals(eraName)) continue;
                return this.eras[i];
            }
        }
        return null;
    }

    public Era[] getEras() {
        Era[] e = null;
        if (this.eras != null) {
            e = new Era[this.eras.length];
            System.arraycopy(this.eras, 0, e, 0, this.eras.length);
        }
        return e;
    }

    public void setEra(CalendarDate date, String eraName) {
        if (this.eras == null) {
            return;
        }
        for (int i = 0; i < this.eras.length; ++i) {
            Era e = this.eras[i];
            if (e == null || !e.getName().equals(eraName)) continue;
            date.setEra(e);
            return;
        }
        throw new IllegalArgumentException("unknown era name: " + eraName);
    }

    protected void setEras(Era[] eras) {
        this.eras = eras;
    }

    public CalendarDate getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    public CalendarDate getCalendarDate(long millis) {
        return this.getCalendarDate(millis, this.newCalendarDate());
    }

    public CalendarDate getCalendarDate(long millis, TimeZone zone) {
        CalendarDate date = this.newCalendarDate(zone);
        return this.getCalendarDate(millis, date);
    }

    public CalendarDate getCalendarDate(long millis, CalendarDate date) {
        int ms = 0;
        int zoneOffset = 0;
        int saving = 0;
        long days = 0L;
        TimeZone zi = date.getZone();
        if (zi != null) {
            int[] offsets = new int[2];
            zoneOffset = zi.getOffset(millis);
            offsets[0] = zi.getRawOffset();
            offsets[1] = zoneOffset - offsets[0];
            days = zoneOffset / 86400000;
            ms = zoneOffset % 86400000;
            saving = offsets[1];
        }
        date.setZoneOffset(zoneOffset);
        date.setDaylightSaving(saving);
        days += millis / 86400000L;
        if ((ms += (int)(millis % 86400000L)) >= 86400000) {
            ms -= 86400000;
            ++days;
        } else {
            while (ms < 0) {
                ms += 86400000;
                --days;
            }
        }
        this.getCalendarDateFromFixedDate(date, days += 719163L);
        this.setTimeOfDay(date, ms);
        date.setLeapYear(this.isLeapYear(date));
        date.setNormalized(true);
        return date;
    }

    public long getTime(CalendarDate date) {
        long gd = this.getFixedDate(date);
        long ms = (gd - 719163L) * 86400000L + this.getTimeOfDay(date);
        int zoneOffset = 0;
        TimeZone zi = date.getZone();
        if (zi != null) {
            if (date.isNormalized()) {
                return ms - (long)date.getZoneOffset();
            }
            zoneOffset = date.isStandardTime() ? zi.getOffset(ms - (long)zi.getRawOffset()) : zi.getOffset(ms - (long)zi.getRawOffset());
        }
        this.getCalendarDate(ms -= (long)zoneOffset, date);
        return ms;
    }

    protected long getTimeOfDay(CalendarDate date) {
        long fraction = date.getTimeOfDay();
        if (fraction != Long.MIN_VALUE) {
            return fraction;
        }
        fraction = this.getTimeOfDayValue(date);
        date.setTimeOfDay(fraction);
        return fraction;
    }

    public long getTimeOfDayValue(CalendarDate date) {
        long fraction = date.getHours();
        fraction *= 60L;
        fraction += (long)date.getMinutes();
        fraction *= 60L;
        fraction += (long)date.getSeconds();
        fraction *= 1000L;
        return fraction += (long)date.getMillis();
    }

    public CalendarDate setTimeOfDay(CalendarDate cdate, int fraction) {
        if (fraction < 0) {
            throw new IllegalArgumentException();
        }
        boolean normalizedState = cdate.isNormalized();
        int time = fraction;
        int hours = time / 3600000;
        int minutes = (time %= 3600000) / 60000;
        int seconds = (time %= 60000) / 1000;
        time %= 1000;
        cdate.setHours(hours);
        cdate.setMinutes(minutes);
        cdate.setSeconds(seconds);
        cdate.setMillis(time);
        cdate.setTimeOfDay(fraction);
        if (hours < 24 && normalizedState) {
            cdate.setNormalized(normalizedState);
        }
        return cdate;
    }

    public int getWeekLength() {
        return 7;
    }

    protected abstract boolean isLeapYear(CalendarDate var1);

    public CalendarDate getNthDayOfWeek(int nth, int dayOfWeek, CalendarDate date) {
        CalendarDate ndate = (CalendarDate)date.clone();
        this.normalize(ndate);
        long fd = this.getFixedDate(ndate);
        long nfd = nth > 0 ? (long)(7 * nth) + AbstractCalendar.getDayOfWeekDateBefore(fd, dayOfWeek) : (long)(7 * nth) + AbstractCalendar.getDayOfWeekDateAfter(fd, dayOfWeek);
        this.getCalendarDateFromFixedDate(ndate, nfd);
        return ndate;
    }

    static long getDayOfWeekDateBefore(long fixedDate, int dayOfWeek) {
        return AbstractCalendar.getDayOfWeekDateOnOrBefore(fixedDate - 1L, dayOfWeek);
    }

    static long getDayOfWeekDateAfter(long fixedDate, int dayOfWeek) {
        return AbstractCalendar.getDayOfWeekDateOnOrBefore(fixedDate + 7L, dayOfWeek);
    }

    public static long getDayOfWeekDateOnOrBefore(long fixedDate, int dayOfWeek) {
        long fd = fixedDate - (long)(dayOfWeek - 1);
        if (fd >= 0L) {
            return fixedDate - fd % 7L;
        }
        return fixedDate - CalendarUtils.mod(fd, 7L);
    }

    protected abstract long getFixedDate(CalendarDate var1);

    protected abstract void getCalendarDateFromFixedDate(CalendarDate var1, long var2);

    public boolean validateTime(CalendarDate date) {
        int t = date.getHours();
        if (t < 0 || t >= 24) {
            return false;
        }
        t = date.getMinutes();
        if (t < 0 || t >= 60) {
            return false;
        }
        t = date.getSeconds();
        if (t < 0 || t >= 60) {
            return false;
        }
        t = date.getMillis();
        return t >= 0 && t < 1000;
    }

    int normalizeTime(CalendarDate date) {
        long fraction = this.getTimeOfDay(date);
        long days = 0L;
        if (fraction >= 86400000L) {
            days = fraction / 86400000L;
            fraction %= 86400000L;
        } else if (fraction < 0L && (days = CalendarUtils.floorDivide(fraction, 86400000L)) != 0L) {
            fraction -= 86400000L * days;
        }
        if (days != 0L) {
            date.setTimeOfDay(fraction);
        }
        date.setMillis((int)(fraction % 1000L));
        date.setSeconds((int)((fraction /= 1000L) % 60L));
        date.setMinutes((int)((fraction /= 60L) % 60L));
        date.setHours((int)(fraction / 60L));
        return (int)days;
    }
}

