/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.topca.security.x509.extension.logotype.LogotypeAudio;
import cn.topca.security.x509.extension.logotype.LogotypeDetails;
import java.util.Vector;

public class LogotypeData
extends ASN1Encodable {
    ASN1Sequence image = null;
    ASN1Sequence audio = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogotypeData getInstance(ASN1Sequence sequence) {
        ASN1Sequence image = null;
        ASN1Sequence audio = null;
        if (sequence.size() == 1) {
            DEREncodable obj = sequence.getObjectAt(0);
            if (obj instanceof ASN1Sequence) {
                image = ASN1Sequence.getInstance(obj);
            } else {
                if (!(obj instanceof ASN1TaggedObject)) throw new IllegalArgumentException("unknown object in sequence with length 1: " + obj.getClass().getName());
                ASN1TaggedObject first = (ASN1TaggedObject)obj;
                if (first.getTagNo() == 1) {
                    audio = ASN1Sequence.getInstance(first.getObject());
                }
            }
        } else {
            if (sequence.size() != 2) throw new IllegalArgumentException("size of sequence must be 2 not " + sequence.size());
            ASN1TaggedObject first = (ASN1TaggedObject)sequence.getObjectAt(0);
            ASN1TaggedObject second = (ASN1TaggedObject)sequence.getObjectAt(1);
            if (first.getTagNo() == 1) {
                audio = ASN1Sequence.getInstance(first.getObject());
                image = ASN1Sequence.getInstance(second.getObject());
            } else {
                if (second.getTagNo() != 1) throw new IllegalArgumentException("one of the objects in this sequence must be tagged with 1");
                audio = ASN1Sequence.getInstance(second.getObject());
                image = ASN1Sequence.getInstance(first.getObject());
            }
        }
        LogotypeDetails[] images = null;
        if (image != null) {
            Vector<LogotypeDetails> v = new Vector<LogotypeDetails>(image.size());
            for (int i = 0; i < image.size(); ++i) {
                ASN1Sequence seq = ASN1Sequence.getInstance(image.getObjectAt(i));
                LogotypeDetails logotypeImage = LogotypeDetails.getInstance(seq);
                v.add(logotypeImage);
            }
            images = v.toArray(new LogotypeDetails[image.size()]);
        }
        LogotypeAudio[] audios = null;
        if (audio == null) return new LogotypeData(images, audios);
        Vector<LogotypeAudio> v = new Vector<LogotypeAudio>(audio.size());
        for (int i = 0; i < audio.size(); ++i) {
            ASN1Sequence seq = ASN1Sequence.getInstance(audio.getObjectAt(i));
            LogotypeAudio logotypeImage = LogotypeAudio.getInstance(seq);
            v.add(logotypeImage);
        }
        audios = v.toArray(new LogotypeAudio[audio.size()]);
        return new LogotypeData(images, audios);
    }

    public LogotypeData(LogotypeDetails[] image, LogotypeAudio[] audio) {
        int i;
        ASN1EncodableVector v;
        if (image != null) {
            v = new ASN1EncodableVector();
            for (i = 0; i < image.length; ++i) {
                v.add(image[i].toASN1Object());
            }
            this.image = new DERSequence(v);
        } else {
            this.image = null;
        }
        if (audio != null) {
            v = new ASN1EncodableVector();
            for (i = 0; i < audio.length; ++i) {
                v.add(audio[i].toASN1Object());
            }
            this.audio = new DERSequence(v);
        } else {
            this.audio = null;
        }
    }

    public LogotypeDetails[] getImages() {
        Vector<LogotypeDetails> v = new Vector<LogotypeDetails>();
        for (int i = 0; i < this.image.size(); ++i) {
            v.add(LogotypeDetails.getInstance(this.image.getObjectAt(i)));
        }
        LogotypeDetails[] images = v.toArray(new LogotypeDetails[this.image.size()]);
        return images;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.image != null) {
            v.add(this.image);
        }
        if (this.audio != null) {
            v.add(new DERTaggedObject(true, 1, this.audio));
        }
        return new DERSequence(v);
    }
}

