/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base;

import cn.topca.security.sm.TopSMProvider;
import com.itrus.base.CAConstant;
import com.itrus.base.ClientConfig;
import com.itrus.util.SystemConstant;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ClientConfParser
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(ClientConfParser.class);
    private static ClientConfParser instance = null;
    private ClientConfig clientConf = null;
    private StringBuilder sb = new StringBuilder();

    private ClientConfParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientConfParser getInstance() {
        if (instance != null) return instance;
        Class<ClientConfParser> clazz = ClientConfParser.class;
        synchronized (ClientConfParser.class) {
            if (instance != null) return instance;
            instance = new ClientConfParser();
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            if (Security.getProperty("TopSM") != null) return instance;
            Security.addProvider(new TopSMProvider());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ClientConfig getClientConfig() {
        if (this.clientConf == null) {
            if (CAConstant.P11_CFG != null) {
                System.out.println(CAConstant.P11_CFG);
                log.info((Object)("P11_CFG[" + CAConstant.P11_CFG + "]"));
                File cfgFile = new File(CAConstant.P11_CFG);
                this.parse(cfgFile);
            } else {
                throw new RuntimeException("\u672a\u627e\u5230\u914d\u7f6e\u6587\u4ef6<p11Config.xml>");
            }
        }
        log.info((Object)"get clientConfig end");
        return this.clientConf;
    }

    public ClientConfig getClientConfig(String config) {
        if (config == null) {
            return this.getClientConfig();
        }
        if (this.clientConf == null) {
            String p11config = config.concat(SystemConstant.FILE_SPARATOR).concat("itrusclientcfg").concat(SystemConstant.FILE_SPARATOR).concat("p11config.xml");
            File cfgFile = new File(p11config);
            this.parse(cfgFile);
        }
        log.info((Object)"get clientConfig end");
        return this.clientConf;
    }

    private void parse(File cfgFile) {
        try {
            log.info((Object)("p11CfgFath:[" + cfgFile.getAbsolutePath() + "]"));
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (!cfgFile.exists()) {
                throw new RuntimeException("\u521d\u59cb\u5316\u5ba2\u6237\u7aefp11\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:\np11\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230");
            }
            SAXParser parser = factory.newSAXParser();
            parser.parse(cfgFile, (DefaultHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u521d\u59cb\u5316\u5ba2\u6237\u7aefp11\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:\n" + e.getMessage());
        }
    }

    public void characters(char[] ac, int i, int j) throws SAXException {
        this.sb.append(ac, i, j);
    }

    public void endDocument() throws SAXException {
        this.sb.setLength(0);
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("DefaultKeyPin".equalsIgnoreCase(name)) {
            this.clientConf.setDefaultKeyPin(this.sb.toString().trim());
        } else if ("RememberPin".equalsIgnoreCase(name)) {
            this.clientConf.setRememberPin(this.sb.toString().trim());
        } else if ("AccountId".equalsIgnoreCase(name)) {
            this.clientConf.setAccountId(this.sb.toString().trim());
        }
        this.sb.setLength(0);
    }

    public void startDocument() throws SAXException {
        this.sb.setLength(0);
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("ITRUSAPI".equalsIgnoreCase(name)) {
            this.clientConf = new ClientConfig();
        } else if ("Provider".equalsIgnoreCase(name)) {
            String key = attributes.getValue("key").trim();
            String value = attributes.getValue("value").trim();
            String alias = attributes.getValue("name").trim();
            this.clientConf.addProvider(key, value);
            this.clientConf.addNames(key, alias);
        }
    }

    public static void main(String[] args) {
        System.out.println(CAConstant.CFG_CLIENT);
        System.out.println(CAConstant.LOG4J_CFG);
        ClientConfig config = ClientConfParser.getInstance().getClientConfig(null);
        System.out.println(config.getNames().toString());
    }
}

