/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base;

import com.itrus.base.CAConstant;
import com.itrus.base.ServerConfig;
import com.itrus.base.service.CodeEnvCheck;
import com.itrus.base.service.ServerKeyStore;
import com.itrus.base.util.ConfigParserUtil;
import com.itrus.base.util.DESUtil;
import com.itrus.cvm.CVM;
import com.itrus.util.SystemConstant;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ServerConfParser {
    private static final Logger log = Logger.getLogger(ServerConfParser.class);
    private static ServerConfParser instance = null;
    private static ServerConfig serverConfig = new ServerConfig();
    private static boolean initflag = false;
    private static final String L = "(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),";

    private ServerConfParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerConfParser getInstance() {
        if (instance != null) return instance;
        Class<ServerConfParser> clazz = ServerConfParser.class;
        synchronized (ServerConfParser.class) {
            if (instance != null) return instance;
            instance = new ServerConfParser();
            if (Security.getProvider("BC") != null) return instance;
            Security.addProvider((Provider)new BouncyCastleProvider());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ServerConfig getServerConfig() {
        block5: {
            ServerConfParser.log.info((Object)">>getServerConfig()");
            ServerConfParser.log.info((Object)("bcprov version:[" + Security.getProvider("BC").getVersion() + "]"));
            bcprovClass = BouncyCastleProvider.class;
            bcprovJarPath = bcprovClass.getResource(String.valueOf(bcprovClass.getSimpleName()) + ".class").getPath();
            ServerConfParser.log.info((Object)("bcprov Jar AbsolutePath:[" + bcprovJarPath + "]"));
            if (ServerConfParser.initflag) {
                return ServerConfParser.serverConfig;
            }
            try {
                this.svsConfig(CAConstant.ITRUSONE_CFG);
                this.dbConfig(CAConstant.DB_CFG);
                this.cvmConfig(CAConstant.CVM_CFG);
                this.obmConfig(CAConstant.SERVERCERT_CONFIG);
                cert = ServerKeyStore.getInstance(ServerConfParser.serverConfig).getCert();
                if (!CodeEnvCheck.check(CAConstant.CODELICENSE, cert)) {
                    ServerConfParser.serverConfig = null;
                    ServerConfParser.log.error((Object)"CA\u5b89\u5168\u7b56\u7565\u9a8c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbCA\u5382\u5546\u7533\u8bf7\u5b89\u5168\u7b56\u7565\u6587\u4ef6");
                    throw new RuntimeException("CA\u5b89\u5168\u7b56\u7565\u9a8c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbCA\u5382\u5546\u7533\u8bf7\u5b89\u5168\u7b56\u7565\u6587\u4ef6");
                }
                ServerConfParser.initflag = true;
                ServerConfParser.log.info((Object)"get ServerConfig end!");
                return ServerConfParser.serverConfig;
            }
            catch (Exception e) {
                if (!"NullPoint".equals(e.getMessage()) || new File(CAConstant.CODELICENSE).exists()) break block5;
                map = CVM.getCRLContexts();
                issues = map.keySet();
                ** for (issue : issues)
            }
lbl-1000:
            // 1 sources

            {
                ServerConfParser.log.error((Object)("EAS750\u5347\u7ea7\u4e13\u7528\u8bb8\u53ef" + issue));
                continue;
            }
lbl28:
            // 1 sources

            return ServerConfParser.serverConfig;
        }
        ServerConfParser.log.error((Object)e.getMessage(), (Throwable)e);
        throw new RuntimeException("serverConfig initialize failed \u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25");
    }

    /*
     * Unable to fully structure code
     */
    public ServerConfig getServerConfig(String config) {
        block6: {
            ServerConfParser.log.info((Object)(">>getServerConfig(" + config + ")"));
            ServerConfParser.log.info((Object)("bcprov version:[" + Security.getProvider("BC").getVersion() + "]"));
            bcprovClass = BouncyCastleProvider.class;
            bcprovJarPath = bcprovClass.getResource(String.valueOf(bcprovClass.getSimpleName()) + ".class").getPath();
            ServerConfParser.log.info((Object)("bcprov Jar AbsolutePath:[" + bcprovJarPath + "]"));
            if (ServerConfParser.initflag) {
                return ServerConfParser.serverConfig;
            }
            if (config == null) {
                return this.getServerConfig();
            }
            try {
                itrusOneconfig = config.concat(SystemConstant.FILE_SPARATOR).concat("itrusservercfg").concat(SystemConstant.FILE_SPARATOR).concat("itrusone.properties");
                dbconfig = config.concat(SystemConstant.FILE_SPARATOR).concat("itrusservercfg").concat(SystemConstant.FILE_SPARATOR).concat("datasource.properties");
                obsmconfig = config.concat(SystemConstant.FILE_SPARATOR).concat("itrusservercfg").concat(SystemConstant.FILE_SPARATOR).concat("servercert.properties");
                cvmconfig = config.concat(SystemConstant.FILE_SPARATOR).concat("itrusservercfg").concat(SystemConstant.FILE_SPARATOR).concat("cvm.xml");
                licenseconfig = config.concat(SystemConstant.FILE_SPARATOR).concat("itrusservercfg").concat(SystemConstant.FILE_SPARATOR).concat("codelicense");
                this.svsConfig(itrusOneconfig);
                this.dbConfig(dbconfig);
                this.cvmConfig(cvmconfig);
                this.obmConfig(obsmconfig);
                cert = ServerKeyStore.getInstance(ServerConfParser.serverConfig).getCert();
                if (!CodeEnvCheck.check(licenseconfig, cert)) {
                    ServerConfParser.serverConfig = null;
                    ServerConfParser.log.error((Object)"CA\u5b89\u5168\u7b56\u7565\u9a8c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbCA\u5382\u5546\u7533\u8bf7\u5b89\u5168\u7b56\u7565\u6587\u4ef6");
                    throw new RuntimeException("CA\u5b89\u5168\u7b56\u7565\u9a8c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbCA\u5382\u5546\u7533\u8bf7\u5b89\u5168\u7b56\u7565\u6587\u4ef6");
                }
                ServerConfParser.initflag = true;
                ServerConfParser.log.info((Object)"get ServerConfig end!");
                return ServerConfParser.serverConfig;
            }
            catch (Exception e) {
                if (!"NullPoint".equals(e.getMessage()) || new File(CAConstant.CODELICENSE).exists()) break block6;
                map = CVM.getCRLContexts();
                issues = map.keySet();
                ** for (issue : issues)
            }
lbl-1000:
            // 1 sources

            {
                ServerConfParser.log.error((Object)"(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),");
                ServerConfParser.log.error((Object)("EAS750\u5347\u7ea7\u4e13\u7528\u8bb8\u53ef" + issue));
                continue;
            }
lbl36:
            // 1 sources

            return ServerConfParser.serverConfig;
        }
        ServerConfParser.log.error((Object)e.getMessage(), (Throwable)e);
        throw new RuntimeException("serverConfig initialize failed \u670d\u52a1\u7aef\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25");
    }

    private void obmConfig(String path) throws Exception {
        String certEncryption;
        String certEncryptionEnabled;
        String signkeypass;
        String signfilepwd;
        log.info((Object)">>obmConfig()");
        if (new File(path).exists()) {
            ConfigParserUtil prop = new ConfigParserUtil();
            FileInputStream in = new FileInputStream(path);
            prop.load(in);
            ((InputStream)in).close();
            String signcertpath = prop.getProperty("signcertpath");
            String encodecertpath = prop.getProperty("encodecertpath");
            signfilepwd = prop.getProperty("signfilepwd");
            String signcerttype = prop.getProperty("signcerttype");
            String signkeyalias = prop.getProperty("signkeyalias");
            signkeypass = prop.getProperty("signkeypass");
            certEncryptionEnabled = prop.getProperty("certEncryptionEnabled");
            certEncryption = prop.getProperty("certEncryption");
            serverConfig.setSigncertpath(signcertpath);
            serverConfig.setSigncerttype(signcerttype);
            serverConfig.setSignkeyalias(signkeyalias);
            serverConfig.setEncodecertpath(encodecertpath);
            if (certEncryptionEnabled != null && certEncryptionEnabled.equalsIgnoreCase("true")) {
                if (certEncryption != null && certEncryption.equalsIgnoreCase("true")) {
                    if (signfilepwd != null) {
                        signfilepwd = DESUtil.decrymessage(signfilepwd);
                    }
                    if (signkeypass != null) {
                        signkeypass = DESUtil.decrymessage(signkeypass);
                    }
                } else {
                    if (signfilepwd != null) {
                        String enc_signfilepwd = DESUtil.encrymessage(signfilepwd);
                        prop.setProperty("signfilepwd", enc_signfilepwd);
                    }
                    if (signkeypass != null) {
                        String enc_signkeypass = DESUtil.encrymessage(signkeypass);
                        prop.setProperty("signkeypass", enc_signkeypass);
                    }
                    prop.setProperty("certEncryption", "true");
                    FileOutputStream outputFile = new FileOutputStream(path);
                    prop.store(outputFile, "update datasourceConfig");
                    ((OutputStream)outputFile).close();
                }
            } else if (signcertpath == null) {
                log.info((Object)"obmConfig filed ..");
                throw new Exception("NullPoint");
            }
        } else {
            log.info((Object)"obmConfig filed ..");
            throw new Exception("NullPoint");
        }
        serverConfig.setSignfilepwd(signfilepwd);
        serverConfig.setSignkeypass(signkeypass);
        serverConfig.setCertEncryption(certEncryption);
        serverConfig.setCertEncryptionEnabled(certEncryptionEnabled);
        log.info((Object)"obmConfig finish ..");
    }

    private void cvmConfig(String path) {
        log.info((Object)">>cvmConfig()");
        log.info((Object)("cvmconfig:" + path));
        try {
            if (new File(path).exists()) {
                log.info((Object)"cvm.xml exists,CVM initlizing ..");
                CVM.config(path);
            }
        }
        catch (Exception e) {
            log.warn((Object)"CVM initlizing catch an exception:");
            log.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        log.info((Object)"cvmConfig finish ..");
    }

    private void dbConfig(String path) throws Exception {
        log.info((Object)">>dbConfig()");
        if (new File(path).exists()) {
            ConfigParserUtil prop = new ConfigParserUtil();
            FileInputStream in = new FileInputStream(path);
            prop.load(in);
            ((InputStream)in).close();
            String dbmodel = prop.getProperty("dbmodel");
            String ica_driverclass = prop.getProperty("ica_driverclass");
            String ica_dburl = prop.getProperty("ica_dburl");
            String ica_user = prop.getProperty("ica_user");
            String ica_password = prop.getProperty("ica_password");
            String top_driverclass = prop.getProperty("top_driverclass");
            String top_dburl = prop.getProperty("top_dburl");
            String top_user = prop.getProperty("top_user");
            String top_password = prop.getProperty("top_password");
            String dbEncryption = prop.getProperty("dbEncryption");
            String dbEncryptionEnabled = prop.getProperty("dbEncryptionEnabled");
            serverConfig.setDbmodel(dbmodel);
            serverConfig.setIca_driverclass(ica_driverclass);
            serverConfig.setIca_dburl(ica_dburl);
            serverConfig.setIca_user(ica_user);
            serverConfig.setTop_dburl(top_dburl);
            serverConfig.setTop_driverclass(top_driverclass);
            serverConfig.setTop_user(top_user);
            if (dbEncryptionEnabled != null && dbEncryptionEnabled.equalsIgnoreCase("true")) {
                if (dbEncryption != null && dbEncryption.equalsIgnoreCase("true")) {
                    if (ica_password != null) {
                        ica_password = DESUtil.decrymessage(ica_password);
                    }
                    if (top_password != null) {
                        top_password = DESUtil.decrymessage(top_password);
                    }
                } else {
                    if (ica_password != null) {
                        String enc_ica_password = DESUtil.encrymessage(ica_password);
                        prop.setProperty("ica_password", enc_ica_password);
                    }
                    if (top_password != null) {
                        String enc_top_password = DESUtil.encrymessage(top_password);
                        prop.setProperty("top_password", enc_top_password);
                    }
                    prop.setProperty("certEncryption", "true");
                    prop.setProperty("dbEncryption", "true");
                    FileOutputStream outputFile = new FileOutputStream(path);
                    prop.store(outputFile, "update datasourceConfig");
                    ((OutputStream)outputFile).close();
                }
            }
            serverConfig.setIca_password(ica_password);
            serverConfig.setTop_password(top_password);
            serverConfig.setDbencryptionEnabled(dbEncryptionEnabled);
            serverConfig.setDbencryption(dbEncryption);
        }
        log.info((Object)"dbConfig finish ..");
    }

    private void svsConfig(String path) throws Exception {
        log.info((Object)">>svsConfig()");
        if (new File(path).exists()) {
            ConfigParserUtil prop = new ConfigParserUtil();
            FileInputStream in = new FileInputStream(path);
            prop.load(in);
            String svs_used = prop.getProperty("USED");
            String svs_host = prop.getProperty("HOST");
            String svs_port = prop.getProperty("PORT");
            serverConfig.setSvs_used(svs_used);
            serverConfig.setSvs_port(svs_port);
            serverConfig.setSvs_host(svs_host);
            ((InputStream)in).close();
        }
        log.info((Object)"svsConfig finish ..");
    }
}

