/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.service;

import cn.topca.security.pkcs11.jna.PKCS11;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import com.itrus.base.CAConstant;
import com.itrus.base.ClientConfParser;
import com.itrus.base.ClientConfig;
import com.itrus.base.service.PKCS11Service;
import com.itrus.base.util.ListDialog;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.Recipient;
import com.itrus.cryptorole.bc.RecipientBcImpl;
import com.itrus.util.Base64;
import com.itrus.util.CertUtils;
import com.itrus.util.CertificateUtil;
import com.itrus.util.DataUtil;
import com.itrus.util.NoMatchingException;
import com.itrus.util.SystemConstant;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ClientSignService {
    private static final Logger log = Logger.getLogger(ClientSignService.class);
    private static ClientConfig config;
    private PKCS11Service ps = null;
    private PKCS11 p11 = null;
    private X509Certificate cert = null;
    private String uid = null;
    private String alias = "";
    private boolean pointNeeded = true;

    public ClientSignService() {
        log.info((Object)">>ClientSignService()");
        config = ClientConfParser.getInstance().getClientConfig();
        this.ps = new PKCS11Service();
    }

    public ClientSignService(String path) {
        log.info((Object)(">>ClientSignService(" + path + ")"));
        config = ClientConfParser.getInstance().getClientConfig(path);
        this.ps = new PKCS11Service();
    }

    public String isUsbKeyExist() {
        log.info((Object)">>isUsbKeyExistent()");
        if (this.p11 != null) {
            try {
                this.ps.getTokenInfo();
                return this.alias;
            }
            catch (Exception e) {
                this.ps.reset();
                this.reset();
                return null;
            }
        }
        Map<String, String> providers = config.getProviders();
        Map<String, String> aliases = config.getNames();
        log.info((Object)("providers" + providers));
        if (providers != null) {
            for (String name : providers.keySet()) {
                String library = providers.get(name);
                log.debug((Object)("name:" + name));
                log.debug((Object)("library:" + library));
                if (CAConstant.WINDOWS_SYSTEM32 == null) {
                    log.error((Object)"\u672a\u627e\u5230SYSTEM32\u76ee\u5f55");
                    throw new RuntimeException("SYSTEM32 directory not found");
                }
                String providerLibPath = CAConstant.WINDOWS_SYSTEM32.concat(SystemConstant.FILE_SPARATOR).concat(library);
                log.debug((Object)("providerLibPath:" + providerLibPath));
                this.p11 = this.ps.getPKCS11Instance(providerLibPath);
                if (this.p11 == null) {
                    log.error((Object)"p11 instance is null ");
                }
                if (this.p11 == null) continue;
                try {
                    if (this.ps.getKeySlot() == -1L) continue;
                    log.info((Object)"isUsbKeyExistent: YES");
                    this.alias = aliases.get(name);
                    return this.alias;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            log.warn((Object)"providers is null!");
            throw new RuntimeException("\u5ba2\u6237\u7aef\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01");
        }
        log.info((Object)"UsbKeyExistent return false ");
        return null;
    }

    public String getCertSN() {
        log.info((Object)">>getCertSN()");
        try {
            if (this.cert == null) {
                this.initUserInfo();
            }
            String serialNumber = this.cert.getSerialNumber().toString(16);
            serialNumber = serialNumber.replaceAll("[^0-9|^a-f|^A-F]", "");
            serialNumber = CertUtils.getICAValidSerialNumber(serialNumber);
            serialNumber = serialNumber.trim();
            log.info((Object)(">>return [Serialnumber[" + serialNumber.trim() + "]"));
            return serialNumber;
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"Error getCertSN return null");
        return null;
    }

    public String getUserIdentifier() {
        log.info((Object)">>getUserIdentifier()");
        try {
            if (this.cert == null) {
                this.initUserInfo();
            }
            log.info((Object)("uid[" + this.uid + "]"));
            return this.uid;
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"Error getNCUserIdentifier return null");
        return null;
    }

    public X509Certificate getCert() throws CertificateException, PKCS11Exception {
        if (this.cert == null) {
            this.initUserInfo();
        }
        return this.cert;
    }

    public boolean hasLoginOn() {
        log.info((Object)">>hasLoginOn()");
        try {
            long sessionState = this.ps.getSessionState();
            log.info((Object)("sessionState[" + sessionState + "]"));
            if (sessionState == 3L) {
                log.info((Object)"hasLoginOn return true");
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        log.error((Object)"hasLoginOn return false");
        return false;
    }

    public boolean loginUsbkey(char[] password) {
        log.info((Object)">>loginUsbkey()");
        if (!(password != null && password.length >= 1 || "finger".equalsIgnoreCase(this.alias))) {
            log.error((Object)"passwd is null");
            return false;
        }
        try {
            if (this.cert == null || this.uid == null) {
                this.initUserInfo();
            }
            return this.ps.usbKeyLogin(password, this.alias);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.error((Object)"loginUsbkey return false");
            return false;
        }
    }

    public byte[] sign(byte[] plaintext) throws Exception {
        String msg;
        log.info((Object)">>sign()");
        log.info((Object)("plaintext[HEX:" + DataUtil.transformByteArrayToHexString(plaintext) + "]"));
        long num = this.check_certDate();
        if (num >= 0L && num <= 30L && this.pointNeeded) {
            msg = "\u8bc1\u4e66\u6709\u6548\u671f\u8fd8\u5269\u4f59" + num + "\u5929\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u53ca\u65f6\u66f4\u65b0";
            log.error((Object)msg);
            try {
                JOptionPane.showMessageDialog(null, msg, "\u63d0\u793a", 2);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage(), (Throwable)e);
            }
            this.pointNeeded = false;
        }
        if (num < 0L) {
            msg = "\u8bc1\u4e66\u5df2\u8fc7\u671f";
            log.info((Object)msg);
            try {
                JOptionPane.showMessageDialog(null, msg, "\u63d0\u793a", 2);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage(), (Throwable)e);
            }
            log.error((Object)"\u8bc1\u4e66\u8fc7\u671f   \u7b7e\u540d\u5931\u8d25 ");
            throw new RuntimeException("\u8bc1\u4e66\u8fc7\u671f   \u7b7e\u540d\u5931\u8d25");
        }
        long privateKeyHandle = this.ps.getPrivateKeyHandle(this.cert);
        log.info((Object)("privateKeyHandle[" + privateKeyHandle + "]"));
        String signAlgorithm = "SHA1WithRSA";
        log.info((Object)("cert.getPublicKey().getAlgorithm()[" + this.cert.getPublicKey().getAlgorithm() + "]"));
        if (!this.cert.getPublicKey().getAlgorithm().equals("RSA")) {
            log.info((Object)"\u9a8c\u8bc1\u4e3aSM2\u8bc1\u4e66   signAlgorithm[SM3WithSM2]");
            signAlgorithm = "SM3WithSM2";
        }
        try {
            byte[] sinature = this.ps.sign(privateKeyHandle, plaintext, signAlgorithm);
            log.info((Object)("sinature[HEX:" + Base64.encode(sinature) + "]"));
            return sinature;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.error((Object)"Error! sign return null");
            return null;
        }
    }

    public int verifySignature(byte[] plainText, byte[] signature, X509Certificate cert) {
        block6: {
            log.info((Object)">>verifySignature(..X509Certificate.)");
            boolean flag = false;
            RecipientBcImpl rp = new RecipientBcImpl();
            if (!cert.getPublicKey().getAlgorithm().equals("RSA")) {
                log.info((Object)"SM2 Verify");
                flag = ((Recipient)rp).doVerify(plainText, signature, cert, "SM3withSM2");
            } else {
                log.info((Object)"RSA Verify");
                flag = ((Recipient)rp).doVerify(plainText, signature, cert, "SHA1withRSA");
            }
            if (!flag) break block6;
            log.info((Object)"\u9a8c\u8bc1\u901a\u8fc7  ret[201]");
            return 201;
        }
        try {
            log.error((Object)"\u9a8c\u8bc1\u5931\u8d25 ret[204]");
            return 204;
        }
        catch (NotSupportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"\u9a8c\u8bc1\u5931\u8d25 ret[304]");
        return 304;
    }

    private void initUserInfo() throws CertificateException, PKCS11Exception {
        log.info((Object)">>initUserInfo()");
        HashMap<byte[], X509Certificate> certMap = this.ps.getCertMap();
        HashMap<String, X509Certificate> matchcertMap = new HashMap<String, X509Certificate>();
        Set<byte[]> certKeyIDs = certMap.keySet();
        for (byte[] certKid : certKeyIDs) {
            X509Certificate x509cert = certMap.get(certKid);
            log.info((Object)("certMap for each:(subjectDN)" + x509cert.getSubjectDN().getName()));
            try {
                String userid = CertificateUtil.matchSubject(x509cert, "(?<=OU\\s{0,1}=\\s{0,1}UID\\s{0,1}:\\s{0,1})[^,]+(?=\\s{0,1},{0,1})", 0);
                matchcertMap.put(userid, x509cert);
                log.info((Object)("cert match userid[" + userid + "]"));
            }
            catch (NoMatchingException e) {
                log.error((Object)e.getMessage());
            }
        }
        if (matchcertMap.size() == 1) {
            Map.Entry en = matchcertMap.entrySet().iterator().next();
            this.uid = (String)en.getKey();
            this.cert = (X509Certificate)en.getValue();
        } else if (matchcertMap.size() > 1) {
            try {
                this.uid = (String)JOptionPane.showInputDialog(null, "\u9009\u62e9\u7528\u6237\u8bc1\u4e66", "\u8bf7\u9009\u62e9\u767b\u9646\u7528\u6237", 1, null, matchcertMap.keySet().toArray(), matchcertMap.keySet().toArray()[0]);
                this.cert = (X509Certificate)matchcertMap.get(this.uid);
            }
            catch (Exception e) {
                String[] names = matchcertMap.keySet().toArray(new String[matchcertMap.size()]);
                this.uid = ListDialog.showDialog(null, null, "\u9009\u62e9\u7528\u6237\u8bc1\u4e66", "\u8bf7\u9009\u62e9\u767b\u9646\u7528\u6237", names, names[0], null);
                this.cert = (X509Certificate)matchcertMap.get(this.uid);
            }
        }
    }

    private long check_certDate() {
        log.info((Object)">>check_certDate()");
        if (this.cert == null) {
            throw new RuntimeException("user cert is null,\u672a\u627e\u5230\u7528\u6237\u8bc1\u4e66");
        }
        Date curTime = new Date();
        Date certNotAfterdate = this.cert.getNotAfter();
        int days = (int)((certNotAfterdate.getTime() - curTime.getTime()) / 86400000L);
        return days;
    }

    private void reset() {
        log.info((Object)">>reset()");
        this.p11 = null;
        this.cert = null;
        this.uid = null;
    }
}

