/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.service;

import cn.topca.security.util.CertUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreService {
    private static final Logger log = Logger.getLogger(KeyStoreService.class);
    private KeyStore ks;

    public KeyStoreService() {
    }

    public KeyStoreService(String filePath, String certType, String alias, String storePass, String keyPass) {
        log.info((Object)">>KeyStoreService()");
        log.info((Object)("certType[" + certType + "]"));
        if (certType.equalsIgnoreCase("PKCS12")) {
            this.initPFX(filePath, storePass);
        } else if (certType.equalsIgnoreCase("JKS")) {
            this.initJKS(filePath, storePass);
        } else {
            throw new RuntimeException("initialize Keystore error");
        }
    }

    public void initPFX(String filePath, String storePass) {
        log.info((Object)">>initPFX()");
        try {
            if (this.ks == null) {
                FileInputStream in = new FileInputStream(filePath);
                this.ks = KeyStore.getInstance("PKCS12");
                this.ks.load(in, storePass.toCharArray());
                ((InputStream)in).close();
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void initJKS(String filePath, String storePass) {
        log.info((Object)">>initJKS()");
        try {
            if (this.ks == null) {
                FileInputStream in = new FileInputStream(filePath);
                this.ks = KeyStore.getInstance("JKS");
                this.ks.load(in, storePass.toCharArray());
            }
        }
        catch (KeyStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public X509Certificate getCertificate(String id) throws KeyStoreException {
        log.info((Object)(">>getCertificate(" + id + ")"));
        if (id == null || id.equalsIgnoreCase("")) {
            Enumeration<String> enums = this.ks.aliases();
            while (enums.hasMoreElements()) {
                String alias = enums.nextElement();
                if (!this.ks.isKeyEntry(alias)) continue;
                return (X509Certificate)this.ks.getCertificate(alias);
            }
        }
        return (X509Certificate)this.ks.getCertificate(id);
    }

    public PrivateKey getPrivateKey(String id, String keypass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        log.info((Object)(">>getPrivateKey(" + id + ")"));
        if (id == null || id.equalsIgnoreCase("")) {
            Enumeration<String> enums = this.ks.aliases();
            while (enums.hasMoreElements()) {
                String alias = enums.nextElement();
                if (!this.ks.isKeyEntry(alias)) continue;
                return (PrivateKey)this.ks.getKey(alias, keypass.toCharArray());
            }
        }
        return (PrivateKey)this.ks.getKey(id, keypass.toCharArray());
    }

    public boolean containsId(String id) throws KeyStoreException {
        log.info((Object)("keystore containsAlias(" + id + ")=[" + this.ks.containsAlias(id) + "]"));
        if (!this.ks.containsAlias(id)) {
            Enumeration<String> e = this.ks.aliases();
            while (e.hasMoreElements()) {
                String s = e.nextElement();
                log.info((Object)("alias:[" + s + "]"));
                log.info((Object)("s.equals(id):" + s.equals(id)));
            }
            log.info((Object)("containsAlias:" + this.ks.containsAlias(id)));
        }
        return this.ks.containsAlias(id);
    }

    public List<X509Certificate> getEncryCertificateList(String dir) throws FileNotFoundException, CertificateException {
        log.info((Object)(">>getEncryCertificateList(" + dir + ")"));
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        File cerFilePath = new File(dir);
        if (cerFilePath.exists()) {
            File[] fileArray = cerFilePath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    File file = fileArray[n2];
                    if (file.isFile() && (file.getName().endsWith(".cer") || file.getName().endsWith(".crt"))) {
                        FileInputStream in = null;
                        try {
                            in = new FileInputStream(file);
                            X509Certificate cert = (X509Certificate)CertUtil.convertCertificate(in);
                            log.info((Object)("EncryCert's Subjetc DN:" + cert.getSubjectDN().getName()));
                            log.info((Object)">>>add the EncryCert into the certList");
                            certList.add(cert);
                        }
                        catch (FileNotFoundException e) {
                            log.error((Object)e.getMessage());
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block20;
                        }
                        catch (CertificateException e) {
                            try {
                                log.error((Object)e.getMessage());
                                break block20;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (in != null) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        if (in == null) break block20;
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
        }
        return certList;
    }
}

