/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.service;

import com.itrus.base.ServerConfig;
import com.itrus.base.service.KeyStoreService;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class ServerKeyStore {
    private static final Logger log = Logger.getLogger(ServerKeyStore.class);
    private static ServerKeyStore service = null;
    private KeyStoreService kss = null;
    private X509Certificate cert = null;
    private PrivateKey priKey = null;
    private boolean initFlag = false;

    private ServerKeyStore() {
    }

    private ServerKeyStore(ServerConfig config) throws Exception {
        if (!this.initFlag) {
            this.init(config);
        }
    }

    private void init(ServerConfig config) throws Exception {
        log.info((Object)">>init()");
        this.kss = new KeyStoreService(config.getSigncertpath(), config.getSigncerttype(), config.getSignkeyalias(), config.getSignfilepwd(), config.getSignkeypass());
        this.cert = this.kss.getCertificate(config.getSignkeyalias());
        this.priKey = config.getSigncerttype() != null && config.getSigncerttype().equalsIgnoreCase("jks") ? this.kss.getPrivateKey(config.getSignkeyalias(), config.getSignkeypass()) : this.kss.getPrivateKey(config.getSignkeyalias(), config.getSignfilepwd());
        this.initFlag = true;
    }

    public boolean containsId(String id) throws KeyStoreException {
        log.info((Object)(">>containsId(" + id + ")"));
        return this.kss.containsId(id);
    }

    public X509Certificate getCert() {
        log.info((Object)">>getCert()");
        return this.cert;
    }

    public PrivateKey getPrivateKey() {
        log.info((Object)">>getPrivateKey()");
        return this.priKey;
    }

    public static ServerKeyStore getInstance(ServerConfig config) throws Exception {
        log.info((Object)">>getInstance(.)");
        if (service == null) {
            service = new ServerKeyStore(config);
        }
        return service;
    }
}

