/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListDialog
extends JDialog
implements ActionListener {
    private static ListDialog dialog;
    private static String value;
    private JList list;

    static {
        value = "";
    }

    public static String showDialog(Component frameComp, Component locationComp, String labelText, String title, String[] possibleValues, String initialValue, String longValue) {
        Frame frame = JOptionPane.getFrameForComponent(frameComp);
        dialog = new ListDialog(frame, locationComp, labelText, title, possibleValues, initialValue, longValue);
        if (frameComp == null) {
            dialog.setDefaultCloseOperation(2);
        }
        dialog.setVisible(true);
        return value;
    }

    public static void close() {
        dialog.dispose();
    }

    private void setValue(String newValue) {
        value = newValue;
        this.list.setSelectedValue(value, true);
    }

    private ListDialog(Frame frame, Component locationComp, String labelText, String title, Object[] data, String initialValue, String longValue) {
        super(frame, title, true);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        final JButton setButton = new JButton("Set");
        setButton.setActionCommand("Set");
        setButton.addActionListener(this);
        this.getRootPane().setDefaultButton(setButton);
        this.list = new JList(data){

            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                int row;
                if (orientation == 1 && direction < 0 && (row = this.getFirstVisibleIndex()) != -1) {
                    Rectangle r = this.getCellBounds(row, row);
                    if (r.y == visibleRect.y && row != 0) {
                        Point loc = r.getLocation();
                        --loc.y;
                        int prevIndex = this.locationToIndex(loc);
                        Rectangle prevR = this.getCellBounds(prevIndex, prevIndex);
                        if (prevR == null || prevR.y >= r.y) {
                            return 0;
                        }
                        return prevR.height;
                    }
                }
                return super.getScrollableUnitIncrement(visibleRect, orientation, direction);
            }
        };
        this.list.setSelectionMode(1);
        if (longValue != null) {
            this.list.setPrototypeCellValue(longValue);
        }
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    setButton.doClick();
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 3));
        JLabel label = new JLabel(labelText);
        label.setLabelFor(this.list);
        listPane.add(label);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(listScroller);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(setButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setValue(initialValue);
        this.pack();
        this.setLocationRelativeTo(locationComp);
    }

    public void actionPerformed(ActionEvent e) {
        if ("Set".equals(e.getActionCommand())) {
            value = (String)this.list.getSelectedValue();
        }
        dialog.dispose();
    }
}

