/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.util;

import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import cn.topca.security.util.ObjectIdentifier;
import cn.topca.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SignatureException;

public class PKCS11ServiceUtil {
    public static byte[] getFormateData(byte[] plaintext, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = null;
        if (algorithm.equalsIgnoreCase("MD5withRSA")) {
            md = MessageDigest.getInstance("MD5");
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            md = MessageDigest.getInstance("SHA-1");
        } else if (algorithm.equalsIgnoreCase("MD2withRSA")) {
            md = MessageDigest.getInstance("MD2");
        } else if (algorithm.equalsIgnoreCase("SHA256withRSA")) {
            md = MessageDigest.getInstance("SHA-256");
        } else if (algorithm.equalsIgnoreCase("SHA384withRSA")) {
            md = MessageDigest.getInstance("SHA-384");
        } else if (algorithm.equalsIgnoreCase("SHA512withRSA")) {
            md = MessageDigest.getInstance("SHA-512");
        } else {
            throw new ProviderException("Unknown signature: " + algorithm);
        }
        md.update(plaintext);
        return md.digest();
    }

    public static byte[] encodeSignature(byte[] digest, String algorithm) throws SignatureException {
        try {
            ObjectIdentifier digestOID = null;
            if (algorithm.equalsIgnoreCase("MD5withRSA")) {
                digestOID = AlgorithmId.MD5_oid;
            } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
                digestOID = AlgorithmId.SHA_oid;
            } else if (algorithm.equalsIgnoreCase("MD2withRSA")) {
                digestOID = AlgorithmId.MD2_oid;
            } else if (algorithm.equalsIgnoreCase("SHA256withRSA")) {
                digestOID = AlgorithmId.SHA256_oid;
            } else if (algorithm.equalsIgnoreCase("SHA384withRSA")) {
                digestOID = AlgorithmId.SHA384_oid;
            } else if (algorithm.equalsIgnoreCase("SHA512withRSA")) {
                digestOID = AlgorithmId.SHA512_oid;
            } else {
                throw new ProviderException("Unknown signature: " + algorithm);
            }
            DerOutputStream out = new DerOutputStream();
            new AlgorithmId(digestOID).encode(out);
            out.putOctetString(digest);
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new SignatureException("Invalid encoding", e);
        }
    }
}

