/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.x509.CertificateList;
import cn.tca.TopBasicCrypto.jce.provider.X509CRLObject;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.util.CertUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.util.Date;

public class X509CRL
extends X509CRLObject {
    public X509CRL(CertificateList c) throws CRLException {
        super(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509CRL getInstanceFromURL(String uRLString) throws IOException, CRLException {
        X509CRL x509CRL = null;
        HttpURLConnection httpURL = null;
        try {
            URL url = new URL(uRLString);
            httpURL = (HttpURLConnection)url.openConnection();
            httpURL.addRequestProperty("User-agent", "Mozilla/4.0+(compatible;+MSIE+6.0;+Windows+NT+5.1;+SV1)");
            x509CRL = X509CRL.getInstance(httpURL.getInputStream());
        }
        finally {
            httpURL.disconnect();
        }
        return x509CRL;
    }

    public static X509CRL getInstanceFromFile(String cRLFileName) throws FileNotFoundException, CRLException {
        FileInputStream fis = new FileInputStream(cRLFileName);
        return X509CRL.engineGenerateCRL(fis);
    }

    public static X509CRL getInstance(java.security.cert.X509CRL crl) throws CRLException {
        return X509CRL.getInstance(crl.getEncoded());
    }

    public static X509CRL getInstance(String pemCRLString) throws CRLException {
        ASN1InputStream in = new ASN1InputStream(pemCRLString.getBytes());
        return X509CRL.engineGenerateCRL(in);
    }

    public static X509CRL getInstance(byte[] derCRLEncoded) throws CRLException {
        ASN1InputStream in = new ASN1InputStream(derCRLEncoded);
        return X509CRL.engineGenerateCRL(in);
    }

    public static X509CRL getInstance(InputStream in) throws CRLException {
        return X509CRL.engineGenerateCRL(in);
    }

    public String getIssuerDNString() {
        return CertUtils.getX509NameString(this.getIssuerX500Principal());
    }

    public boolean isOnValidPeriod() {
        Date thisUpdate = this.getThisUpdate();
        Date nextUpdate = this.getNextUpdate();
        Date now = new Date();
        return !now.before(thisUpdate) && !now.after(nextUpdate);
    }

    public static X509CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        if (!inStream.markSupported()) {
            inStream = new BufferedInputStream(inStream);
        }
        try {
            inStream.mark(10);
            if (inStream.read() != 48) {
                inStream.reset();
                return X509CRL.readPEMCRL(inStream);
            }
            inStream.reset();
            return X509CRL.readDERCRL(inStream);
        }
        catch (Exception e) {
            throw new CRLException(e.toString());
        }
    }

    private static X509CRL readDERCRL(InputStream in) throws IOException, CRLException {
        ASN1InputStream dIn = new ASN1InputStream(in);
        return new X509CRL(new CertificateList((ASN1Sequence)dIn.readObject()));
    }

    private static X509CRL readPEMCRL(InputStream in) throws IOException, CRLException {
        String line;
        StringBuffer pemBuf = new StringBuffer();
        while ((line = X509CRL.readLine(in)) != null) {
            if (line.equals("-----BEGIN CRL-----") || line.equals("-----BEGIN X509 CRL-----") || line.equals("-----END CRL-----") || line.equals("-----END X509 CRL-----")) continue;
            pemBuf.append(line);
        }
        if (pemBuf.length() != 0) {
            ByteArrayInputStream bIn = new ByteArrayInputStream(Base64.decode(pemBuf.toString()));
            return X509CRL.readDERCRL(bIn);
        }
        return null;
    }

    private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer l = new StringBuffer();
        while ((c = in.read()) != 10 && c >= 0) {
            if (c == 13) continue;
            l.append((char)c);
        }
        if (l.length() == 0 && c < 0) {
            return null;
        }
        return l.toString();
    }

    @Override
    public void verify(PublicKey publickey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publickey, "BC");
    }

    @Override
    public void verify(PublicKey publickey, String s) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (AlgorithmId.SM3withSM2_oid.toString().equals(super.getSigAlgOID())) {
            Signature signature = Signature.getInstance("SM3withSM2");
            signature.initVerify(publickey);
            signature.update(this.getTBSCertList());
            if (!signature.verify(this.getSignature())) {
                throw new SignatureException("CRL does not verify with supplied public key.");
            }
        } else {
            super.verify(publickey, s);
        }
    }

    static {
        Security.addProvider(new TopSMProvider());
    }
}

