/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cms.jcajce;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.RecipientId;
import com.itrus.cms.CMSEnvelopedAsymmetricDecryptor;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class CMSEnvelopedRSADecryptor
implements CMSEnvelopedAsymmetricDecryptor {
    private X509Certificate certificate;
    private RSAPrivateKey privateKey;

    public CMSEnvelopedRSADecryptor(X509Certificate cert, RSAPrivateKey privateKey) {
        this.certificate = cert;
        this.privateKey = privateKey;
    }

    @Override
    public boolean interested(RecipientId rid, AlgorithmIdentifier keyEncAlg) {
        return rid.match(this.certificate);
    }

    @Override
    public Key decrypt(byte[] encryptedKey, String keyAlgorithm) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
            try {
                cipher.init(4, this.privateKey);
                Key key = cipher.unwrap(encryptedKey, keyAlgorithm, 3);
                return key;
            }
            catch (Exception e) {
                System.out.println("unwrap mode failed,try decrypt mode.");
                cipher.init(2, this.privateKey);
                return new SecretKeySpec(cipher.doFinal(encryptedKey), keyAlgorithm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

