/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cryptorole;

import cn.tca.TopBasicCrypto.cms.CMSEnvelopedGenerator;
import cn.tca.TopBasicCrypto.cms.CMSSignedGenerator;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.SigningServerException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Vector;

public abstract class Sender {
    protected PrivateKey keyOfSigner;
    protected X509Certificate certOfSigner;
    protected Vector recipientCerts = new Vector();
    protected String signAlgorithm = "SHA1withRSA";
    protected String encryptAlgorithm = CMSEnvelopedGenerator.DES_EDE3_CBC;
    protected String digestOID = CMSSignedGenerator.DIGEST_SHA1;
    protected String notSupportMessage = "\u60a8\u8c03\u7528\u4e86\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff0c" + this.getClass().getName() + "\u4e2d\u5c1a\u672a\u91cd\u8f7d\u3002";
    protected String notInitializeKeyMessage = "\u672a\u6307\u5b9a\u53d1\u9001\u8005\uff08\u7b7e\u540d\u8bc1\u4e66\u6216\u79c1\u94a5\uff09\uff0c\u8bf7\u5148\u8c03\u7528initCertWithKey\u65b9\u6cd5\u3002";
    protected String notAddEncryptCertMessage = "\u672a\u6307\u5b9a\u63a5\u6536\u8005\uff08\u52a0\u5bc6\u8bc1\u4e66\uff09\uff0c\u8bf7\u5148\u8c03\u7528addRecipientCert\u65b9\u6cd5\u3002";

    public void initCertWithKey(PrivateKey priKey, X509Certificate cert) {
        this.keyOfSigner = priKey;
        this.certOfSigner = cert;
    }

    public void initCertWithKey(String keyStoreFileName, char[] keyStorePassword, String keyAlias, char[] keyPassword) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void initCertWithKey(String pfxFileName, char[] keyPassword) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void initCertWithKey(String pemCertFileName, String pemKeyFileName, char[] keyPassword) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void initCertWithKey(String issuerDN, String serialNumber) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void initCertWithKey(String signingServerIp, int signingServerPort, String serialNumber) throws NotSupportException, CryptoException, SigningServerException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void setSignAlgorithm(String algorithmName) {
        this.signAlgorithm = algorithmName;
    }

    public X509Certificate getSignerCert() throws NotSupportException, CryptoException {
        if (this.keyOfSigner == null || this.certOfSigner == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        return this.certOfSigner;
    }

    public byte[] doSign(byte[] originalMessage) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] signMessage(byte[] originalMessage) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] signMessageIncludeOriginal(byte[] originalMessage) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void addRecipientCert(X509Certificate cert) {
        this.recipientCerts.add(cert);
    }

    public void setEncryptAlgorithm(String algorithmName) {
        this.encryptAlgorithm = algorithmName;
    }

    public byte[] encryptMessage(byte[] originalMessage) throws NotSupportException, CryptoException {
        if (this.recipientCerts.size() == 0) {
            throw new CryptoException("\u672a\u627e\u5230\u4efb\u4f55\u52a0\u5bc6\u8bc1\u4e66\uff01\u52a0\u5bc6\u524d\u8bf7\u5148\u8c03\u7528addRecipientCert\u65b9\u6cd5\u3002");
        }
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] encryptMessageEx(byte[] originalMessage) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void encryptFile(String originalFileName, String destinationFileName) throws CryptoException, NotSupportException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public void encryptFileEx(String srcFileName, String encryptedFileName) throws CryptoException, NotSupportException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] signAndEnvelopMessage(byte[] originalMessage) throws CryptoException, NotSupportException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public byte[] getTimeStamp(byte[] originalMessage, String url) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }

    public boolean verifyFileTimestamp(byte[] originalMessage, byte[] TimeStampmessage, String url, long projectCloseTime) throws NotSupportException, CryptoException {
        throw new NotSupportException(this.notSupportMessage);
    }
}

