/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cryptorole.bc;

import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.WindowsCertStore;
import com.itrus.cryptorole.bc.SenderBcImpl;
import com.itrus.security.pkcs.PKCS7SignedData;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class SenderSunMSCAPIImpl
extends SenderBcImpl {
    private WindowsCertStore windowsCertStore;

    public SenderSunMSCAPIImpl(WindowsCertStore windowsCertStore) {
        this.windowsCertStore = windowsCertStore;
    }

    public void initCertWithKey(X509Certificate certOfSigner) throws CryptoException {
        this.certOfSigner = certOfSigner;
        try {
            this.keyOfSigner = this.windowsCertStore.getPrivateKey(certOfSigner);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        if (this.keyOfSigner == null) {
            throw new CryptoException("\u6307\u5b9a\u7684\u8bc1\u4e66[" + certOfSigner.getSubjectDN().toString() + "]\u6ca1\u6709\u79c1\u94a5\u3002");
        }
    }

    @Override
    public byte[] signMessage(byte[] originalMessage) throws CryptoException {
        if (this.keyOfSigner == null || this.certOfSigner == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        Certificate[] chain = new X509Certificate[]{this.certOfSigner};
        try {
            PKCS7SignedData p7Object = new PKCS7SignedData(this.keyOfSigner, chain, this.signAlgorithm.substring(0, this.signAlgorithm.indexOf("With")), this.windowsCertStore.getProvider().getName());
            p7Object.update(originalMessage, 0, originalMessage.length);
            return p7Object.getEncoded();
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }
}

