/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cvm;

import com.itrus.util.RegexUtils;

public class CRLContextConfInfo {
    private String cAFilePath;
    private String cRLFilePath;
    private String cRLUrl;
    private int[] retryPolicy = new int[]{60, 600, 6000};
    private boolean isNotCheckCRL = false;
    private String accountHash;
    private boolean timingDownload = false;

    public boolean isTimingDownload() {
        return this.timingDownload;
    }

    public void setTimingDownload(boolean timingDownload) {
        this.timingDownload = timingDownload;
    }

    public String getAccountHash() {
        return this.accountHash;
    }

    public void setAccountHash(String accountHash) {
        this.accountHash = accountHash;
    }

    public String getCAFilePath() {
        if (this.cAFilePath != null) {
            this.cAFilePath = this.cAFilePath.trim();
        }
        return this.cAFilePath;
    }

    public void setCAFilePath(String filePath) {
        if (filePath != null && !"".equals(filePath)) {
            this.cAFilePath = filePath;
        }
    }

    public boolean isNotCheckCRL() {
        return this.isNotCheckCRL;
    }

    public void setNotCheckCRL(boolean isNotCheckCRL) {
        this.isNotCheckCRL = isNotCheckCRL;
    }

    public String getCRLFilePath() {
        if (this.cRLFilePath == null) {
            this.cRLFilePath = RegexUtils.replaceLastIgnoreCase(this.getCAFilePath(), ".cer|.crt|.pem", ".crl");
        }
        return this.cRLFilePath;
    }

    public void setCRLFilePath(String filePath) {
        if (filePath != null && !"".equals(filePath)) {
            this.cRLFilePath = filePath;
        }
    }

    public String getCRLUrl() {
        if (this.cRLUrl != null) {
            this.cRLUrl = this.cRLUrl.trim();
        }
        return this.cRLUrl;
    }

    public void setCRLUrl(String url) {
        if (url != null && !"".equals(url)) {
            this.cRLUrl = url.trim().replaceAll(" ", "%20");
            this.cRLUrl = this.cRLUrl.replaceAll("\"", "%22");
        }
    }

    public int[] getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(int[] retryPolicy) {
        if (retryPolicy != null) {
            this.retryPolicy = retryPolicy;
        }
    }
}

