/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.obm;

import cn.topca.security.util.CertUtil;
import com.itrus.base.ServerConfParser;
import com.itrus.base.ServerConfig;
import com.itrus.base.service.CVMService;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.Recipient;
import com.itrus.cryptorole.Sender;
import com.itrus.cryptorole.SignatureVerifyException;
import com.itrus.cryptorole.bc.RecipientBcImpl;
import com.itrus.cryptorole.bc.SenderBcImpl;
import com.itrus.svm.SVM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class iTrusObm {
    private static final Logger log = Logger.getLogger(iTrusObm.class);
    private static ServerConfig config = ServerConfParser.getInstance().getServerConfig();

    public String sign(String plaintext) throws Exception {
        SenderBcImpl sender;
        log.info((Object)">>sign()");
        log.info((Object)("plaintext[" + plaintext + "]"));
        byte[] pkcs7 = null;
        if (plaintext == null || plaintext.equals("")) {
            log.error((Object)"\u4f20\u5165\u539f\u6587\u4e3a\u7a7a plaintext is null");
            throw new RuntimeException("\u4f20\u5165\u539f\u6587\u4e3a\u7a7a");
        }
        String signcertpath = config.getSigncertpath();
        String signfilepwd = config.getSignfilepwd();
        String signkeyalias = config.getSignkeyalias();
        String signkeypass = config.getSignkeypass();
        if (signcertpath == null || signcertpath.equals("")) {
            log.error((Object)"\u4f20\u5165\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a signcertpath is null");
            throw new RuntimeException("\u4f20\u5165\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a signcertpath is null");
        }
        if (signfilepwd == null || signfilepwd.equals("")) {
            log.error((Object)"\u4f20\u5165\u8bc1\u4e66\u4fdd\u62a4\u5bc6\u7801\u4e3a\u7a7a signfilepwd is null");
            throw new RuntimeException("\u4f20\u5165\u8bc1\u4e66\u4fdd\u62a4\u4e3a\u7a7a signfilepwd is null");
        }
        if (config.getSigncerttype().equalsIgnoreCase("jks")) {
            if (signkeyalias == null || signkeyalias.equals("")) {
                log.error((Object)"\u4f20\u5165\u8bc1\u4e66\u522b\u540d\u4e3a\u7a7a signkeyalias is null");
                throw new RuntimeException("\u4f20\u5165\u8bc1\u4e66\u522b\u540d\u4e3a\u7a7a signkeyalias is null");
            }
            if (signkeypass == null || signkeypass.equals("")) {
                log.error((Object)"\u4f20\u5165\u8bc1\u4e66\u79c1\u94a5\u4fdd\u62a4\u5bc6\u7801\u4e3a\u7a7a signkeypass is null");
                throw new RuntimeException("\u4f20\u5165\u8bc1\u4e66\u79c1\u94a5\u4fdd\u62a4\u5bc6\u7801\u4e3a\u7a7a signkeypass is null");
            }
            try {
                sender = new SenderBcImpl();
                ((Sender)sender).initCertWithKey(config.getSigncertpath(), config.getSignfilepwd().toCharArray(), config.getSignkeyalias(), config.getSignkeypass().toCharArray());
                pkcs7 = ((Sender)sender).signMessage(plaintext.getBytes("UTF-8"));
            }
            catch (NotSupportException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CryptoException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (config.getSigncerttype().equalsIgnoreCase("PKCS12")) {
            try {
                sender = new SenderBcImpl();
                ((Sender)sender).initCertWithKey(config.getSigncertpath(), config.getSignfilepwd().toCharArray());
                pkcs7 = ((Sender)sender).signMessage(plaintext.getBytes("UTF-8"));
            }
            catch (NotSupportException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CryptoException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8bc1\u4e66\u683c\u5f0f");
        }
        if (pkcs7 != null) {
            String signature = new String(Base64.encode(pkcs7));
            log.info((Object)"convert '+' to '*' for Obm");
            log.info((Object)("\u5f00\u59cb\u8f6c\u6362\u524d=[" + signature + "]"));
            while (signature.indexOf("+") > -1) {
                signature = signature.replace('+', '*');
            }
            log.info((Object)("\u8f6c\u6362\u540e=[" + signature + "]"));
            return signature;
        }
        log.error((Object)"\u7b7e\u540d\u5931\u8d25,return null!");
        return null;
    }

    public boolean verify(String plaintext, String signatureBase64) throws Exception {
        log.info((Object)">>verify()");
        log.info((Object)("plaintext[" + plaintext + "]"));
        log.info((Object)("signatureBase64[" + signatureBase64 + "]"));
        try {
            log.info((Object)"convert '*' to '+' for Obm");
            while (signatureBase64.indexOf("*") > -1) {
                signatureBase64 = signatureBase64.replace('*', '+');
            }
            log.info((Object)("\u8f6c\u6362\u540e=[" + signatureBase64 + "]"));
            X509Certificate cert = SVM.verifySignature(plaintext.getBytes("UTF-8"), signatureBase64);
            int ret = CVMService.doCVM(cert);
            log.info((Object)("CVM verify Cert ret =[" + ret + "]"));
            if (ret == 0) {
                log.info((Object)"\u9a8c\u8bc1\u901a\u8fc7\uff0c verify success");
                return true;
            }
        }
        catch (SignatureVerifyException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.info((Object)"verify return false");
        return false;
    }

    public String decode(String encryMsgBase64) throws Exception {
        log.info((Object)">>decode()");
        log.info((Object)("encryMsg[" + encryMsgBase64 + "]"));
        byte[] oribyte = null;
        log.info((Object)"convert '*' to '+' for Obm");
        while (encryMsgBase64.indexOf("*") > -1) {
            encryMsgBase64 = encryMsgBase64.replace('*', '+');
        }
        if (config.getSigncerttype().equalsIgnoreCase("jks")) {
            try {
                RecipientBcImpl rp = new RecipientBcImpl();
                ((Recipient)rp).initCertWithKey(config.getSigncertpath(), config.getSignfilepwd().toCharArray(), config.getSignkeyalias(), config.getSignkeypass().toCharArray());
                oribyte = ((Recipient)rp).decryptMessage(Base64.decode((String)encryMsgBase64));
                return new String(oribyte, "UTF-8");
            }
            catch (NotSupportException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CryptoException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (config.getSigncerttype().equalsIgnoreCase("PKCS12")) {
            try {
                RecipientBcImpl rp = new RecipientBcImpl();
                ((Recipient)rp).initCertWithKey(config.getSigncertpath(), config.getSignfilepwd().toCharArray());
                oribyte = ((Recipient)rp).decryptMessage(Base64.decode((String)encryMsgBase64));
                return new String(oribyte, "UTF-8");
            }
            catch (NotSupportException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (CryptoException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8bc1\u4e66\u683c\u5f0f");
        }
        log.error((Object)"EAS\u7aef \u89e3\u5bc6\u5931\u8d25,return null!");
        return null;
    }

    public String encode(String plaintext) throws Exception {
        log.info((Object)">>encode()");
        log.info((Object)("plaintext[" + plaintext + "]"));
        try {
            SenderBcImpl sender = new SenderBcImpl();
            List<X509Certificate> certs = this.getEncryCertificateList(config.getEncodecertpath());
            for (X509Certificate cert : certs) {
                log.info((Object)("return EncryCertificate cert's DN[" + cert.getSubjectDN().getName() + "]"));
                sender.addRecipientCert(cert);
            }
            byte[] encry = ((Sender)sender).encryptMessage(plaintext.getBytes("UTF-8"));
            if (encry != null) {
                String encrydata = new String(Base64.encode((byte[])encry));
                log.info((Object)"convert '+' to '*' for Obm");
                log.info((Object)("\u5f00\u59cb\u8f6c\u6362\u524d=[" + encrydata + "]"));
                while (encrydata.indexOf("+") > -1) {
                    encrydata = encrydata.replace('+', '*');
                }
                log.info((Object)("\u8f6c\u6362\u540e=[" + encrydata + "]"));
                return encrydata;
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NotSupportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"EAS\u7aef \u52a0\u5bc6\u5931\u8d25,return null!");
        return null;
    }

    private List<X509Certificate> getEncryCertificateList(String dir) throws FileNotFoundException, CertificateException {
        log.info((Object)(">>getEncryCertificateList(" + dir + ")"));
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        File cerFilePath = new File(dir);
        if (cerFilePath.exists()) {
            File[] fileArray = cerFilePath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block20: {
                    File file = fileArray[n2];
                    if (file.isFile() && (file.getName().endsWith(".cer") || file.getName().endsWith(".crt"))) {
                        FileInputStream in = null;
                        try {
                            in = new FileInputStream(file);
                            X509Certificate cert = (X509Certificate)CertUtil.convertCertificate(in);
                            log.info((Object)("EncryCert's Subjetc DN:" + cert.getSubjectDN().getName()));
                            log.info((Object)">>>add the EncryCert into the certList");
                            certList.add(cert);
                        }
                        catch (FileNotFoundException e) {
                            log.error((Object)e.getMessage());
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block20;
                        }
                        catch (CertificateException e) {
                            try {
                                log.error((Object)e.getMessage());
                                break block20;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (in != null) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        if (in == null) break block20;
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
        }
        return certList;
    }
}

