/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.pki.rsa;

import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerValue;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.base.ServerConfParser;
import com.itrus.base.ServerConfig;
import com.itrus.base.dao.CertDao;
import com.itrus.base.dao.CertInfo;
import com.itrus.base.service.CVMService;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.Recipient;
import com.itrus.cryptorole.Sender;
import com.itrus.cryptorole.bc.RecipientBcImpl;
import com.itrus.cryptorole.bc.SenderBcImpl;
import com.itrus.security.rsa.RSACore;
import com.itrus.security.rsa.RSAPadding;
import com.itrus.util.Base64;
import com.itrus.util.CertUtils;
import com.itrus.util.CertificateUtil;
import com.itrus.util.DataUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class iTrusRSAAPI {
    private static final Logger log = Logger.getLogger(iTrusRSAAPI.class);
    private static ServerConfig config;

    public iTrusRSAAPI() {
        log.info((Object)">>iTrusRSAAPI()");
        config = ServerConfParser.getInstance().getServerConfig();
    }

    public iTrusRSAAPI(String path) {
        log.info((Object)(">>iTrusRSAAPI(" + path + ")"));
        config = ServerConfParser.getInstance().getServerConfig(path);
    }

    public X509Certificate getX509Certificate(String certBuf) {
        log.info((Object)(">>getX509Certificate(" + certBuf + ")"));
        byte[] certificate = Base64.decode(certBuf);
        return this.getX509CertificateFormBytes(certificate);
    }

    public X509Certificate getX509CertificateFormBytes(byte[] certificate) {
        log.info((Object)">>getX509CertificateFormBytes()");
        log.debug((Object)("certBytesHex:[" + DataUtil.transformByteArrayToHexString(certificate) + "]"));
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(certificate);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "TopSM");
            if (bais.available() > 0) {
                X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                return cert;
            }
        }
        catch (CertificateException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (NoSuchProviderException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        return null;
    }

    public byte[] exportCertificate(String serialNumber) throws Exception {
        log.info((Object)(">>exportCertificate(" + serialNumber + ")"));
        CertInfo certinfo = this.getCertInfoFromDb(serialNumber);
        if (certinfo != null && certinfo.getCertSignBuf() != null) {
            X509Certificate cert = this.getX509Certificate(certinfo.getCertSignBuf());
            if (cert != null) {
                log.info((Object)("userCert sbjuect[" + cert.getSubjectX500Principal().getName() + "]"));
                return cert.getEncoded();
            }
            log.error((Object)"Error! \u83b7\u53d6X509\u8bc1\u4e66\u9519\u8bef,parse X509Certificate error");
            log.error((Object)("Error! certbuf[" + certinfo.getCertSignBuf() + "]"));
            return null;
        }
        log.error((Object)"exportCertificate certinfo is null");
        return null;
    }

    public int verifyCert(X509Certificate userCert) {
        log.info((Object)">>verifyCert()");
        return CVMService.doCVM(userCert);
    }

    public int verify(byte[] plaintext, byte[] signature, X509Certificate cert) throws Exception {
        log.info((Object)">>verify(plaintext,signature,cert)");
        log.info((Object)"getCertFromRAServer=false");
        if (plaintext == null || plaintext.equals("")) {
            log.error((Object)"\u4f20\u5165\u539f\u6587\u4e3a\u7a7a plaintext is null");
            throw new RuntimeException("\u4f20\u5165\u539f\u6587\u4e3a\u7a7a");
        }
        if (signature == null || signature.equals("")) {
            log.error((Object)"\u4f20\u5165\u7b7e\u540d\u503c\u4e3a\u7a7a signature is null ");
            throw new RuntimeException("\u4f20\u5165\u7b7e\u540d\u503c\u4e3a\u7a7a");
        }
        if (cert == null) {
            log.error((Object)"\u4f20\u5165X509\u8bc1\u4e66\u4e3a\u7a7a  cert is null ");
            throw new RuntimeException("\u4f20\u5165X509\u8bc1\u4e66\u4e3a\u7a7a");
        }
        log.info((Object)("plaintext[HEX:" + DataUtil.transformByteArrayToHexString(plaintext) + "]"));
        log.info((Object)("signature[HEX:" + DataUtil.transformByteArrayToHexString(signature) + "]"));
        log.info((Object)("cert[HEX:" + DataUtil.transformByteArrayToHexString(cert.getEncoded()) + "]"));
        return this.verifySignature(plaintext, signature, cert);
    }

    public int verify(String serialNumber, byte[] plaintext, byte[] signature) throws Exception {
        log.info((Object)">>>verify(serialNumber,plaintext,signature)");
        log.info((Object)"getCertFromRAServer=true");
        if (plaintext == null || plaintext.equals("")) {
            log.error((Object)"\u4f20\u5165\u539f\u6587\u4e3a\u7a7a plaintext is null");
            throw new RuntimeException("\u4f20\u5165\u539f\u6587\u4e3a\u7a7a");
        }
        if (signature == null || signature.equals("")) {
            log.error((Object)"\u4f20\u5165\u7b7e\u540d\u503c\u4e3a\u7a7a signature is null ");
            throw new RuntimeException("\u4f20\u5165\u7b7e\u540d\u503c\u4e3a\u7a7a");
        }
        if (serialNumber == null) {
            log.error((Object)"\u4f20\u5165\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e3a\u7a7a  serialNumber is null ");
            throw new RuntimeException("\u4f20\u5165\u8bc1\u4e66\u5e8f\u5217\u53f7\u4e3a\u7a7a");
        }
        log.info((Object)("plaintext[HEX:" + DataUtil.transformByteArrayToHexString(plaintext) + "]"));
        log.info((Object)("signature[HEX:" + DataUtil.transformByteArrayToHexString(signature) + "]"));
        log.info((Object)("serialNumber[HEX:" + serialNumber + "]"));
        CertInfo certinfo = this.getCertInfoFromDb(serialNumber);
        if (certinfo == null || certinfo.getCertSignBuf() == null) {
            log.error((Object)"certinfo is null");
            log.error((Object)"verifyClientSignature return [221]");
            return 221;
        }
        String certBuf = certinfo.getCertSignBuf();
        X509Certificate cert = this.getX509Certificate(certBuf);
        if (cert == null) {
            log.error((Object)"Error! \u83b7\u53d6X509\u8bc1\u4e66\u9519\u8bef,parse X509Certificate error");
            log.error((Object)("Error! certbuf[" + certinfo.getCertSignBuf() + "]"));
            log.error((Object)"verifyClientSignature return [219]");
            return 219;
        }
        if (certinfo.getStatus() != null && certinfo.getStatus().equalsIgnoreCase("REVOKE")) {
            log.error((Object)("\u8bc1\u4e66\u88ab\u540a\u9500\uff1acert status[" + certinfo.getStatus() + "]"));
            log.error((Object)"verifyClientSignature return [206]");
            return 206;
        }
        return this.verifySignature(plaintext, signature, cert);
    }

    public byte[] MessageEncrypt(X509Certificate encryptCert, byte[] sourceMsg) {
        log.info((Object)">>MessageEncrypt()");
        SenderBcImpl sd = new SenderBcImpl();
        sd.addRecipientCert(encryptCert);
        try {
            byte[] enceydata = ((Sender)sd).encryptMessage(sourceMsg);
            log.error((Object)"MessageEncrypt  success");
            log.info((Object)("enceydata[" + Base64.encode(enceydata) + "]"));
            return enceydata;
        }
        catch (NotSupportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"MessageEncrypt  failed return null");
        return null;
    }

    public byte[] MessageDecrypt(String pfxFilePath, String password, String keyAlias, byte[] encryptBuf) {
        log.info((Object)">>MessageDecrypt()");
        log.info((Object)("pfxFilePath[" + pfxFilePath + "]"));
        log.info((Object)("keyAlias[" + keyAlias + "]"));
        log.info((Object)("encryptBuf[" + Base64.encode(encryptBuf) + "]"));
        try {
            RecipientBcImpl rp = new RecipientBcImpl();
            if (pfxFilePath.endsWith(".pfx") || pfxFilePath.endsWith(".PFX")) {
                ((Recipient)rp).initCertWithKey(pfxFilePath, password.toCharArray());
            } else {
                ((Recipient)rp).initCertWithKey(pfxFilePath, password.toCharArray(), keyAlias, password.toCharArray());
            }
            byte[] sourcedata = ((Recipient)rp).decryptMessage(encryptBuf);
            log.error((Object)"MessageDecrypt  success");
            return sourcedata;
        }
        catch (NotSupportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"MessageDecrypt  failed return null");
        return null;
    }

    private int verifySignature(byte[] plaintext, byte[] signature, X509Certificate cert) {
        block7: {
            log.info((Object)">>verifySignature(..X509Certificate.)");
            log.info((Object)"\u5f00\u59cb\u8bc1\u4e66CVM\u9a8c\u8bc1,CVM verifyCert");
            int ret = CVMService.doCVM(cert);
            log.info((Object)("CVM verifyCert  ret[" + ret + "]"));
            if (ret != 0) {
                log.info((Object)"CVM verifyCert \u9a8c\u8bc1\u672a\u901a\u8fc7");
                return ret;
            }
            log.info((Object)"\u5f00\u59cb\u9a8c\u8bc1\u7b7e\u540d\u503c,RecipientBcImpl");
            boolean flag = false;
            RecipientBcImpl rp = new RecipientBcImpl();
            if (cert.getPublicKey().getAlgorithm().equals("SM2") || cert.getPublicKey().getAlgorithm().equals(AlgorithmId.SM2_oid.toString())) {
                log.info((Object)"SM2 Verify");
                flag = ((Recipient)rp).doVerify(plaintext, signature, cert, "SM3withSM2");
            } else {
                log.info((Object)"RSA Verify");
                flag = this.compatibleVerify(plaintext, signature, cert.getPublicKey());
            }
            if (!flag) break block7;
            log.info((Object)"\u9a8c\u8bc1\u901a\u8fc7  ret[201]");
            return 201;
        }
        try {
            log.error((Object)"\u9a8c\u8bc1\u5931\u8d25 ret[204]");
            return 204;
        }
        catch (NotSupportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"\u9a8c\u8bc1\u5931\u8d25 ret[304]");
        return 304;
    }

    private boolean compatibleVerify(byte[] plaintext, byte[] signature, PublicKey publicKey) {
        log.info((Object)">>compatibleVerify(...)");
        try {
            ASN1InputStream is = new ASN1InputStream(publicKey.getEncoded());
            ASN1Primitive obj = is.readObject();
            ASN1Sequence seq = (ASN1Sequence)obj;
            SubjectPublicKeyInfo pkInfo = SubjectPublicKeyInfo.getInstance((Object)seq);
            RSAPublicKeyStructure pubk = RSAPublicKeyStructure.getInstance((Object)pkInfo.getPublicKey());
            BigInteger mod = pubk.getModulus();
            int i = RSACore.getByteLength(mod);
            RSAPadding padding = RSAPadding.getInstance(1, i, null);
            byte[] rsaByte = RSACore.rsa(signature, (RSAPublicKey)publicKey);
            log.debug((Object)"\u89e3\u5bc6\u6210\u529f");
            byte[] unpadRsaByte = padding.unpad(rsaByte);
            log.debug((Object)"unpading success");
            DerInputStream localDerInputStream = new DerInputStream(unpadRsaByte);
            DerValue[] arrayOfDerValue = localDerInputStream.getSequence(2);
            if (arrayOfDerValue.length != 2 || localDerInputStream.available() != 0) {
                log.error((Object)"decodeSignature\u5931\u8d25\uff0cSEQUENCE length error");
                throw new IOException("SEQUENCE length error");
            }
            AlgorithmId localAlgorithmId = AlgorithmId.parse(arrayOfDerValue[0]);
            if (localAlgorithmId.getEncodedParams() != null) {
                log.error((Object)"hash\u7b97\u6cd5\u89e3\u6790\u5931\u8d25");
                throw new IOException("Unexpected AlgorithmId parameters");
            }
            String oid = localAlgorithmId.getOID().toString();
            String HashAlgorithm = AlgorithmId.get(oid).toString();
            MessageDigest md = MessageDigest.getInstance(HashAlgorithm);
            md.update(plaintext);
            byte[] arrayOfByte2 = md.digest();
            byte[] arrayOfByte1 = arrayOfDerValue[1].getOctetString();
            if (Arrays.equals(arrayOfByte1, arrayOfByte2)) {
                log.info((Object)"compatibleVerify return true");
                return true;
            }
        }
        catch (InvalidKeyException e) {
            System.out.println(e);
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException localInvalidAlgorithmParameterException) {
            try {
                throw new InvalidKeyException(localInvalidAlgorithmParameterException.getMessage());
            }
            catch (InvalidKeyException e) {
                System.out.println(e);
                log.error((Object)e.getMessage(), e.getCause());
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (BadPaddingException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        log.error((Object)"compatibleVerify return false");
        return false;
    }

    private CertInfo getCertInfoFromDb(String serialNumber) {
        log.info((Object)(">>getCertInfoFromDb(" + serialNumber + ")"));
        serialNumber = CertUtils.getICAValidSerialNumber(serialNumber);
        log.info((Object)("getICAValidSerialNumber return [" + serialNumber + "]"));
        CertDao certDao = new CertDao();
        CertInfo certinfo = certDao.findCertByCertSerialnumber(serialNumber);
        if (certinfo == null || certinfo.getCertSignBuf() == null) {
            log.error((Object)"exportCertificate certinfo is null");
            return null;
        }
        try {
            X509Certificate cert = this.getX509Certificate(certinfo.getCertSignBuf());
            if (!CertUtils.isOnValidPeriod(cert) || certinfo.getStatus().equalsIgnoreCase("REVOKE")) {
                CertInfo newcertInfo;
                String uid = CertificateUtil.matchSubject(cert, "(?<=OU\\s{0,1}=\\s{0,1}UID\\s{0,1}:\\s{0,1})[^,]+(?=\\s{0,1},{0,1})", 0);
                log.info((Object)("\u8bc1\u4e66:[" + cert.getSubjectDN().getName() + "];\n\u4f7f\u7528uid:[" + uid + "]\u67e5\u627e\u66f4\u65b0\u8bc1\u4e66.."));
                if (uid != null && (newcertInfo = certDao.findByCertUID(uid)) != null && newcertInfo.getCertSignBuf() != null) {
                    certinfo = newcertInfo;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return certinfo;
    }
}

