/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.pki.rsa.server;

import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerValue;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.base.ServerConfParser;
import com.itrus.base.ServerConfig;
import com.itrus.base.service.CVMService;
import com.itrus.base.service.ServerKeyStore;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.Recipient;
import com.itrus.cryptorole.bc.RecipientBcImpl;
import com.itrus.security.rsa.RSACore;
import com.itrus.security.rsa.RSAPadding;
import com.itrus.util.DataUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class iTrusServerSignVerify {
    private static final Logger log = Logger.getLogger(iTrusServerSignVerify.class);
    private static ServerConfig config = ServerConfParser.getInstance().getServerConfig();

    public iTrusServerSignVerify() {
        log.info((Object)">>iTrusServerSign()");
    }

    public byte[] exportCertificate() {
        log.info((Object)">>exportCertificate()");
        try {
            return ServerKeyStore.getInstance(config).getCert().getEncoded();
        }
        catch (CertificateEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public byte[] sign(byte[] plainText) {
        log.info((Object)(">>sign(plaintext[HEX:" + DataUtil.transformByteArrayToHexString(plainText) + "]"));
        try {
            PrivateKey privatekey = ServerKeyStore.getInstance(config).getPrivateKey();
            Signature signature = !privatekey.getAlgorithm().equalsIgnoreCase("RSA") ? Signature.getInstance("SM3withSM2") : Signature.getInstance("SHA1withRSA");
            signature.initSign(privatekey);
            signature.update(plainText);
            byte[] signdata = signature.sign();
            return signdata;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (SignatureException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        log.error((Object)"\u7b7e\u540d\u5931\u8d25 doSign error return null");
        return null;
    }

    public int verify(byte[] plainText, byte[] signature) {
        int flag;
        block3: {
            log.info((Object)(">>verify(plaintext[HEX:" + DataUtil.transformByteArrayToHexString(plainText) + "],signature[HEX:" + DataUtil.transformByteArrayToHexString(signature) + "]"));
            try {
                X509Certificate cert = ServerKeyStore.getInstance(config).getCert();
                flag = this.verifySignature(plainText, signature, cert);
                if (flag != 201) break block3;
                log.info((Object)"new cert verify secced!");
                return 201;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), e.getCause());
                log.error((Object)"verifyServerSignature \u9a8c\u8bc1\u5931\u8d25 ret[304]");
                return 304;
            }
        }
        return flag;
    }

    private int verifySignature(byte[] plaintext, byte[] signature, X509Certificate cert) {
        block7: {
            log.info((Object)">>verifySignature(..X509Certificate.)");
            log.info((Object)"\u5f00\u59cb\u8bc1\u4e66CVM\u9a8c\u8bc1,CVM verifyCert");
            int ret = CVMService.doCVM(cert);
            log.info((Object)("CVM verifyCert  ret[" + ret + "]"));
            if (ret != 0) {
                log.error((Object)"CVM verifyCert \u9a8c\u8bc1\u672a\u901a\u8fc7");
                return ret;
            }
            log.info((Object)"\u5f00\u59cb\u9a8c\u8bc1\u7b7e\u540d\u503c,RecipientBcImpl");
            boolean flag = false;
            RecipientBcImpl rp = new RecipientBcImpl();
            if (cert.getPublicKey().getAlgorithm().equals("SM2") || cert.getPublicKey().getAlgorithm().equals(AlgorithmId.SM2_oid.toString())) {
                log.info((Object)"SM2 Verify");
                flag = ((Recipient)rp).doVerify(plaintext, signature, cert, "SM3withSM2");
            } else {
                log.info((Object)"RSA Verify");
                flag = this.compatibleVerify(plaintext, signature, cert.getPublicKey());
            }
            if (!flag) break block7;
            log.info((Object)"\u9a8c\u8bc1\u901a\u8fc7  ret[201]");
            return 201;
        }
        try {
            log.error((Object)"\u9a8c\u8bc1\u5931\u8d25 ret[204]");
            return 204;
        }
        catch (NotSupportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (CryptoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.error((Object)"\u9a8c\u8bc1\u5931\u8d25 ret[304]");
        return 304;
    }

    private boolean compatibleVerify(byte[] plaintext, byte[] signature, PublicKey publicKey) {
        log.info((Object)">>compatibleVerify(...)");
        try {
            ASN1InputStream is = new ASN1InputStream(publicKey.getEncoded());
            ASN1Primitive obj = is.readObject();
            ASN1Sequence seq = (ASN1Sequence)obj;
            SubjectPublicKeyInfo pkInfo = SubjectPublicKeyInfo.getInstance((Object)seq);
            RSAPublicKeyStructure pubk = RSAPublicKeyStructure.getInstance((Object)pkInfo.getPublicKey());
            BigInteger mod = pubk.getModulus();
            int i = RSACore.getByteLength(mod);
            RSAPadding padding = RSAPadding.getInstance(1, i, null);
            byte[] rsaByte = RSACore.rsa(signature, (RSAPublicKey)publicKey);
            log.debug((Object)"\u89e3\u5bc6\u6210\u529f");
            byte[] unpadRsaByte = padding.unpad(rsaByte);
            log.debug((Object)"unpading success");
            DerInputStream localDerInputStream = new DerInputStream(unpadRsaByte);
            DerValue[] arrayOfDerValue = localDerInputStream.getSequence(2);
            if (arrayOfDerValue.length != 2 || localDerInputStream.available() != 0) {
                log.error((Object)"decodeSignature\u5931\u8d25\uff0cSEQUENCE length error");
                throw new IOException("SEQUENCE length error");
            }
            AlgorithmId localAlgorithmId = AlgorithmId.parse(arrayOfDerValue[0]);
            if (localAlgorithmId.getEncodedParams() != null) {
                log.error((Object)"hash\u7b97\u6cd5\u89e3\u6790\u5931\u8d25");
                throw new IOException("Unexpected AlgorithmId parameters");
            }
            String oid = localAlgorithmId.getOID().toString();
            String HashAlgorithm = AlgorithmId.get(oid).toString();
            MessageDigest md = MessageDigest.getInstance(HashAlgorithm);
            md.update(plaintext);
            byte[] arrayOfByte2 = md.digest();
            byte[] arrayOfByte1 = arrayOfDerValue[1].getOctetString();
            if (Arrays.equals(arrayOfByte1, arrayOfByte2)) {
                log.info((Object)"compatibleVerify return true");
                return true;
            }
        }
        catch (InvalidKeyException e) {
            System.out.println(e);
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException localInvalidAlgorithmParameterException) {
            try {
                throw new InvalidKeyException(localInvalidAlgorithmParameterException.getMessage());
            }
            catch (InvalidKeyException e) {
                System.out.println(e);
                log.error((Object)e.getMessage(), e.getCause());
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        catch (BadPaddingException e) {
            log.error((Object)e.getMessage(), e.getCause());
        }
        log.error((Object)"compatibleVerify return false");
        return false;
    }
}

