/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.x509.extension;

import com.itrus.security.x509.extension.logotype.Logotype;
import com.itrus.security.x509.extension.logotype.LogotypeAudio;
import com.itrus.security.x509.extension.logotype.LogotypeData;
import com.itrus.security.x509.extension.logotype.LogotypeDetails;
import com.itrus.security.x509.extension.logotype.LogotypeInfo;
import com.itrus.security.x509.extension.logotype.OtherLogotypeInfo;
import com.itrus.util.ImageDataURLCodec;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;

public class LogotypeGenerator {
    private byte[] subjectLogoImageBytes;
    public static final String SHA1 = "SHA-1";
    public static final String SHA1_OID = "1.3.14.3.2.26";
    private String messageDigestAlgorithm = "SHA-1";
    private String messageDigestAlgorithmIdentifier = "1.3.14.3.2.26";

    public void updateSubjectLogo(InputStream is, int off, int len) throws IOException {
        this.subjectLogoImageBytes = new byte[len];
        is.read(this.subjectLogoImageBytes, off, len);
    }

    public Logotype genLogotype() throws IOException, NoSuchAlgorithmException {
        String mediaType = "image/gif";
        String imageDataURL = ImageDataURLCodec.encode(this.subjectLogoImageBytes);
        if (imageDataURL.indexOf(mediaType) < 0) {
            throw new IOException("Needs gif file.");
        }
        MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
        md.update(this.subjectLogoImageBytes);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(this.messageDigestAlgorithmIdentifier);
        byte[] digest = md.digest();
        DigestInfo digestInfo = new DigestInfo(algId, digest);
        DigestInfo[] logotypeHash = new DigestInfo[]{digestInfo};
        String[] logotypeURI = new String[]{imageDataURL};
        LogotypeDetails imageDetails = new LogotypeDetails(mediaType, logotypeHash, logotypeURI);
        LogotypeDetails[] images = new LogotypeDetails[]{imageDetails};
        LogotypeAudio[] audio = null;
        LogotypeData direct = new LogotypeData(images, audio);
        LogotypeInfo[] communityLogos = null;
        LogotypeInfo issuerLogo = new LogotypeInfo(direct);
        LogotypeInfo subjectLogo = null;
        OtherLogotypeInfo[] otherLogos = null;
        Logotype logotype = new Logotype(communityLogos, issuerLogo, subjectLogo, otherLogos);
        return logotype;
    }
}

