/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.x509.extension.logotype;

import com.itrus.security.x509.extension.logotype.LogotypeAudio;
import com.itrus.security.x509.extension.logotype.LogotypeDetails;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class LogotypeData
extends ASN1Encodable {
    ASN1Sequence image = null;
    ASN1Sequence audio = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogotypeData getInstance(ASN1Sequence sequence) {
        ASN1Sequence image = null;
        ASN1Sequence audio = null;
        if (sequence.size() == 1) {
            DEREncodable obj = sequence.getObjectAt(0);
            if (obj instanceof ASN1Sequence) {
                image = ASN1Sequence.getInstance((Object)obj);
            } else {
                if (!(obj instanceof ASN1TaggedObject)) throw new IllegalArgumentException("unknown object in sequence with length 1: " + obj.getClass().getName());
                ASN1TaggedObject first = (ASN1TaggedObject)obj;
                if (first.getTagNo() == 1) {
                    audio = ASN1Sequence.getInstance((Object)first.getObject());
                }
            }
        } else {
            if (sequence.size() != 2) throw new IllegalArgumentException("size of sequence must be 2 not " + sequence.size());
            ASN1TaggedObject first = (ASN1TaggedObject)sequence.getObjectAt(0);
            ASN1TaggedObject second = (ASN1TaggedObject)sequence.getObjectAt(1);
            if (first.getTagNo() == 1) {
                audio = ASN1Sequence.getInstance((Object)first.getObject());
                image = ASN1Sequence.getInstance((Object)second.getObject());
            } else {
                if (second.getTagNo() != 1) throw new IllegalArgumentException("one of the objects in this sequence must be tagged with 1");
                audio = ASN1Sequence.getInstance((Object)second.getObject());
                image = ASN1Sequence.getInstance((Object)first.getObject());
            }
        }
        LogotypeDetails[] images = null;
        if (image != null) {
            Vector<LogotypeDetails> v = new Vector<LogotypeDetails>(image.size());
            int i = 0;
            while (i < image.size()) {
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)image.getObjectAt(i));
                LogotypeDetails logotypeImage = LogotypeDetails.getInstance(seq);
                v.add(logotypeImage);
                ++i;
            }
            images = v.toArray(new LogotypeDetails[image.size()]);
        }
        LogotypeAudio[] audios = null;
        if (audio == null) return new LogotypeData(images, audios);
        Vector<LogotypeAudio> v = new Vector<LogotypeAudio>(audio.size());
        int i = 0;
        while (i < audio.size()) {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)audio.getObjectAt(i));
            LogotypeAudio logotypeImage = LogotypeAudio.getInstance(seq);
            v.add(logotypeImage);
            ++i;
        }
        audios = v.toArray(new LogotypeAudio[audio.size()]);
        return new LogotypeData(images, audios);
    }

    public LogotypeData(LogotypeDetails[] image, LogotypeAudio[] audio) {
        int i;
        ASN1EncodableVector v;
        if (image != null) {
            v = new ASN1EncodableVector();
            i = 0;
            while (i < image.length) {
                v.add((DEREncodable)image[i].toASN1Object());
                ++i;
            }
            this.image = new DERSequence(v);
        } else {
            this.image = null;
        }
        if (audio != null) {
            v = new ASN1EncodableVector();
            i = 0;
            while (i < audio.length) {
                v.add((DEREncodable)audio[i].toASN1Object());
                ++i;
            }
            this.audio = new DERSequence(v);
        } else {
            this.audio = null;
        }
    }

    public LogotypeDetails[] getImages() {
        Vector<LogotypeDetails> v = new Vector<LogotypeDetails>();
        int i = 0;
        while (i < this.image.size()) {
            v.add(LogotypeDetails.getInstance(this.image.getObjectAt(i)));
            ++i;
        }
        LogotypeDetails[] images = v.toArray(new LogotypeDetails[this.image.size()]);
        return images;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.image != null) {
            v.add((DEREncodable)this.image);
        }
        if (this.audio != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)this.audio));
        }
        return new DERSequence(v);
    }
}

