/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.svm;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.pkcs.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.pkcs.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignedData;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignerInfo;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.jce.X509Principal;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import cn.topca.security.sm.TopSMProvider;
import com.itrus.cert.X509Certificate;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.SignatureVerifyException;
import com.itrus.svm.SignerAndEncryptedDigest;
import com.itrus.util.DERUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Enumeration;

public class SVM
implements PKCSObjectIdentifiers {
    private static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private static final String ID_MD5 = "1.2.840.113549.2.5";
    private static final String ID_MD2 = "1.2.840.113549.2.2";
    private static final String ID_SHA1 = "1.3.14.3.2.26";
    private static final String ID_RSA = "1.2.840.113549.1.1.1";
    private static final String ID_DSA = "1.2.840.10040.4.1";
    private static final String ID_SM2 = "1.2.156.10197.1.301";
    private static final String ID_SM3 = "1.2.156.10197.1.401";
    private static final String ID_SM3withSM2 = "1.2.156.10197.1.501";

    public static java.security.cert.X509Certificate verifySignature(byte[] toSign, String signedDataStr) throws SignatureVerifyException, CryptoException {
        byte[] pkcs7 = null;
        pkcs7 = !signedDataStr.startsWith("M") ? DERUtils.HexStringToBytes(signedDataStr) : Base64.decode(signedDataStr);
        SignerAndEncryptedDigest signerAndEncryptedDigest = SVM.verifyAndParsePkcs7(toSign, pkcs7);
        return signerAndEncryptedDigest.getSigner();
    }

    public static java.security.cert.X509Certificate verifySignature(String toSignStr, String signedDataStr) throws SignatureVerifyException, CryptoException {
        try {
            return SVM.verifySignature(toSignStr.getBytes("iso8859-1"), signedDataStr);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] fetchEncryptedDigest(String toSignStr, String signedDataStr) throws SignatureVerifyException, CryptoException {
        byte[] oriData = toSignStr.getBytes();
        byte[] pkcs7 = null;
        pkcs7 = !signedDataStr.startsWith("M") ? DERUtils.HexStringToBytes(signedDataStr) : Base64.decode(signedDataStr);
        SignerAndEncryptedDigest signerAndEncryptedDigest = SVM.verifyAndParsePkcs7(oriData, pkcs7);
        return signerAndEncryptedDigest.getEncryptedDigest();
    }

    private static String getDigestAlgorithm(String digestAlgorithm, String digestEncryptionAlgorithm) {
        String da = digestAlgorithm;
        String dea = digestEncryptionAlgorithm;
        if (digestAlgorithm.equals(ID_MD5)) {
            da = "MD5";
        } else if (digestAlgorithm.equals(ID_MD2)) {
            da = "MD2";
        } else if (digestAlgorithm.equals(ID_SHA1)) {
            da = "SHA1";
        } else if (digestAlgorithm.equals(ID_SM3)) {
            da = "SM3";
        }
        if (digestEncryptionAlgorithm.equals(ID_RSA)) {
            dea = "RSA";
        } else if (digestEncryptionAlgorithm.equals(ID_DSA)) {
            dea = "DSA";
        } else if (digestEncryptionAlgorithm.equals(ID_SM2)) {
            dea = "SM2";
        } else if (digestEncryptionAlgorithm.equals(ID_SM3withSM2)) {
            dea = "SM2";
        }
        return da + "with" + dea;
    }

    public static SignerAndEncryptedDigest verifyAndParsePkcs7(byte[] oriData, byte[] pkcs7) throws SignatureVerifyException, CryptoException {
        ASN1Set signerinfos;
        ContentInfo contentInfo;
        DEREncodable dEREncodable;
        DERObject pkcs;
        X509Certificate signCert = null;
        ASN1InputStream din = new ASN1InputStream(pkcs7);
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof ASN1Sequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        cn.tca.TopBasicCrypto.asn1.cms.ContentInfo content = cn.tca.TopBasicCrypto.asn1.cms.ContentInfo.getInstance(pkcs);
        if (!content.getContentType().equals(signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance(content.getContent());
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (data.getCertificates() != null) {
            Enumeration ec = ASN1Set.getInstance(data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                try {
                    certs.add(new X509Certificate(X509CertificateStructure.getInstance(ec.nextElement())));
                }
                catch (CertificateParsingException e) {
                    throw new CryptoException(e);
                }
            }
        }
        if ((dEREncodable = (contentInfo = data.getContentInfo()).getContent()) != null) {
            DEROctetString dEROctetString = (DEROctetString)dEREncodable;
            oriData = dEROctetString.getOctets();
        }
        if ((signerinfos = data.getSignerInfos()).size() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance(signerinfos.getObjectAt(0));
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        for (X509Certificate cert : certs) {
            if (!serialNumber.equals(cert.getSerialNumber()) || !issuer.equals(cert.getIssuerDN())) continue;
            signCert = cert;
            break;
        }
        if (signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + serialNumber.toString(16));
        }
        String digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        byte[] encryptedDigest = signerInfo.getEncryptedDigest().getOctets();
        String digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        try {
            Signature sig = Signature.getInstance(SVM.getDigestAlgorithm(digestAlgorithm, digestEncryptionAlgorithm));
            sig.initVerify(signCert.getPublicKey());
            if (oriData == null) {
                throw new CryptoException("Unable to get the original data to be signed.");
            }
            sig.update(oriData);
            if (!sig.verify(encryptedDigest)) {
                SignatureVerifyException e = new SignatureVerifyException("Signature verify failed, plaintext may be falsified. Signer is [" + signCert.getSubjectDNString() + "]");
                e.setSigner(signCert);
                throw e;
            }
            SignerAndEncryptedDigest signerAndEncryptedDigest = new SignerAndEncryptedDigest();
            signerAndEncryptedDigest.setSigner(signCert);
            signerAndEncryptedDigest.setEncryptedDigest(encryptedDigest);
            signerAndEncryptedDigest.setOriData(oriData);
            return signerAndEncryptedDigest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e);
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException, SignatureVerifyException, CryptoException {
        byte[] toSign = "\u8bc1\u5238\u4e1a\u52a1\u7535\u5b50\u7b7e\u540d\u7ea6\u5b9a\u4e66(ID=2,\u7248\u672c\u53f7=2012\u7248);\u8bc1\u5238\u4ea4\u6613\u59d4\u6258\u4ee3\u7406\u534f\u8bae\u4e66(ID=3,\u7248\u672c\u53f7=2012\u7248);\u7f51\u4e0a\u59d4\u6258\u534f\u8bae\u4e66(ID=6,\u7248\u672c\u53f7=2012\u7248);\u7f51\u4e0a\u5f00\u6237\u7ea6\u5b9a\u4e66(ID=32,\u7248\u672c\u53f7=1);".getBytes("UTF-8");
        SVM.verifySignature(toSign, "MIIEUwYJKoZIhvcNAQcCoIIERDCCBEACAQExCzAJBgUrDgMCGgUAMAsGCSqGSIb3DQEHAaCCAzAwggMsMIICFKADAgECAgQqsoLwMA0GCSqGSIb3DQEBBQUAMD8xCzAJBgNVBAYTAkNOMRIwEAYDVQQKDAlDU0RDIFRlc3QxHDAaBgNVBAMME09wZXJhdGlvbiBDQTAxIFRlc3QwHhcNMTQwMzI1MDUyNTMzWhcNMTUwMzI1MDUyNTMzWjBQMQswCQYDVQQGEwJDTjESMBAGA1UECgwJQ1NEQyBUZXN0MRQwEgYDVQQLDAtDdXN0b21lcnMwMTEXMBUGA1UEAwwOQ0AxQDEwMDAwMzYxNTYwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANiSSrUfI+qTX/Pt8YFSxUX2IeyTNSkX6g57QwON8EeyNZSi/bqzt//WWJUjSxcUQHIelZpwR4vLE6rJmrChD5i86GdRSdSCx7shZG1D815ADkwegZqwQNMUtmFWUr7/etHaKCpsq61PTyHYlj8fnbYFoCKEyLzeI/UZddqbgHShAgMBAAGjgaIwgZ8wEQYJYIZIAYb4QgEBBAQDAgWgMAkGA1UdEwQCMAAwUwYDVR0fBEwwSjBIoEagRKRCMEAxCzAJBgNVBAYTAkNOMRIwEAYDVQQKDAlDU0RDIFRlc3QxDDAKBgNVBAsMA2NybDEPMA0GA1UEAwwGY3JsMTAwMAsGA1UdDwQEAwIGwDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwQwDQYJKoZIhvcNAQEFBQADggEBAKAWD2JKTeLPJN4VyXSz55aLvPgll29YWFi2kXosdrBPuX/nL/RRJY0QsfR/O7ujK4Efiup5JZKc0HHEri2w/1Ez7YxfZKZDPemB5MjstxTypRdfe18eG+gqFEN8fnIaUReym44N13/ZEG3N6GIC74OX/L6DQ+TKwSXuyyjXCeLcZjCI/dBgPnr/2pycQMlJYs/y/V25Tzt1xqMOZc4DVL+dnhl3ma6mzEcoag5ycYdmW5Kut2bz+E8g4fBaWMnOY6X+xFygWpV2vOJE776VpEv14MJY3XAaZK7mG9n07NYtE1ncMv/oM6j/uYbKOpk+9xikRfR1SMBzZr/Uce7V7UUxgewwgekCAQEwRzA/MQswCQYDVQQGEwJDTjESMBAGA1UECgwJQ1NEQyBUZXN0MRwwGgYDVQQDDBNPcGVyYXRpb24gQ0EwMSBUZXN0AgQqsoLwMAkGBSsOAwIaBQAwDQYJKoZIhvcNAQEBBQAEgYB4LqrPQ4Oc5c9hZCkW0cJYfCvfsNd8F7U2zOK3iZn3PiBFGiGnTN7HhPe4xTiJMRrTIFNbSFNqqO9rmENzXIgeNxzuvMk1oTeCjsxMprVqtHRHXo5APORaI0/fOb319+BKGFr4lDBcRoqRjyNZ5kNF9HLnUs+cuNCJZ8EsKQqaxg==");
        byte[] oriData = "\u5c0f\u738b\u4e8e2006\u5e7412\u670813\u65e5\u63d0\u6b3e10\u4e07\u5143".getBytes();
        byte[] pkcs7 = Base64.decode("MIIDUAYJKoZIhvcNAQcCoIIDQTCCAz0CAQExDjAMBggqgRzPVQGDEQUAMDcGCSqGSIb3DQEHAaAqBCjlsI/njovkuo4yMDA25bm0MTLmnIgxM+aXpeaPkOasvjEw5LiH5YWDoIICDDCCAggwggGsoAMCAQICFDTdTxYkZhdzYwiprwL7KJbdehP2MAwGCCqBHM9VAYN1BQAwWjEZMBcGA1UEAwwQR2xvZG9uIFVzZXIgQ0EgMjEfMB0GA1UECwwWR2xvZG9uIFNlY3VyaXR5IENlbnRlcjEPMA0GA1UECgwGR2xvZG9uMQswCQYDVQQGEwJDTjAeFw0xNDA2MjYwODU3NTlaFw0xNTA2MjYwODU3NTlaMEsxGDAWBgNVBAMMD3Rlc3QtbG9uZ3l1dGluZzERMA8GA1UECwwIVXNlcl9DQTIxDzANBgNVBAoMBkdsb2RvbjELMAkGA1UEBgwCQ04wWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAASZE4lm0cbP+9vj7WHHhfy42aB0WOy/grl5sQjriNkxGNb5r2OBwJcpHHhEinNYC/HSBuTWcUdhS0UIDGx5YsK5o10wWzAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIGwDAfBgNVHSMEGDAWgBT8R2Yi0iNEP43W6LKdFQTvVCdHIDAdBgNVHQ4EFgQUC1GFz3RL3C5v7UQk+uDqulF0XIowDAYIKoEcz1UBg3UFAANIADBFAiEA3hrjmYD+O/IbQyRhIa+k7gcRou7hIj1BX9+77XkbfvoCIHrWxtvpxIoMJpCrJgXua9hz+0bqLcJq3RmW551QO+fuMYHeMIHbAgEBMHIwWjEZMBcGA1UEAwwQR2xvZG9uIFVzZXIgQ0EgMjEfMB0GA1UECwwWR2xvZG9uIFNlY3VyaXR5IENlbnRlcjEPMA0GA1UECgwGR2xvZG9uMQswCQYDVQQGEwJDTgIUNN1PFiRmF3NjCKmvAvsolt16E/YwDAYIKoEcz1UBgxEFADAMBggqgRzPVQGCLQUABEYwRAIgPOVjKmuZ11S4nVNnHhPXy58x57rgdKFGPLzfMT+GASICIIr4LK28f3h6+gZ+syXs2KMwlnW3SDfGo6rs7bIYoTY1");
        SVM.verifyAndParsePkcs7(oriData, pkcs7);
    }

    static {
        Security.addProvider(new TopSMProvider());
    }
}

