/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERIA5String;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.x509.CRLDistPoint;
import cn.tca.TopBasicCrypto.asn1.x509.DistributionPoint;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralName;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralNames;
import cn.tca.TopBasicCrypto.asn1.x509.X509DefaultEntryConverter;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.asn1.x509.X509NameEntryConverter;
import cn.tca.TopBasicCrypto.asn1.x509.X509NameTokenizer;
import cn.tca.TopBasicCrypto.jce.PKCS10CertificationRequest;
import cn.tca.TopBasicCrypto.jce.X509Principal;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.openssl.PEMReader;
import cn.tca.TopBasicCrypto.x509.extension.X509ExtensionUtil;
import com.itrus.cert.CertNames;
import com.itrus.cert.Names;
import com.itrus.cert.X509Certificate;
import com.itrus.cert.X509Name;
import com.itrus.cryptorole.CryptoException;
import com.itrus.util.Base64;
import com.itrus.util.CipherUtils;
import com.itrus.util.DnComponents;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;

public class CertUtils {
    private static Vector getDefaultX509FieldOrder() {
        Vector<DERObjectIdentifier> fieldOrder = new Vector<DERObjectIdentifier>();
        String[] dNObjects = DnComponents.getDnObjects();
        for (int i = 0; i < dNObjects.length; ++i) {
            fieldOrder.add(DnComponents.getOid(dNObjects[i]));
        }
        return fieldOrder;
    }

    public static String getPartFromDN(String dn, String dnpart) {
        String part = null;
        if (dn != null && dnpart != null) {
            dnpart = dnpart + "=";
            X509NameTokenizer xt = new X509NameTokenizer(dn);
            while (xt.hasMoreTokens()) {
                String o = xt.nextToken();
                if (o.length() <= dnpart.length() || !o.substring(0, dnpart.length()).equalsIgnoreCase(dnpart)) continue;
                part = o.substring(dnpart.length());
                break;
            }
        }
        return part;
    }

    public static boolean isSelfSigned(java.security.cert.X509Certificate cert) {
        new StringBuffer().append(">isSelfSigned: cert: ").append(CertUtils.getIssuerDN(cert)).append("\n").append(CertUtils.getSubjectDN(cert)).toString();
        boolean ret = CertUtils.getSubjectDN(cert).equals(CertUtils.getIssuerDN(cert));
        new StringBuffer().append("<isSelfSigned:").append(ret).toString();
        return ret;
    }

    public static X509Name stringToBcX509Name(String dn) {
        X509DefaultEntryConverter converter = new X509DefaultEntryConverter();
        return CertUtils.stringToBcX509Name(dn, converter);
    }

    private static X509Name stringToBcX509Name(String dn, X509NameEntryConverter converter) {
        return CertUtils.stringToBcX509Name(dn, converter, CertUtils.getDefaultX509FieldOrder());
    }

    public static X509Name stringToBcX509Name(String dn, X509NameEntryConverter converter, Vector dnOrder) {
        if (dn == null) {
            return null;
        }
        Vector<DERObjectIdentifier> defaultOrdering = new Vector<DERObjectIdentifier>();
        Vector<String> values = new Vector<String>();
        X509NameTokenizer xt = new X509NameTokenizer(dn);
        while (xt.hasMoreTokens()) {
            String pair = xt.nextToken();
            int ix = pair.indexOf("=");
            if (ix == -1) continue;
            String key = pair.substring(0, ix).toLowerCase().trim();
            String val = pair.substring(ix + 1);
            if (val != null) {
                val = StringUtils.stripStart((String)val, null);
            }
            DERObjectIdentifier oid = DnComponents.getOid(key);
            try {
                if (oid == null) {
                    oid = new DERObjectIdentifier(key);
                }
                defaultOrdering.add(oid);
                values.add(val);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        X509Name x509Name = new X509Name(defaultOrdering, values, converter);
        X509Name orderedX509Name = CertUtils.getOrderedX509Name(x509Name, dnOrder, converter);
        return orderedX509Name;
    }

    private static X509Name getOrderedX509Name(X509Name x509Name, Vector ordering, X509NameEntryConverter converter) {
        if (ordering == null) {
            ordering = new Vector();
        }
        Vector<DERObjectIdentifier> newOrdering = new Vector<DERObjectIdentifier>();
        Vector newValues = new Vector();
        Hashtable ht = new Hashtable();
        for (DERObjectIdentifier oid : ordering) {
            Vector valueList;
            if (ht.containsKey(oid) || (valueList = CertUtils.getX509NameFields(x509Name, oid)) == null) continue;
            for (Object value : valueList) {
                ht.put(oid, value);
                newOrdering.add(oid);
                newValues.add(value);
            }
        }
        Vector allOids = x509Name.getOIDs();
        for (int i = 0; i < allOids.size(); ++i) {
            Vector valueList;
            DERObjectIdentifier oid = (DERObjectIdentifier)allOids.get(i);
            if (ht.containsKey(oid) || (valueList = CertUtils.getX509NameFields(x509Name, oid)) == null) continue;
            for (Object value : valueList) {
                ht.put(oid, value);
                newOrdering.add(oid);
                newValues.add(value);
                new StringBuffer().append("added --> ").append(oid).append(" val: ").append(value).toString();
            }
        }
        X509Name orderedName = new X509Name(newOrdering, newValues, converter);
        return orderedName;
    }

    private static Vector getX509NameFields(X509Name name, DERObjectIdentifier id) {
        Vector oids = name.getOIDs();
        Vector values = name.getValues();
        Vector vRet = null;
        for (int i = 0; i < oids.size(); ++i) {
            if (!id.equals(oids.elementAt(i))) continue;
            if (vRet == null) {
                vRet = new Vector();
            }
            vRet.add(values.get(i));
        }
        return vRet;
    }

    public static String reverseDN(String dn) {
        String ret = null;
        if (dn != null) {
            BasicX509NameTokenizer xt = new BasicX509NameTokenizer(dn);
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            while (xt.hasMoreTokens()) {
                String o = xt.nextToken();
                if (!first) {
                    buf.insert(0, ",");
                } else {
                    first = false;
                }
                buf.insert(0, o);
            }
            if (buf.length() > 0) {
                ret = buf.toString();
            }
        }
        return ret;
    }

    protected static boolean isDNReversed(String dn) {
        boolean ret = false;
        if (dn != null) {
            String first = null;
            String last = null;
            X509NameTokenizer xt = new X509NameTokenizer(dn);
            if (xt.hasMoreTokens()) {
                first = xt.nextToken();
            }
            while (xt.hasMoreTokens()) {
                last = xt.nextToken();
            }
            String[] dNObjects = DnComponents.getDnObjects();
            if (first != null && last != null) {
                first = first.substring(0, first.indexOf(61));
                last = last.substring(0, last.indexOf(61));
                int firsti = 0;
                int lasti = 0;
                for (int i = 0; i < dNObjects.length; ++i) {
                    if (first.toLowerCase().equals(dNObjects[i])) {
                        firsti = i;
                    }
                    if (!last.toLowerCase().equals(dNObjects[i])) continue;
                    lasti = i;
                }
                if (lasti < firsti) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static String stringToBCDNString(String dn) {
        if (CertUtils.isDNReversed(dn)) {
            dn = CertUtils.reverseDN(dn);
        }
        String ret = null;
        X509Name name = CertUtils.stringToBcX509Name(dn);
        if (name != null) {
            ret = name.toString();
        }
        if (ret != null && ret.length() > 250) {
            new StringBuffer().append("Warning! DN is more than 250 characters long. Some databases have only 250 characters in the database for SubjectDN. Clipping may occur! DN (").append(ret.length()).append(" chars): ").append(ret).toString();
        }
        return ret;
    }

    public static CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public static String getSubjectDN(java.security.cert.X509Certificate cert) {
        return CertUtils.getDN(cert, 1);
    }

    public static String getIssuerDN(java.security.cert.X509Certificate cert) {
        return CertUtils.getDN(cert, 2);
    }

    private static String getDN(java.security.cert.X509Certificate cert, int which) {
        String dn = null;
        if (cert == null) {
            return dn;
        }
        try {
            CertificateFactory cf = CertUtils.getCertificateFactory();
            java.security.cert.X509Certificate x509cert = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
            dn = which == 1 ? x509cert.getSubjectDN().toString() : x509cert.getIssuerDN().toString();
        }
        catch (CertificateException ce) {
            return null;
        }
        return CertUtils.stringToBCDNString(dn);
    }

    public static ArrayList getPartsFromDN(String dn, String dnpart) {
        ArrayList<String> parts = new ArrayList<String>();
        if (dn != null && dnpart != null) {
            dnpart = new StringBuffer().append(dnpart).append("=").toString();
            X509NameTokenizer xt = new X509NameTokenizer(dn);
            while (xt.hasMoreTokens()) {
                String o = xt.nextToken();
                if (o.length() <= dnpart.length() || !o.substring(0, dnpart.length()).equalsIgnoreCase(dnpart)) continue;
                parts.add(o.substring(dnpart.length()));
            }
        }
        return parts;
    }

    public static X509CRL getX509CRLFromBytes(byte[] crlBuf, String providerName) throws CertificateException, NoSuchProviderException, CRLException {
        CertificateFactory cf = null == providerName ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", providerName);
        X509CRL x509CRL = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crlBuf));
        return x509CRL;
    }

    public static java.security.cert.X509Certificate changeProvider(java.security.cert.X509Certificate cert, String strProvider) throws CertificateException, NoSuchProviderException {
        CertificateFactory cf = null == strProvider ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", strProvider);
        return (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
    }

    public static Names getSubjectNames(java.security.cert.X509Certificate cert, String strProvider) {
        return CertUtils.parseDistinguishName(cert.getSubjectDN().getName(), strProvider);
    }

    public static Names getSubjectNames(java.security.cert.X509Certificate cert) {
        return CertUtils.parseDistinguishName(cert.getSubjectDN().getName(), null);
    }

    public static Names getIssuerNames(java.security.cert.X509Certificate cert, String strProvider) {
        return CertUtils.parseDistinguishName(cert.getIssuerDN().getName(), strProvider);
    }

    public static Names getIssuerNames(java.security.cert.X509Certificate cert) {
        return CertUtils.parseDistinguishName(cert.getIssuerDN().getName(), null);
    }

    public static boolean isValid(java.security.cert.X509Certificate cert) {
        return CertUtils.isOnValidPeriod(cert);
    }

    public static boolean isOnValidPeriod(java.security.cert.X509Certificate cert) {
        Date notBefore = cert.getNotBefore();
        Date notAfter = cert.getNotAfter();
        Date now = new Date();
        return !now.before(notBefore) && !now.after(notAfter);
    }

    public static Names parseDistinguishName(String distinguishName, String strProvider) {
        String partition = ", ";
        if (strProvider != null && strProvider.equals("BC")) {
            partition = ",";
        }
        Names names = new Names();
        String[] Items = distinguishName.split(partition);
        String itemString = "";
        for (int i = Items.length - 1; i >= 0; --i) {
            Vector vector;
            int pos = (itemString = !itemString.equals("") ? Items[i] + itemString : Items[i]).indexOf("=");
            if (-1 == pos) {
                itemString = partition + itemString;
                continue;
            }
            String name = itemString.substring(0, pos);
            String value = itemString.substring(pos + 1, itemString.length());
            if (value.indexOf("\"") == 0 && value.length() - 1 == value.lastIndexOf("\"")) {
                value = value.substring(1, value.length());
                value = value.substring(0, value.length() - 1);
            }
            if (names.containsKey(name)) {
                vector = (Vector)names.get(name);
                vector.add(value);
            } else {
                vector = new Vector();
                vector.add(value);
                names.put(name, vector);
            }
            itemString = "";
        }
        return names;
    }

    public static String getAlias(String distinguishName) {
        String alias;
        block0: {
            Iterator it;
            CertNames names = CertUtils.parseCertDistinguishName(distinguishName, null);
            alias = names.getItem("CN");
            if (alias != null || !(it = names.keySet().iterator()).hasNext()) break block0;
            String key = (String)it.next();
            Vector values = names.getItems(key);
            alias = (String)values.get(0);
        }
        return alias;
    }

    public static CertNames parseCertDistinguishName(String distinguishName, String strProvider) {
        String partition = ", ";
        if (strProvider != null && strProvider.equals("BC")) {
            partition = ",";
        }
        CertNames names = new CertNames();
        String[] Items = distinguishName.split(partition);
        String itemString = "";
        for (int i = Items.length - 1; i >= 0; --i) {
            Vector vector;
            int pos = (itemString = !itemString.equals("") ? Items[i] + itemString : Items[i]).indexOf("=");
            if (-1 == pos) {
                itemString = partition + itemString;
                continue;
            }
            String name = itemString.substring(0, pos);
            String value = itemString.substring(pos + 1, itemString.length());
            if (value.indexOf("\"") == 0 && value.length() - 1 == value.lastIndexOf("\"")) {
                value = value.substring(1, value.length());
                value = value.substring(0, value.length() - 1);
            }
            if (names.containsKey(name)) {
                vector = (Vector)names.get(name);
                vector.add(value);
            } else {
                vector = new Vector();
                vector.add(value);
                names.put(name, vector);
            }
            itemString = "";
        }
        return names;
    }

    public static String getIEValidSerialNumber(String serialNumber) {
        if (serialNumber == null) {
            return null;
        }
        if (serialNumber.length() == 0) {
            return serialNumber;
        }
        if ((serialNumber = serialNumber.toLowerCase()).length() % 2 == 1) {
            serialNumber = "0" + serialNumber;
        }
        String firstWord = serialNumber.substring(0, 1);
        int firstNumber = 0;
        try {
            firstNumber = Integer.parseInt(firstWord, 16);
        }
        catch (Exception e) {
            return serialNumber;
        }
        if (firstNumber >= 8) {
            return "00" + serialNumber;
        }
        return serialNumber;
    }

    public static String getICAValidSerialNumber(String serialNumber) {
        if (serialNumber == null) {
            return null;
        }
        if (serialNumber.length() % 2 == 1) {
            serialNumber = "0" + serialNumber;
        }
        if (serialNumber.startsWith("00")) {
            return serialNumber.substring(2).toUpperCase();
        }
        return serialNumber.toUpperCase();
    }

    public static java.security.cert.X509Certificate getX509CertificateFromBytes(byte[] certBuf) throws CertificateException {
        if (certBuf == null) {
            return null;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBuf));
        return cert;
    }

    public static java.security.cert.X509Certificate getX509CertificateFromBase64(String certSignBuf) throws CertificateException {
        if (certSignBuf == null) {
            return null;
        }
        byte[] certBuf = Base64.decode(certSignBuf);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBuf));
        return cert;
    }

    public static java.security.cert.X509Certificate getX509CertificateFromFile(String certFileName) throws CertificateException, IOException {
        if (null == certFileName) {
            return null;
        }
        FileInputStream fis = new FileInputStream(certFileName);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(fis);
        fis.close();
        return cert;
    }

    public static String getCRLDistributionPointURL(java.security.cert.X509Certificate cert) throws IOException {
        String crlUrl = null;
        byte[] crlExtensionValue = cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (null == crlExtensionValue) {
            return null;
        }
        CRLDistPoint cRLDistPoints = CRLDistPoint.getInstance(X509ExtensionUtil.fromExtensionValue(crlExtensionValue));
        DistributionPoint[] distributionPoints = cRLDistPoints.getDistributionPoints();
        block5: for (int i = 0; i < distributionPoints.length; ++i) {
            DistributionPoint distributionPoint = distributionPoints[i];
            GeneralNames generalNames = (GeneralNames)distributionPoint.getDistributionPoint().getName();
            GeneralName[] generalName = generalNames.getNames();
            DEREncodable objGeneralName = generalName[0].getName();
            switch (generalName[0].getTagNo()) {
                case 2: {
                    System.out.println("\u672c\u51fd\u6570\u4e0d\u652f\u6301dNSName");
                    continue block5;
                }
                case 6: {
                    DERIA5String dERIA5String = DERIA5String.getInstance(objGeneralName);
                    crlUrl = dERIA5String.getString();
                    continue block5;
                }
                case 3: {
                    X509Principal x509Principal = new X509Principal(((DERSequence)objGeneralName).getEncoded());
                    System.out.println("\u672c\u51fd\u6570\u4e0d\u652f\u6301LDAP\uff0cx400Address=" + x509Principal.getName());
                    continue block5;
                }
                default: {
                    System.out.println("\u4e0d\u53ef\u8bc6\u522b\u7684CRLDistributionPoint\uff0cTagNo=" + generalName[0].getTagNo());
                }
            }
        }
        return crlUrl;
    }

    public static String getX509NameString(X500Principal x500Principal) {
        return CertUtils.getX509NameString(x500Principal.getEncoded());
    }

    public static String getX509NameString(byte[] prcp) {
        ASN1InputStream ais = new ASN1InputStream(prcp);
        try {
            DERSequence seq = (DERSequence)ais.readObject();
            X509Name name = X509Name.getInstance(seq);
            return name.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IssuerAndSerialNumber getIssuerAndSerialNumber(java.security.cert.X509Certificate cert) {
        IssuerAndSerialNumber issuerAndSerialNumber = null;
        ASN1InputStream ais = new ASN1InputStream(cert.getIssuerX500Principal().getEncoded());
        try {
            DERSequence seq = (DERSequence)ais.readObject();
            cn.tca.TopBasicCrypto.asn1.x509.X509Name x509Name = cn.tca.TopBasicCrypto.asn1.x509.X509Name.getInstance(seq);
            issuerAndSerialNumber = new IssuerAndSerialNumber(x509Name, cert.getSerialNumber());
            return issuerAndSerialNumber;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCertID(java.security.cert.X509Certificate cert) {
        try {
            return CipherUtils.sha1(cert.getEncoded()).toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void PKCS12ToJKS(String p12FileName, char[] p12Password, String keyStoreFileName, char[] storePass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore inputKeyStore = KeyStore.getInstance("PKCS12");
        FileInputStream fis = new FileInputStream(p12FileName);
        inputKeyStore.load(fis, p12Password);
        fis.close();
        KeyStore outputKeyStore = KeyStore.getInstance("JKS");
        outputKeyStore.load(null, storePass);
        Enumeration<String> enums = inputKeyStore.aliases();
        while (enums.hasMoreElements()) {
            String alias = enums.nextElement();
            if (!inputKeyStore.isKeyEntry(alias)) continue;
            Key key = inputKeyStore.getKey(alias, p12Password);
            Certificate[] certChain = inputKeyStore.getCertificateChain(alias);
            Names keyCertNames = X509Certificate.getInstance((java.security.cert.X509Certificate)certChain[0]).getSubjectNames();
            String myKeyAlias = keyCertNames.getItem("CN") != null ? keyCertNames.getItem("CN") : (String)keyCertNames.getItems((String)keyCertNames.keys().nextElement()).elementAt(0);
            outputKeyStore.setKeyEntry(myKeyAlias, key, storePass, certChain);
            for (int i = 0; i < certChain.length; ++i) {
                if (i == 0) continue;
                Names certMames = X509Certificate.getInstance((java.security.cert.X509Certificate)certChain[i]).getSubjectNames();
                String certAlias = certMames.getItem("CN") != null ? certMames.getItem("CN") : (String)certMames.getItems((String)certMames.keys().nextElement()).elementAt(0);
                outputKeyStore.setCertificateEntry(certAlias, certChain[i]);
            }
        }
        FileOutputStream out = new FileOutputStream(keyStoreFileName);
        outputKeyStore.store(out, storePass);
        out.close();
    }

    public static void JKSToPKCS12(String keyStoreFileName, char[] storePass, String keyEntryAlias, char[] keyEntryPass, String p12FileName, char[] p12Password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore inputKeyStore = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(keyStoreFileName);
        inputKeyStore.load(fis, storePass);
        fis.close();
        KeyStore outputKeyStore = KeyStore.getInstance("PKCS12");
        outputKeyStore.load(null, p12Password);
        Enumeration<String> enums = inputKeyStore.aliases();
        while (enums.hasMoreElements()) {
            String alias = enums.nextElement();
            if (!inputKeyStore.isKeyEntry(alias) || !alias.equals(keyEntryAlias)) continue;
            Key key = inputKeyStore.getKey(alias, keyEntryPass);
            Certificate[] certChain = inputKeyStore.getCertificateChain(alias);
            outputKeyStore.setKeyEntry(keyEntryAlias, key, p12Password, certChain);
        }
        FileOutputStream out = new FileOutputStream(p12FileName);
        outputKeyStore.store(out, p12Password);
        out.close();
    }

    public static byte[] getExtensionValue(java.security.cert.X509Certificate cert, String oid) {
        byte[] extValue = cert.getExtensionValue(oid);
        if (extValue != null) {
            byte[] value = new byte[extValue.length - 2];
            System.arraycopy(extValue, 2, value, 0, extValue.length - 2);
            return value;
        }
        return null;
    }

    public static com.itrus.cert.PKCS10CertificationRequest loadCSR(String csrFileName) throws CryptoException, IOException {
        File fCSRFile = new File(csrFileName);
        PEMReader in = new PEMReader(new InputStreamReader(new FileInputStream(fCSRFile)));
        try {
            PKCS10CertificationRequest csr = (PKCS10CertificationRequest)in.readObject();
            com.itrus.cert.PKCS10CertificationRequest itruscsr = new com.itrus.cert.PKCS10CertificationRequest(csr.getEncoded());
            if (!itruscsr.verify()) {
                throw new CryptoException("Could not verify certification request.");
            }
            com.itrus.cert.PKCS10CertificationRequest pKCS10CertificationRequest = itruscsr;
            return pKCS10CertificationRequest;
        }
        catch (ClassCastException ex) {
            throw new CryptoException("Could not load certification request.", ex);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException("Could not load certification request.", ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static com.itrus.cert.PKCS10CertificationRequest loadCSRString(String csrString) throws CryptoException, IOException {
        char[] csrCharArray = csrString.toCharArray();
        CharArrayReader charArrayReader = new CharArrayReader(csrCharArray);
        PEMReader in = new PEMReader(charArrayReader);
        try {
            PKCS10CertificationRequest csr = (PKCS10CertificationRequest)in.readObject();
            com.itrus.cert.PKCS10CertificationRequest itruscsr = new com.itrus.cert.PKCS10CertificationRequest(csr.getEncoded());
            if (!itruscsr.verify()) {
                throw new CryptoException("Could not verify certification request.");
            }
            com.itrus.cert.PKCS10CertificationRequest pKCS10CertificationRequest = itruscsr;
            return pKCS10CertificationRequest;
        }
        catch (ClassCastException ex) {
            throw new CryptoException("Could not load certification request.", ex);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException("Could not load certification request.", ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String X509CertificateToPEM(java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        StringBuffer sb = new StringBuffer();
        sb.append("-----BEGIN CERTIFICATE-----\n");
        sb.append(new String(Base64.encode(cert.getEncoded(), true)));
        sb.append("\n-----END CERTIFICATE-----");
        return sb.toString();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    private static class BasicX509NameTokenizer {
        private String oid;
        private int index;
        private StringBuffer buf = new StringBuffer();

        public boolean hasMoreTokens() {
            return this.index != this.oid.length();
        }

        public String nextToken() {
            int end;
            if (this.index == this.oid.length()) {
                return null;
            }
            boolean quoted = false;
            boolean escaped = false;
            this.buf.setLength(0);
            for (end = this.index + 1; end != this.oid.length(); ++end) {
                char c = this.oid.charAt(end);
                if (c == '\"') {
                    if (!escaped) {
                        this.buf.append(c);
                        quoted = !quoted;
                    } else {
                        this.buf.append(c);
                    }
                    escaped = false;
                    continue;
                }
                if (escaped || quoted) {
                    this.buf.append(c);
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    this.buf.append(c);
                    escaped = true;
                    continue;
                }
                if (c == ',' && !escaped) break;
                this.buf.append(c);
            }
            this.index = end;
            return this.buf.toString().trim();
        }

        public BasicX509NameTokenizer(String oid) {
            this.oid = oid;
            this.index = -1;
        }
    }
}

