/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import com.itrus.util.DERUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CipherUtils {
    static Log log = LogFactory.getLog((String)"ITRUS-CipherUtils");
    private static String provider = "BC";
    public static String AES;
    public static String Blowfish;
    public static String DES;
    public static String TripleDES;
    public static String MD5;
    public static String SHA1;
    private static int useDefaultKeysize;
    public static String DSA;
    public static String RSA;
    public static String DiffieHellman;
    private static HashMap opmodes;

    public static String md5(String plainText) {
        return CipherUtils.md5(plainText.getBytes());
    }

    public static String md5(byte[] original) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        msgDigest.update(original);
        return DERUtils.BytesToHexString(msgDigest.digest());
    }

    public static String sha1(String plainText) {
        return CipherUtils.sha1(plainText.getBytes());
    }

    public static String sha1(byte[] original) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support SHA1 algorithm.");
        }
        msgDigest.update(original);
        return DERUtils.BytesToHexString(msgDigest.digest());
    }

    public static Key createSymmetricKey(String algorithm) throws NoSuchAlgorithmException {
        algorithm = algorithm == null ? "DES" : algorithm;
        SecureRandom sr = new SecureRandom();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
        keyGenerator.init(sr);
        SecretKey key = keyGenerator.generateKey();
        return key;
    }

    public static Key retrieveKey(byte[] keyBuf, String algorithm) {
        algorithm = algorithm == null ? "DES" : algorithm;
        SecretKeySpec key = new SecretKeySpec(keyBuf, algorithm);
        return key;
    }

    public static void serializeKeyObjectToFile(String keyObjectFileName, String algorithm) throws NoSuchAlgorithmException, IOException {
        Key key = CipherUtils.createSymmetricKey(algorithm);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(keyObjectFileName));
        out.writeObject(key);
        out.close();
    }

    public static Key recoverKeyObjectFromFile(String keyObjectFileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(keyObjectFileName));
        Key key = (Key)in.readObject();
        in.close();
        return key;
    }

    public static byte[] encrypt(byte[] inputBytes, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(1, key);
        byte[] encryptedBytes = cipher.doFinal(inputBytes);
        return encryptedBytes;
    }

    public static byte[] decrypt(byte[] encryptedBytes, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        byte[] decryptedData = cipher.doFinal(encryptedBytes);
        return decryptedData;
    }

    public static String getProvider() {
        return provider;
    }

    public static void setProvider(String provider) {
        CipherUtils.provider = provider;
    }

    public static String[] getProviderNames() {
        Provider[] providerArray = Security.getProviders();
        String[] providerNames = new String[providerArray.length];
        for (int i = 0; i < providerArray.length; ++i) {
            providerNames[i] = providerArray[i].getName();
        }
        return providerNames;
    }

    public static SecretKey genKey(String algorithm, int keysize, String providerName, Object useSecureRandom) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator kg = null;
        kg = providerName == null ? (provider != null ? KeyGenerator.getInstance(algorithm, provider) : KeyGenerator.getInstance(algorithm)) : KeyGenerator.getInstance(algorithm, providerName);
        SecureRandom secureRandom = CipherUtils.useSecureRandom(useSecureRandom);
        if (keysize > 0 && secureRandom != null) {
            kg.init(keysize, secureRandom);
        } else {
            if (keysize > 0) {
                kg.init(keysize);
            }
            if (secureRandom != null) {
                kg.init(secureRandom);
            }
        }
        return kg.generateKey();
    }

    public static SecretKey genKey(String algorithm, int keysize, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        try {
            if (secureRandom != null) {
                return CipherUtils.genKey(algorithm, keysize, null, secureRandom);
            }
            return CipherUtils.genKey(algorithm, keysize, null, false);
        }
        catch (NoSuchProviderException e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Unknown error!");
            e.printStackTrace();
            return null;
        }
    }

    public static SecretKey genKey(String algorithm, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        return CipherUtils.genKey(algorithm, useDefaultKeysize, secureRandom);
    }

    public static SecretKey genKey(String algorithm) throws NoSuchAlgorithmException {
        return CipherUtils.genKey(algorithm, null);
    }

    public static SecretKey genKey() {
        try {
            return CipherUtils.genKey(DES);
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Generate default algorthm(DES) SecretKey Faild!");
            e.printStackTrace();
            return null;
        }
    }

    public static KeyPair genKeyPair(String algorithm, int keysize, String providerName, Object useSecureRandom) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (keysize < 0) {
            return null;
        }
        KeyPairGenerator kpg = null;
        kpg = providerName == null ? (provider != null ? KeyPairGenerator.getInstance(algorithm, provider) : KeyPairGenerator.getInstance(algorithm)) : KeyPairGenerator.getInstance(algorithm, providerName);
        SecureRandom secureRandom = CipherUtils.useSecureRandom(useSecureRandom);
        if (secureRandom != null) {
            kpg.initialize(keysize, secureRandom);
        } else {
            kpg.initialize(keysize);
        }
        return kpg.genKeyPair();
    }

    public static KeyPair genKeyPair(String algorithm, int keysize, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        try {
            if (secureRandom != null) {
                return CipherUtils.genKeyPair(algorithm, keysize, null, secureRandom);
            }
            return CipherUtils.genKeyPair(algorithm, keysize, null, false);
        }
        catch (NoSuchProviderException e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Unknown error!");
            e.printStackTrace();
            return null;
        }
    }

    public static KeyPair genKeyPair(String algorithm, int keysize) throws NoSuchAlgorithmException {
        return CipherUtils.genKeyPair(algorithm, keysize, null);
    }

    public static KeyPair genKeyPair(String algorithm) throws NoSuchAlgorithmException {
        return CipherUtils.genKeyPair(algorithm, 1024);
    }

    public static KeyPair genKeyPair() {
        try {
            return CipherUtils.genKeyPair(RSA);
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Generate default algorthm(RSA) KeyPair Faild!");
            e.printStackTrace();
            return null;
        }
    }

    public static KeyPair genCommunicationKeyPair() {
        try {
            return CipherUtils.genKeyPair(DiffieHellman);
        }
        catch (NoSuchAlgorithmException e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Generate Communication KeyPair Faild!");
            e.printStackTrace();
            return null;
        }
    }

    public static PublicKey getCommunicationPublicKey(byte[] publicKeyBytes) throws NoSuchProviderException, InvalidKeySpecException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyBytes);
        try {
            KeyFactory keyFactory = provider != null ? KeyFactory.getInstance(DiffieHellman, provider) : KeyFactory.getInstance(DiffieHellman);
            return keyFactory.generatePublic(x509KeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SecretKey genCommunicationKey(String algorithm, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyAgreement ka = provider != null ? KeyAgreement.getInstance(publicKey.getAlgorithm(), provider) : KeyAgreement.getInstance(publicKey.getAlgorithm());
        ka.init(privateKey);
        ka.doPhase(publicKey, true);
        return ka.generateSecret(algorithm);
    }

    public static SecretKey genCommunicationKey(PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyAgreement ka = provider != null ? KeyAgreement.getInstance(publicKey.getAlgorithm(), provider) : KeyAgreement.getInstance(publicKey.getAlgorithm());
        ka.init(privateKey);
        ka.doPhase(publicKey, true);
        return ka.generateSecret(DES);
    }

    public static byte[] mac(SecretKey sKey, byte[] input) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        Mac mac = provider != null ? Mac.getInstance(sKey.getAlgorithm(), provider) : Mac.getInstance(sKey.getAlgorithm());
        mac.init(sKey);
        return mac.doFinal(input);
    }

    public static byte[] encryptWithKey(Key key, byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return CipherUtils.doFinal("encrypt", key, input);
    }

    public static byte[] decryptWithKey(Key key, byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return CipherUtils.doFinal("decrypt", key, input);
    }

    public static byte[] encryptWithCert(Certificate cert, byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return CipherUtils.doFinal("encrypt", cert, input);
    }

    public static byte[] decryptWithCert(Certificate cert, byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return CipherUtils.doFinal("decrypt", cert, input);
    }

    public static byte[] encryptWithPassword(byte[] password, byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        SecretKeySpec sKey = new SecretKeySpec(password, "PBEWithMD5AndDES");
        return CipherUtils.doFinal("encrypt", sKey, input);
    }

    public static byte[] decryptWithPassword(byte[] password, byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        SecretKeySpec sKey = new SecretKeySpec(password, "PBEWithMD5AndDES");
        return CipherUtils.doFinal("decrypt", sKey, input);
    }

    public static byte[] doFinal(String opmode, Object keyOrCertificate, Object sRandomOrAPSpecOrAPs, byte[] input) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Cipher iCipher = CipherUtils.initCipher(opmode, keyOrCertificate, sRandomOrAPSpecOrAPs);
        if (iCipher != null) {
            return iCipher.doFinal(input);
        }
        log.error((Object)"Initialize Cipher Faild!");
        return null;
    }

    public static byte[] doFinal(String opmode, Object keyOrCertificate, byte[] input) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        try {
            return CipherUtils.doFinal(opmode, keyOrCertificate, null, input);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] doFinal(String opmode, Object keyOrCertificate, InputStream is, int length, OutputStream os) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, IOException, NoSuchProviderException {
        byte[] bytes = null;
        Cipher iCipher = CipherUtils.initCipher(opmode, keyOrCertificate);
        CipherOutputStream cos = null;
        if (iCipher == null) {
            log.error((Object)"Initialize Cipher Faild!");
            return null;
        }
        cos = new CipherOutputStream(os, iCipher);
        if (length < 1) {
            length = Integer.MAX_VALUE;
        }
        byte[] tmp = new byte[length];
        for (int i = 0; i < length; ++i) {
            int b = is.read();
            if (b == -1) {
                bytes = new byte[i];
                for (int index = 0; index < i; ++index) {
                    bytes[index] = tmp[index];
                }
                break;
            }
            tmp[i] = (byte)b;
            cos.write(b);
        }
        if (bytes == null) {
            NumberFormat nf = NumberFormat.getInstance();
            log.error((Object)("Out of " + nf.format(Integer.MAX_VALUE) + " bytes."));
        }
        return bytes;
    }

    private static Cipher initCipher(String opmode, Object keyOrCertificate, Object sRandomOrAPSpecOrAPs) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        int operationMode = (Integer)opmodes.get(opmode.toLowerCase());
        Key key = null;
        Certificate cert = null;
        String algorithm = null;
        if (keyOrCertificate instanceof Key && ((algorithm = (key = (Key)keyOrCertificate).getAlgorithm()).endsWith(MD5) || algorithm.equals(SHA1))) {
            log.error((Object)"HmacMD5 and HmacSHA1 Key used for MAC only!");
            return null;
        }
        if (keyOrCertificate instanceof Certificate) {
            cert = (Certificate)keyOrCertificate;
            PublicKey publicKey = cert.getPublicKey();
            if (publicKey == null) {
                log.error((Object)"Can't find PublicKey form Certificate.");
                return null;
            }
            algorithm = publicKey.getAlgorithm();
        }
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (sRandomOrAPSpecOrAPs instanceof AlgorithmParameterSpec) {
            algorithmParameterSpec = (AlgorithmParameterSpec)sRandomOrAPSpecOrAPs;
        }
        Cipher iCipher = provider != null ? Cipher.getInstance(algorithm, provider) : Cipher.getInstance(algorithm);
        if (key != null) {
            if (algorithmParameterSpec != null) {
                iCipher.init(operationMode, key, algorithmParameterSpec);
            } else {
                iCipher.init(operationMode, key);
            }
        }
        if (cert != null) {
            iCipher.init(operationMode, cert);
        }
        return iCipher;
    }

    private static Cipher initCipher(String opmode, Object keyOrCertificate) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        try {
            return CipherUtils.initCipher(opmode, keyOrCertificate, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Unknown error!");
            e.printStackTrace();
            return null;
        }
    }

    private static SecureRandom useSecureRandom(Object arg) {
        if (arg == null) {
            return null;
        }
        SecureRandom secureRandom = null;
        if (arg instanceof Boolean && ((Boolean)arg).booleanValue()) {
            secureRandom = new SecureRandom();
        }
        if (arg instanceof SecureRandom) {
            secureRandom = (SecureRandom)arg;
        }
        return secureRandom;
    }

    public static KeyStore saveSecretKey2File(String filePath, char[] password, String alias, SecretKey secretKey) {
        KeyStore ks;
        File keyStoreFile = new File(filePath);
        try {
            ks = KeyStore.getInstance("JCEKS");
            if (keyStoreFile.exists()) {
                ks.load(new FileInputStream(keyStoreFile), password);
            } else {
                ks.load(null, password);
            }
            KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(secretKey);
            ks.setEntry(alias, entry, new KeyStore.PasswordProtection(password));
            ks.store(new FileOutputStream(keyStoreFile), password);
        }
        catch (Exception e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Some error in saving secretkey!");
            e.printStackTrace();
            return null;
        }
        return ks;
    }

    public static SecretKey getSecretKeyFromFile(String filePath, char[] password, String alias) {
        File keyStoreFile = new File(filePath);
        if (!keyStoreFile.exists()) {
            log.error((Object)"File not exists!");
            return null;
        }
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            ks.load(new FileInputStream(keyStoreFile), password);
            return (SecretKey)ks.getKey(alias, password);
        }
        catch (Exception e) {
            log.debug((Object)e.getLocalizedMessage());
            log.error((Object)"Some error in loading secretkey!");
            e.printStackTrace();
            return null;
        }
    }

    static {
        boolean flag = false;
        try {
            Class.forName("cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider");
            flag = true;
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider is not found.");
            provider = "SunJCE";
        }
        if (Security.getProvider("BC") == null && flag) {
            Security.addProvider(new BouncyCastleProvider());
        }
        AES = "AES";
        Blowfish = "Blowfish";
        DES = "DES";
        TripleDES = "DESede";
        MD5 = "HmacMD5";
        SHA1 = "HmacSHA1";
        useDefaultKeysize = -1;
        DSA = "DSA";
        RSA = "RSA";
        DiffieHellman = "DH";
        opmodes = new HashMap();
        opmodes.put("encrypt", new Integer(1));
        opmodes.put("decrypt", new Integer(2));
    }
}

