/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static String shortFormat = "yyyyMMdd";
    public static String longFormat = "yyyyMMddHHmmss";
    public static String webFormat = "yyyy-MM-dd";
    public static String timeFormat = "HHmmss";
    public static String monthFormat = "yyyyMM";
    public static String chineseDtFormat = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String newFormat = "yyyy-MM-dd HH:mm:ss";

    public static String getCustomDateString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date parseCustomDateString(String sDate, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date d = null;
        if (sDate != null && sDate.length() == format.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static Date parseDateLongFormat(String sDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(longFormat);
        Date d = null;
        if (sDate != null && sDate.length() == longFormat.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static String getLongDateString(Date date) {
        return DateUtils.getLongDateString(date, TimeZone.getDefault());
    }

    public static String getLongDateString(Date date, TimeZone zone) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(longFormat);
        dateFormat.setTimeZone(zone);
        return dateFormat.format(date);
    }
}

