/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.X509Name;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DnComponents {
    private static Log log = LogFactory.getLog((String)"ITRUS-DnComponents");
    private static DnComponents obj = new DnComponents();
    private static HashMap oids = new HashMap();
    private static String[] dNObjectsForward;
    private static String[] dNObjectsReverse;
    public static final String DNEMAIL = "DNEMAIL";
    public static final String DNQUALIFIER = "DN";
    public static final String UID = "UID";
    public static final String COMMONNAME = "COMMONNAME";
    public static final String SN = "SN";
    public static final String GIVENNAME = "GIVENNAME";
    public static final String INITIALS = "INITIALS";
    public static final String SURNAME = "SURNAME";
    public static final String TITLE = "TITLE";
    public static final String ORGANIZATIONUNIT = "ORGANIZATIONUNIT";
    public static final String ORGANIZATION = "ORGANIZATION";
    public static final String LOCALE = "LOCALE";
    public static final String STATE = "STATE";
    public static final String DOMAINCOMPONENT = "DOMAINCOMPONENT";
    public static final String COUNTRY = "COUNTRY";
    public static final String UNSTRUCTUREDADDRESS = "UNSTRUCTUREDADDRESS";
    public static final String UNSTRUCTUREDNAME = "UNSTRUCTUREDNAME";
    public static final String POSTALCODE = "POSTALCODE";
    public static final String BUSINESSCATEGORY = "BUSINESSCATEGORY";
    public static final String POSTALADDRESS = "POSTALADDRESS";
    public static final String TELEPHONENUMBER = "TELEPHONENUMBER";
    public static final String RFC822NAME = "RFC822NAME";
    public static final String DNSNAME = "DNSNAME";
    public static final String IPADDRESS = "IPADDRESS";
    public static final String UNIFORMRESOURCEID = "UNIFORMRESOURCEID";
    public static final String DIRECTORYNAME = "DIRECTORYNAME";
    public static final String UPN = "UPN";
    public static final String GUID = "GUID";
    public static final String OTHERNAME = "OTHERNAME";
    public static final String X400ADDRESS = "X400ADDRESS";
    public static final String EDIPARTNAME = "EDIPARTNAME";
    public static final String REGISTEREDID = "REGISTEREDID";
    public static final String DATEOFBIRTH = "DATEOFBIRTH";
    public static final String PLACEOFBIRTH = "PLACEOFBIRTH";
    public static final String GENDER = "GENDER";
    public static final String COUNTRYOFCITIZENSHIP = "COUNTRYOFCITIZENSHIP";
    public static final String COUNTRYOFRESIDENCE = "COUNTRYOFRESIDENCE";
    private static HashMap dnNameIdMap;
    private static HashMap profileNameIdMap;
    private static HashMap dnIdToProfileNameMap;
    private static HashMap dnIdToProfileIdMap;
    private static HashMap profileIdToDnIdMap;
    private static HashMap dnErrorTextMap;
    private static HashMap profileNameLanguageMap;
    private static HashMap profileIdLanguageMap;
    private static HashMap dnIdErrorMap;
    private static HashMap dnIdToExtractorFieldMap;
    private static HashMap altNameIdToExtractorFieldMap;
    private static HashMap dirAttrIdToExtractorFieldMap;
    private static ArrayList dnProfileFields;
    private static ArrayList dnLanguageTexts;
    private static ArrayList dnDnIds;
    private static ArrayList altNameFields;
    private static ArrayList altNameLanguageTexts;
    private static ArrayList altNameDnIds;
    private static ArrayList dirAttrFields;
    private static ArrayList dirAttrLanguageTexts;
    private static ArrayList dirAttrDnIds;
    private static ArrayList dnExtractorFields;
    private static ArrayList altNameExtractorFields;
    private static ArrayList dirAttrExtractorFields;
    private static final boolean reverseOrder;

    public static boolean isReverseOrder() {
        return reverseOrder;
    }

    public static DERObjectIdentifier getOid(String o) {
        return (DERObjectIdentifier)oids.get(o.toLowerCase());
    }

    public static ArrayList getDnProfileFields() {
        return dnProfileFields;
    }

    public static ArrayList getDnLanguageTexts() {
        return dnLanguageTexts;
    }

    public static ArrayList getAltNameFields() {
        return altNameFields;
    }

    public static ArrayList getAltNameLanguageTexts() {
        return altNameLanguageTexts;
    }

    public static ArrayList getDirAttrFields() {
        return dirAttrFields;
    }

    public static ArrayList getDirAttrDnIds() {
        return dirAttrDnIds;
    }

    public static ArrayList getAltNameDnIds() {
        return altNameDnIds;
    }

    public static ArrayList getDnDnIds() {
        return dnDnIds;
    }

    protected static ArrayList getDnExtractorFields() {
        return dnExtractorFields;
    }

    protected static String getDnExtractorFieldFromDnId(int field) {
        String val = (String)dnIdToExtractorFieldMap.get(new Integer(field));
        return val;
    }

    protected static ArrayList getAltNameExtractorFields() {
        return altNameExtractorFields;
    }

    protected static String getAltNameExtractorFieldFromDnId(int field) {
        String val = (String)altNameIdToExtractorFieldMap.get(new Integer(field));
        return val;
    }

    protected static ArrayList getDirAttrExtractorFields() {
        return dirAttrExtractorFields;
    }

    protected static String getDirAttrExtractorFieldFromDnId(int field) {
        String val = (String)dirAttrIdToExtractorFieldMap.get(new Integer(field));
        return val;
    }

    public static String dnIdToProfileName(int dnid) {
        String val = (String)dnIdToProfileNameMap.get(new Integer(dnid));
        return val;
    }

    public static int dnIdToProfileId(int dnid) {
        Integer val = (Integer)dnIdToProfileIdMap.get(new Integer(dnid));
        return val;
    }

    public static String getLanguageConstantFromProfileName(String name) {
        String ret = (String)profileNameLanguageMap.get(name);
        return ret;
    }

    public static String getLanguageConstantFromProfileId(int id) {
        String ret = (String)profileIdLanguageMap.get(new Integer(id));
        return ret;
    }

    public static String getErrTextFromDnId(int id) {
        String ret = (String)dnIdErrorMap.get(new Integer(id));
        return ret;
    }

    public static HashMap getProfilenameIdMap() {
        return profileNameIdMap;
    }

    public static int profileIdToDnId(int profileid) {
        Integer val = (Integer)profileIdToDnIdMap.get(new Integer(profileid));
        if (val == null) {
            log.error((Object)("No dn id mapping from profile id " + profileid));
        }
        return val;
    }

    public static String[] getDnObjects() {
        if (!reverseOrder) {
            return dNObjectsForward;
        }
        return DnComponents.getDnObjectsReverse();
    }

    public static String[] getDnObjects(boolean ldaporder) {
        if (ldaporder) {
            return dNObjectsForward;
        }
        return DnComponents.getDnObjectsReverse();
    }

    protected static String[] getDnObjectsReverse() {
        if (dNObjectsReverse == null) {
            dNObjectsReverse = (String[])dNObjectsForward.clone();
            ArrayUtils.reverse((Object[])dNObjectsReverse);
        }
        return dNObjectsReverse;
    }

    private static void load() {
        DnComponents.loadOrdering();
        DnComponents.loadMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMappings() {
        block23: {
            BufferedReader in = null;
            InputStreamReader inf = null;
            try {
                InputStream is = obj.getClass().getResourceAsStream("/profilemappings.properties");
                if (is != null) {
                    String line;
                    inf = new InputStreamReader(is);
                    in = new BufferedReader(inf);
                    if (!in.ready()) {
                        throw new IOException();
                    }
                    String[] splits = null;
                    int lines = 0;
                    ArrayList<Integer> dnids = new ArrayList<Integer>();
                    ArrayList<Integer> profileids = new ArrayList<Integer>();
                    while ((line = in.readLine()) != null) {
                        if (line.startsWith("#") || (splits = StringUtils.split((String)line, (char)';')) == null || splits.length <= 5) continue;
                        String type = splits[0];
                        String dnname = splits[1];
                        Integer dnid = new Integer(splits[2]);
                        String profilename = splits[3];
                        Integer profileid = new Integer(splits[4]);
                        String errstr = splits[5];
                        String langstr = splits[6];
                        if (dnids.contains(dnid)) {
                            log.error((Object)("Duplicated DN Id " + dnid + " detected in mapping file."));
                        } else {
                            dnids.add(dnid);
                        }
                        if (profileids.contains(profileid)) {
                            log.error((Object)("Duplicated Profile Id " + profileid + " detected in mapping file."));
                        } else {
                            profileids.add(profileid);
                        }
                        dnNameIdMap.put(dnname, dnid);
                        profileNameIdMap.put(profilename, profileid);
                        dnIdToProfileNameMap.put(dnid, profilename);
                        dnIdToProfileIdMap.put(dnid, profileid);
                        dnIdErrorMap.put(dnid, errstr);
                        profileIdToDnIdMap.put(profileid, dnid);
                        dnErrorTextMap.put(dnid, errstr);
                        profileNameLanguageMap.put(profilename, langstr);
                        profileIdLanguageMap.put(profileid, langstr);
                        if (type.equals(DNQUALIFIER)) {
                            dnProfileFields.add(profilename);
                            dnLanguageTexts.add(langstr);
                            dnDnIds.add(dnid);
                            dnExtractorFields.add(dnname + "=");
                            dnIdToExtractorFieldMap.put(dnid, dnname + "=");
                        }
                        if (type.equals("ALTNAME")) {
                            altNameFields.add(dnname);
                            altNameLanguageTexts.add(langstr);
                            altNameDnIds.add(dnid);
                            altNameExtractorFields.add(dnname + "=");
                            altNameIdToExtractorFieldMap.put(dnid, dnname + "=");
                        }
                        if (type.equals("DIRATTR")) {
                            dirAttrFields.add(dnname);
                            dirAttrLanguageTexts.add(langstr);
                            dirAttrDnIds.add(dnid);
                            dirAttrExtractorFields.add(dnname + "=");
                            dirAttrIdToExtractorFieldMap.put(dnid, dnname + "=");
                        }
                        ++lines;
                    }
                    in.close();
                    log.debug((Object)("Read profile maps with " + lines + " lines."));
                    break block23;
                }
                throw new IOException("Input stream for /profilemappings.properties is null");
            }
            catch (IOException e) {
                log.error((Object)"Can not load profile mappings: ", (Throwable)e);
            }
            finally {
                try {
                    if (inf != null) {
                        inf.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadOrdering() {
        LinkedHashMap<String, DERObjectIdentifier> map = new LinkedHashMap<String, DERObjectIdentifier>();
        BufferedReader in = null;
        InputStreamReader inf = null;
        try {
            InputStream is = obj.getClass().getResourceAsStream("/dncomponents.properties");
            if (is != null) {
                String line;
                inf = new InputStreamReader(is);
                in = new BufferedReader(inf);
                if (!in.ready()) {
                    throw new IOException();
                }
                String[] splits = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#") || (splits = StringUtils.split((String)line, (char)'=')) == null || splits.length <= 1) continue;
                    String name = splits[0];
                    DERObjectIdentifier oid = new DERObjectIdentifier(splits[1]);
                    map.put(name, oid);
                }
                in.close();
                log.info((Object)"Using DN components from properties file");
                oids.clear();
                oids.putAll(map);
                Set keys = map.keySet();
                dNObjectsForward = keys.toArray(new String[0]);
            } else {
                log.debug((Object)"Using default values for DN components");
            }
        }
        catch (IOException e) {
            log.debug((Object)"Using default values for DN components");
        }
        finally {
            try {
                if (inf != null) {
                    inf.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        oids.put("c", X509Name.C);
        oids.put("dc", X509Name.DC);
        oids.put("st", X509Name.ST);
        oids.put("l", X509Name.L);
        oids.put("o", X509Name.O);
        oids.put("ou", X509Name.OU);
        oids.put("t", X509Name.T);
        oids.put("surname", X509Name.SURNAME);
        oids.put("initials", X509Name.INITIALS);
        oids.put("givenname", X509Name.GIVENNAME);
        oids.put("gn", X509Name.GIVENNAME);
        oids.put("sn", X509Name.SN);
        oids.put("serialnumber", X509Name.SN);
        oids.put("cn", X509Name.CN);
        oids.put("uid", X509Name.UID);
        oids.put("dn", X509Name.DN_QUALIFIER);
        oids.put("emailaddress", X509Name.EmailAddress);
        oids.put("e", X509Name.EmailAddress);
        oids.put("email", X509Name.EmailAddress);
        oids.put("unstructuredname", X509Name.UnstructuredName);
        oids.put("unstructuredaddress", X509Name.UnstructuredAddress);
        oids.put("postalcode", X509Name.POSTAL_CODE);
        oids.put("businesscategory", X509Name.BUSINESS_CATEGORY);
        oids.put("postaladdress", X509Name.POSTAL_ADDRESS);
        dNObjectsForward = new String[]{"telephonenumber", "postaladdress", "businesscategory", "postalcode", "unstructuredaddress", "unstructuredname", "emailaddress", "e", "email", "dn", "uid", "cn", "sn", "serialnumber", "gn", "givenname", "initials", "surname", "t", "ou", "o", "l", "st", "dc", "c"};
        dNObjectsReverse = null;
        dnNameIdMap = new HashMap();
        profileNameIdMap = new HashMap();
        dnIdToProfileNameMap = new HashMap();
        dnIdToProfileIdMap = new HashMap();
        profileIdToDnIdMap = new HashMap();
        dnErrorTextMap = new HashMap();
        profileNameLanguageMap = new HashMap();
        profileIdLanguageMap = new HashMap();
        dnIdErrorMap = new HashMap();
        dnIdToExtractorFieldMap = new HashMap();
        altNameIdToExtractorFieldMap = new HashMap();
        dirAttrIdToExtractorFieldMap = new HashMap();
        dnProfileFields = new ArrayList();
        dnLanguageTexts = new ArrayList();
        dnDnIds = new ArrayList();
        altNameFields = new ArrayList();
        altNameLanguageTexts = new ArrayList();
        altNameDnIds = new ArrayList();
        dirAttrFields = new ArrayList();
        dirAttrLanguageTexts = new ArrayList();
        dirAttrDnIds = new ArrayList();
        dnExtractorFields = new ArrayList();
        altNameExtractorFields = new ArrayList();
        dirAttrExtractorFields = new ArrayList();
        DnComponents.load();
        reverseOrder = BooleanUtils.toBoolean((String)"@certtools.dnorderreverse@");
    }
}

