/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import com.itrus.util.DERUtils;
import com.itrus.util.RegexUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUtils {
    private static Log log = LogFactory.getLog(LdapUtils.class);

    public static Attributes getEntryAttributes(String ldapUrl, String[] attrNames) throws NamingException {
        String entryDn = RegexUtils.exceptMatches(ldapUrl, "^ldap://.*/");
        log.debug((Object)("Entry DN=[" + entryDn + "]"));
        String ldapInfo = RegexUtils.exceptMatches(ldapUrl, "^ldap://|/.*");
        String ldapUser = null;
        String ldapPass = null;
        String ldapServerIp = null;
        String ldapPort = "389";
        if (ldapInfo.indexOf("@") > 0) {
            String ldapCredentials = RegexUtils.exceptMatches(ldapInfo, "@.*");
            log.debug((Object)("Ldap Credentials=[" + ldapCredentials + "]"));
            ldapUser = RegexUtils.exceptMatches(ldapCredentials, ":.*");
            log.debug((Object)("Ldap User=[" + ldapUser + "]"));
            ldapPass = RegexUtils.exceptMatches(ldapCredentials, "^" + ldapUser + ":");
            log.debug((Object)("Ldap Password=[" + ldapPass + "]"));
            String ldapServerInfo = RegexUtils.exceptMatches(ldapInfo, ".*@");
            log.debug((Object)("Ldap Server Url=[ldap://" + ldapServerInfo + "]"));
            if (ldapServerInfo.indexOf(":") > 0) {
                ldapServerIp = RegexUtils.exceptMatches(ldapServerInfo, ":.*");
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                ldapPort = RegexUtils.exceptMatches(ldapServerInfo, ".*:");
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            } else {
                ldapServerIp = ldapServerInfo;
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            }
        } else {
            log.debug((Object)("Ldap User=[" + ldapUser + "]"));
            log.debug((Object)("Ldap Password=[" + ldapPass + "]"));
            log.debug((Object)("Ldap Server Url=[ldap://" + ldapInfo + "]"));
            if (ldapInfo.indexOf(":") > 0) {
                ldapServerIp = RegexUtils.exceptMatches(ldapInfo, ":.*");
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                ldapPort = RegexUtils.exceptMatches(ldapInfo, ".*:");
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            } else {
                ldapServerIp = ldapInfo;
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                ldapPort = "389";
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            }
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapInfo = "ldap://" + ldapServerIp + ":" + ldapPort;
        env.put("java.naming.provider.url", ldapInfo);
        if (ldapUser == null) {
            env.put("java.naming.security.authentication", "none");
        } else {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", ldapUser);
            env.put("java.naming.security.credentials", ldapPass);
        }
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        try {
            entryDn = URLDecoder.decode(entryDn, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Attributes result = ctx.getAttributes(entryDn, attrNames);
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Attribute getEntryAttribute(String ldapUrl, String attrName) throws NamingException {
        String[] attrNames = new String[]{attrName};
        Attributes attrs = LdapUtils.getEntryAttributes(ldapUrl, attrNames);
        Attribute attr = attrs.get(attrName);
        return attr;
    }

    public static String getEntryStringAttr(String ldapUrl, String attrName) throws NamingException {
        Attribute attr = LdapUtils.getEntryAttribute(ldapUrl, attrName);
        return (String)attr.get();
    }

    public static byte[] getEntryBinaryAttr(String ldapUrl, String attrName) throws NamingException {
        Attribute attr = LdapUtils.getEntryAttribute(ldapUrl, attrName);
        byte[] buffer = (byte[])attr.get();
        return buffer;
    }

    static String AddLeadingZero(int k) {
        return k <= 15 ? "0" + Integer.toHexString(k) : Integer.toHexString(k);
    }

    public static String guidToHexString(String s) {
        if (s == null) {
            throw new NullPointerException("Parameter byte[] GUID is null");
        }
        if (s.startsWith("{")) {
            s = s.substring(1);
        }
        if (s.endsWith("}")) {
            s = s.substring(0, s.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "-");
        String s5 = null;
        String s4 = null;
        String s3 = null;
        String s2 = null;
        String s1 = null;
        String temp = null;
        int i = 1;
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            switch (i) {
                case 1: {
                    s1 = temp;
                    break;
                }
                case 2: {
                    s2 = temp;
                    break;
                }
                case 3: {
                    s3 = temp;
                    break;
                }
                case 4: {
                    s4 = temp;
                    break;
                }
                case 5: {
                    s5 = temp;
                    break;
                }
            }
            ++i;
        }
        sb.append(s1.substring(6, 8));
        sb.append(s1.substring(4, 6));
        sb.append(s1.substring(2, 4));
        sb.append(s1.substring(0, 2));
        sb.append(s2.substring(2, 4));
        sb.append(s2.substring(0, 2));
        sb.append(s3.substring(2, 4));
        sb.append(s3.substring(0, 2));
        sb.append(s4.substring(0, 2));
        sb.append(s4.substring(2, 4));
        sb.append(s5.substring(0, 2));
        sb.append(s5.substring(2, 4));
        sb.append(s5.substring(4, 6));
        sb.append(s5.substring(6, 8));
        sb.append(s5.substring(8, 10));
        sb.append(s5.substring(10, 12));
        return sb.toString();
    }

    public static String guidToQueryString(String s) {
        if (s == null) {
            throw new NullPointerException("Parameter byte[] GUID is null");
        }
        if (s.startsWith("{")) {
            s = s.substring(1);
        }
        if (s.endsWith("}")) {
            s = s.substring(0, s.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "-");
        String s5 = null;
        String s4 = null;
        String s3 = null;
        String s2 = null;
        String s1 = null;
        String temp = null;
        int i = 1;
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            switch (i) {
                case 1: {
                    s1 = temp;
                    break;
                }
                case 2: {
                    s2 = temp;
                    break;
                }
                case 3: {
                    s3 = temp;
                    break;
                }
                case 4: {
                    s4 = temp;
                    break;
                }
                case 5: {
                    s5 = temp;
                    break;
                }
            }
            ++i;
        }
        sb.append("\\" + s1.substring(6, 8));
        sb.append("\\" + s1.substring(4, 6));
        sb.append("\\" + s1.substring(2, 4));
        sb.append("\\" + s1.substring(0, 2));
        sb.append("\\" + s2.substring(2, 4));
        sb.append("\\" + s2.substring(0, 2));
        sb.append("\\" + s3.substring(2, 4));
        sb.append("\\" + s3.substring(0, 2));
        sb.append("\\" + s4.substring(0, 2));
        sb.append("\\" + s4.substring(2, 4));
        sb.append("\\" + s5.substring(0, 2));
        sb.append("\\" + s5.substring(2, 4));
        sb.append("\\" + s5.substring(4, 6));
        sb.append("\\" + s5.substring(6, 8));
        sb.append("\\" + s5.substring(8, 10));
        sb.append("\\" + s5.substring(10, 12));
        return sb.toString();
    }

    public static String parseGUID(byte[] bGUID) throws IOException {
        if (bGUID == null) {
            throw new NullPointerException("Parameter byte[] GUID is null");
        }
        if (bGUID.length != 16) {
            throw new IOException("Parameter byte[] GUID is not 16 bytes.");
        }
        StringBuffer sbGUID = new StringBuffer();
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[3] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[2] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[1] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[0] & 0xFF));
        sbGUID.append("-");
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[5] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[4] & 0xFF));
        sbGUID.append("-");
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[7] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[6] & 0xFF));
        sbGUID.append("-");
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[8] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[9] & 0xFF));
        sbGUID.append("-");
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[10] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[11] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[12] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[13] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[14] & 0xFF));
        sbGUID.append(LdapUtils.AddLeadingZero(bGUID[15] & 0xFF));
        return sbGUID.toString().toUpperCase();
    }

    public static byte[] parseGUID(String guid) throws IOException {
        if (guid == null) {
            throw new NullPointerException("Parameter byte[] GUID is null");
        }
        if (guid.startsWith("{")) {
            guid = guid.substring(1);
        }
        if (guid.endsWith("}")) {
            guid = guid.substring(0, guid.length() - 1);
        }
        byte[] bytes = DERUtils.HexToBytes(LdapUtils.guidToHexString(guid));
        return bytes;
    }

    public static String escapeDN(String name) {
        StringBuilder sb = new StringBuilder();
        if (name.length() > 0 && (name.charAt(0) == ' ' || name.charAt(0) == '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < name.length(); ++i) {
            char curChar = name.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case ',': {
                    sb.append("\\,");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        if (name.length() > 1 && name.charAt(name.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    public static final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }
}

