/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import com.itrus.util.KeyType;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class PKIUtil {
    public static Certificate conertCert(InputStream in) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        return cf.generateCertificate(in);
    }

    public static Certificate[] conertCertChain(InputStream in) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        Collection<? extends Certificate> c = cf.generateCertificates(in);
        return c.toArray(new Certificate[c.size() - 1]);
    }

    public static CRL conertCRL(InputStream in) throws CRLException, CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        return cf.generateCRL(in);
    }

    public static Key convertKey(String type, String algorithm, byte[] keyBuf) throws KeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        Key key = null;
        if (KeyType.PRIVATE.equalsIgnoreCase(type)) {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBuf);
            key = keyFactory.generatePrivate(keySpec);
        } else if (KeyType.PUBLIC.equalsIgnoreCase(type)) {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBuf);
            key = keyFactory.generatePublic(keySpec);
        } else {
            throw new KeyException("Key type is not supported.");
        }
        return key;
    }

    public static PublicKey convertRSAPublicKey(BigInteger modulus, BigInteger exponent) throws KeyException {
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
        PublicKey publicKey = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            publicKey = kf.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException("Invalid RSAPublicKey modulus.");
        }
        catch (InvalidKeySpecException e) {
            throw new KeyException("Invalid RSAPublicKey modulus or exponent.");
        }
        return publicKey;
    }

    public static SecretKey genSecretKey(String alias, String keyAlgName, int keysize, Provider p) throws Exception {
        KeyGenerator keygen = p != null ? KeyGenerator.getInstance(keyAlgName, p) : KeyGenerator.getInstance(keyAlgName);
        if (keysize != -1) {
            keygen.init(keysize);
        } else if ("DES".equalsIgnoreCase(keyAlgName)) {
            keygen.init(56);
        } else if ("DESede".equalsIgnoreCase(keyAlgName)) {
            keygen.init(168);
        } else {
            throw new Exception("Please provide keysize for secret key generation");
        }
        return keygen.generateKey();
    }

    public static KeyPair genKeyPair(String keyAlgName, int keysize, Provider p) throws Exception {
        if (keysize == -1) {
            keysize = "EC".equalsIgnoreCase(keyAlgName) ? 256 : 1024;
        }
        KeyPairGenerator keyPairGen = p != null ? KeyPairGenerator.getInstance(keyAlgName, p) : KeyPairGenerator.getInstance(keyAlgName);
        keyPairGen.initialize(keysize);
        return keyPairGen.generateKeyPair();
    }

    public static void checkKeySize(String algorithm, int keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (algorithm.equals("EC")) {
            if (keySize < 112) {
                throw new InvalidAlgorithmParameterException("Key size must be at least 112 bit");
            }
            if (keySize > 2048) {
                throw new InvalidAlgorithmParameterException("Key size must be at most 2048 bit");
            }
            return;
        }
        if (algorithm.equals("RSA")) {
            BigInteger tmpExponent = RSAKeyGenParameterSpec.F4;
            if (params != null) {
                tmpExponent = ((RSAKeyGenParameterSpec)params).getPublicExponent();
            }
            try {
                int j = 512;
                int k = 65536;
                if (j > 0 && keySize < j) {
                    throw new InvalidKeyException(new StringBuffer().append("RSA keys must be at least ").append(j).append(" bits long").toString());
                }
                int l = Math.min(k, 16384);
                if (keySize > l) {
                    throw new InvalidKeyException(new StringBuffer().append("RSA keys must be no longer than ").append(l).append(" bits").toString());
                }
                if (tmpExponent != null && keySize > 3072 && tmpExponent.bitLength() > 64) {
                    throw new InvalidKeyException("RSA exponents can be no longer than 64 bits  if modulus is greater than 3072 bits");
                }
            }
            catch (InvalidKeyException e) {
                throw new InvalidAlgorithmParameterException(e.getMessage());
            }
            return;
        }
        if (keySize < 512) {
            throw new InvalidAlgorithmParameterException("Key size must be at least 512 bit");
        }
        if (algorithm.equals("DH") && params != null) {
            if (keySize > 65536) {
                throw new InvalidAlgorithmParameterException("Key size must be at most 65536 bit");
            }
        } else if (keySize > 1024 || (keySize & 0x3F) != 0) {
            throw new InvalidAlgorithmParameterException("Key size must be a multiple of 64 and at most 1024 bit");
        }
    }
}

