/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.EANEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class EAN8Encoder
extends EANEncoder {
    private static EAN8Encoder instance;

    private EAN8Encoder() {
    }

    public static EAN8Encoder getInstance() {
        if (instance == null) {
            instance = new EAN8Encoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() != 8) {
            throw new InvalidAtributeException("[EAN8] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[11];
        try {
            int n;
            int n2;
            barSetArray[0] = LEFT_GUARD;
            for (n2 = 0; n2 < 4; ++n2) {
                n = EAN8Encoder.charToInt(string.charAt(n2));
                barSetArray[n2 + 1] = CODES[n].xorTrue();
            }
            barSetArray[5] = CENTER_GUARD;
            for (n2 = 4; n2 < 8; ++n2) {
                n = EAN8Encoder.charToInt(string.charAt(n2));
                barSetArray[n2 + 2] = CODES[n];
            }
            barSetArray[10] = RIGTH_GUARD;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidAtributeException("[EAN8] Only numbers suported.");
        }
        return barSetArray;
    }

    public String toString() {
        return "EAN 8";
    }
}

