/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class MSIPlesseyEncoder
implements BarcodeEncoder {
    private static MSIPlesseyEncoder instance;
    protected BarSet[] CODES_WIDTH = new BarSet[]{new BarSet("100100100100"), new BarSet("100100100110"), new BarSet("100100110100"), new BarSet("100100110110"), new BarSet("100110100100"), new BarSet("100110100110"), new BarSet("100110110100"), new BarSet("100110110110"), new BarSet("110100100100"), new BarSet("110100100110")};
    protected BarSet START_CHAR = new BarSet("110");
    protected BarSet STOP_CHAR = new BarSet("1001");

    protected MSIPlesseyEncoder() {
    }

    public static BarcodeEncoder getInstance() {
        if (instance == null) {
            instance = new MSIPlesseyEncoder();
        }
        return instance;
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = string.length() - 1; n >= 0; n -= 2) {
            stringBuffer.insert(0, string.charAt(n));
            if (n <= 0) continue;
            stringBuffer2.append(string.charAt(n - 1));
        }
        stringBuffer2.append(2 * Integer.parseInt(stringBuffer.toString()));
        n = 0;
        String string2 = stringBuffer2.toString();
        for (int i = 0; i < string2.length(); ++i) {
            n += MSIPlesseyEncoder.charToInt(string2.charAt(i));
        }
        return Integer.toString(10 - (n % 10 == 0 ? 10 : n % 10));
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        BarSet[] barSetArray = new BarSet[string.length() + 2];
        try {
            barSetArray[0] = this.START_CHAR;
            for (int i = 0; i < string.length(); ++i) {
                barSetArray[i + 1] = this.CODES_WIDTH[MSIPlesseyEncoder.charToInt(string.charAt(i))];
            }
            barSetArray[barSetArray.length - 1] = this.STOP_CHAR;
        }
        catch (Exception exception) {
            throw new InvalidAtributeException("[MSIPlessey] Only numbers suported.");
        }
        return barSetArray;
    }

    protected static int charToInt(char c) {
        return c - 48;
    }

    public String toString() {
        return "MSI/Plessey";
    }
}

