/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class Standard2of5Encoder
implements BarcodeEncoder {
    protected final BarSet[] CODES_WIDTH = new BarSet[]{new BarSet("00110"), new BarSet("10001"), new BarSet("01001"), new BarSet("11000"), new BarSet("00101"), new BarSet("10100"), new BarSet("01100"), new BarSet("00011"), new BarSet("10010"), new BarSet("01010")};
    private static BarSet START_CHAR = new BarSet("101000");
    private static BarSet STOP_CHAR = new BarSet("10001");
    protected BarSet INTER_CHAR = new BarSet("0");
    private static Standard2of5Encoder instance;

    protected Standard2of5Encoder() {
    }

    public static Standard2of5Encoder getInstance() {
        if (instance == null) {
            instance = new Standard2of5Encoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 1) {
            throw new InvalidAtributeException("[Standard2of5] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[string.length() + 2];
        try {
            int n = 10;
            barSetArray[0] = START_CHAR;
            for (int i = 0; i < string.length(); ++i) {
                int n2 = Standard2of5Encoder.charToInt(string.charAt(i));
                barSetArray[i + 1] = new BarSet(n);
                int n3 = 0;
                for (int j = 0; j < this.CODES_WIDTH[n2].length(); ++j) {
                    if (this.CODES_WIDTH[n2].get(j)) {
                        barSetArray[i + 1].set(n3);
                    }
                    n3 += 2;
                }
            }
            barSetArray[barSetArray.length - 1] = STOP_CHAR;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidAtributeException("[Standard2of5] Only numbers suported.");
        }
        return barSetArray;
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (n % 2 == 0) {
                n2 += Standard2of5Encoder.charToInt(string.charAt(n)) * 3;
                continue;
            }
            n2 += Standard2of5Encoder.charToInt(string.charAt(n));
        }
        n = n2 % 10;
        if (n == 0) {
            return "0";
        }
        return String.valueOf(10 - n);
    }

    public String toString() {
        return "Standard/Industrial 2of5";
    }

    protected static int charToInt(char c) {
        return c - 48;
    }
}

