/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.util.HashMap;
import java.util.Map;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.InternetExplorerEngine;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;

public class BrowserEngineManager {
    private static final String ORG_JDESKTOP_JDIC_BROWSER_BROWSERMANAGER = "org.jdesktop.jdic.browser.BrowserManager";
    private static BrowserEngineManager managerInstance = null;
    public static String MOZILLA = "Mozilla";
    public static String IE = "Internet Explorer";
    public static String WEBKIT = "WebKit";
    private static Map engines = new HashMap();
    private static IBrowserEngine activeEngine = null;

    private BrowserEngineManager() {
        this.initExitingEngines();
    }

    protected void initExitingEngines() {
        this.registerBrowserEngine(IE, new InternetExplorerEngine());
    }

    public static synchronized BrowserEngineManager instance() {
        if (managerInstance == null) {
            String cname = System.getProperty(ORG_JDESKTOP_JDIC_BROWSER_BROWSERMANAGER);
            if (cname != null) {
                WebBrowserUtil.trace("Specified browserManager " + cname);
                try {
                    managerInstance = (BrowserEngineManager)Class.forName(cname).newInstance();
                }
                catch (ClassCastException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (managerInstance == null) {
                WebBrowserUtil.trace("Default browserManager is used.");
                managerInstance = new BrowserEngineManager();
            }
        }
        return managerInstance;
    }

    public Map getEngines() {
        return engines;
    }

    public boolean registerBrowserEngine(String engineName, IBrowserEngine engine) {
        if (engines.containsKey(engineName)) {
            WebBrowserUtil.trace("Engine " + engineName + " has been registered.");
            return true;
        }
        if (engine == null) {
            WebBrowserUtil.error("Engine " + engineName + " is null.");
            return false;
        }
        if (this.checkEnginesWhenAdded()) {
            if (engine.isEngineAvailable()) {
                engines.put(engineName, engine);
                return true;
            }
        } else {
            engines.put(engineName, engine);
            return true;
        }
        return false;
    }

    public boolean removeBrowserEngine(String engineName) {
        if (!engines.containsKey(engineName)) {
            return true;
        }
        IBrowserEngine engine = (IBrowserEngine)engines.get(engineName);
        if (engine == activeEngine) {
            WebBrowserUtil.error("Can't remove active engine!");
            return false;
        }
        WebBrowserUtil.trace("Engine " + engineName + " will be removed.");
        return engines.remove(engineName) != null;
    }

    protected void selectEngine() throws JdicInitException {
        if (activeEngine != null) {
            WebBrowserUtil.trace("Engine " + activeEngine.getBrowserName() + " is active,won't select.");
            return;
        }
        String defaultBrowserpath = WebBrowserUtil.getDefaultBrowserPath();
        WebBrowserUtil.trace(defaultBrowserpath);
        if (defaultBrowserpath == null) {
            WebBrowserUtil.trace("No defaultBrowser is detected! You must specify a browser engine by setActiveEngine()!");
            return;
        }
        for (String engineName : engines.keySet()) {
            IBrowserEngine engine = (IBrowserEngine)engines.get(engineName);
            if (!engine.isEngineAvailable() || !engine.getBrowserName().equalsIgnoreCase(IE)) continue;
            activeEngine = engine;
            break;
        }
        if (activeEngine == null) {
            WebBrowserUtil.trace("No browser is selected as active,you must specify one by setActiveEngine()!");
        }
    }

    protected boolean checkEnginesWhenAdded() {
        return true;
    }

    public IBrowserEngine setActiveEngine(String engineName) {
        if (activeEngine != null && activeEngine.isInitialized()) {
            WebBrowserUtil.error("Engine " + activeEngine.getBrowserName() + "has been initialized,can't change it anymore!");
        }
        if (!engines.containsKey(engineName)) {
            WebBrowserUtil.error("Can't find engine " + engineName);
            return null;
        }
        IBrowserEngine engine = (IBrowserEngine)engines.get(engineName);
        if (engine == activeEngine) {
            return activeEngine;
        }
        if (!engine.isEngineAvailable()) {
            WebBrowserUtil.trace("Engine " + engineName + " isn't available.");
            return null;
        }
        activeEngine = engine;
        WebBrowserUtil.trace("Engine " + engineName + " is set as activeEngine.");
        return activeEngine;
    }

    public IBrowserEngine getActiveEngine() {
        if (activeEngine == null) {
            try {
                this.selectEngine();
            }
            catch (JdicInitException e) {
                WebBrowserUtil.error(e.getMessage());
                e.printStackTrace();
            }
        }
        return activeEngine;
    }
}

