/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.net.URL;
import java.security.AccessControlException;
import org.jdesktop.jdic.browser.ILinkInterceptionHandler;
import org.jdesktop.jdic.browser.OpenLinkEvent;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;

public class DefaultLinkInterceptionHandler
implements ILinkInterceptionHandler {
    public boolean shouldOpenLink(OpenLinkEvent event) {
        URL url = event.getURL();
        switch (event.getID()) {
            case 1: {
                if (url == null) {
                    return true;
                }
                WebBrowserUtil.trace("URL = " + url.toString());
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    try {
                        security.checkConnect(url.getHost(), url.getPort());
                    }
                    catch (AccessControlException e) {
                        return false;
                    }
                }
                return true;
            }
            case 2: {
                if (url != null) {
                    WebBrowserUtil.trace("willOpenWindow " + url.toString());
                }
                return true;
            }
        }
        throw new IllegalStateException("Unhandled window state");
    }
}

