/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.io.File;
import java.io.IOException;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class MozillaEngine
implements IBrowserEngine {
    private static final String BROWSER_NAME = BrowserEngineManager.MOZILLA;
    private static final String MOZILLA_FIVE_HOME = "MOZILLA_FIVE_HOME";
    private static final String BIN_WIN_MOZILLA = "MozEmbed.exe";
    private static final String BIN_LINUX_GTK1 = "mozembed-linux-gtk1.2";
    private static final String BIN_linux_GTK2 = "mozembed-linux-gtk2";
    private static final String BIN_FREEBSD_GTK1 = "mozembed-freebsd-gtk1.2";
    private static final String BIN_FREEBSD_GTK2 = "mozembed-freebsd-gtk2";
    private static final String BIN_SOLARIS_GTK1 = "mozembed-solaris-gtk1.2";
    private static final String BIN_SOLARIS_GTK2 = "mozembed-solaris-gtk2";
    private static boolean isEngineAvailable = true;
    private static boolean initialized = false;
    private static final String libPathEnv = WebBrowserUtil.LIB_PATH_ENV;
    private String envXPComPath;
    private String browserBinName;
    private String runningPath;
    private String xpcomPathSetByUser;

    public void initialize() throws JdicInitException {
        if (!initialized) {
            this.preapareEnvVariables();
            this.setToEnv();
            this.dealMozillaBinFile(this.envXPComPath);
            initialized = true;
            WebBrowserUtil.trace("Mozilla Engine intialized");
        }
    }

    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public boolean isEngineAvailable() {
        return isEngineAvailable;
    }

    public boolean isDefaultBrowser(String browserPath) {
        if (browserPath == null) {
            return false;
        }
        return browserPath.toLowerCase().indexOf(BROWSER_NAME.toLowerCase()) >= 0;
    }

    protected void preapareEnvVariables() throws JdicInitException {
        this.runningPath = JdicManager.getManager().getBinaryPath();
        if (this.getXPComPath(this.xpcomPathSetByUser)) {
            WebBrowserUtil.trace("Got xpcom from user set");
            return;
        }
        if (this.getXPComPath(InitUtility.getEnv(MOZILLA_FIVE_HOME))) {
            WebBrowserUtil.trace("Got xpcom from MOZILLA_FIVE_HOME");
            return;
        }
        String defaultBrowserPath = WebBrowserUtil.getDefaultBrowserPath();
        if (!this.isDefaultBrowser(defaultBrowserPath)) {
            WebBrowserUtil.error("Mozilla isn't default browser but set as active one, you must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
            throw new JdicInitException("Mozilla isn't default browser but set as active one, you must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
        }
        if (this.getXPComPath(defaultBrowserPath)) {
            WebBrowserUtil.trace("Got xpcom from registry(win)/path(unix)");
            return;
        }
        if (WebBrowserUtil.IS_OS_WINDOWS && this.getXPComPath(WebBrowserUtil.getMozillaGreHome())) {
            WebBrowserUtil.trace("Got xpcom from GREHome" + WebBrowserUtil.getMozillaGreHome());
            return;
        }
        isEngineAvailable = false;
        WebBrowserUtil.error("Can't find xpcom.dll/libxpcom.so!You must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
        throw new JdicInitException("Can't find xpcom.dll/libxpcom.so!You must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
    }

    private boolean getXPComPath(String inputPath) throws JdicInitException {
        if (inputPath == null) {
            return false;
        }
        String containingPath = inputPath.replaceAll("\"", "");
        String xpcomFolder = null;
        File browserFile = new File(containingPath);
        try {
            xpcomFolder = browserFile.isDirectory() ? browserFile.getCanonicalPath() : browserFile.getCanonicalFile().getParent();
        }
        catch (IOException ex) {
            WebBrowserUtil.trace(ex.toString());
            WebBrowserUtil.error("Path \"" + containingPath + "\" is invalide.");
            throw new JdicInitException(ex.getMessage());
        }
        if (this.isXPComPathValid(xpcomFolder)) {
            this.envXPComPath = xpcomFolder;
            return true;
        }
        return false;
    }

    private boolean isXPComPathValid(String xpcomFileContainPath) throws JdicInitException {
        String xpcomFileExtention = null;
        xpcomFileExtention = WebBrowserUtil.IS_OS_WINDOWS ? "xpcom.dll" : "libxpcom.so";
        String xpcomFile = String.valueOf(xpcomFileContainPath) + File.separator + xpcomFileExtention;
        return new File(xpcomFile).exists();
    }

    private void dealMozillaBinFile(String mozillaPath) throws JdicInitException {
        if (WebBrowserUtil.IS_OS_WINDOWS) {
            this.browserBinName = BIN_WIN_MOZILLA;
            return;
        }
        if (WebBrowserUtil.IS_OS_LINUX || WebBrowserUtil.IS_OS_SUNOS || WebBrowserUtil.IS_OS_FREEBSD) {
            this.dealUnixBinary(mozillaPath);
            return;
        }
        WebBrowserUtil.trace("Not suppored OS now!");
        isEngineAvailable = false;
        throw new JdicInitException("Unsupported OS!");
    }

    private void dealUnixBinary(String mozillaPath) throws JdicInitException {
        String osname = WebBrowserUtil.OS_NAME;
        String unixBinary = null;
        String libwidgetpath = String.valueOf(mozillaPath) + File.separator + "components" + File.separator + "libwidget_gtk2.so";
        File file = new File(libwidgetpath);
        if (!file.exists()) {
            if (WebBrowserUtil.IS_OS_LINUX) {
                unixBinary = BIN_LINUX_GTK1;
            } else if (WebBrowserUtil.IS_OS_SUNOS) {
                unixBinary = BIN_SOLARIS_GTK1;
            } else if (WebBrowserUtil.IS_OS_FREEBSD) {
                unixBinary = BIN_FREEBSD_GTK1;
            }
        } else if (WebBrowserUtil.IS_OS_LINUX) {
            unixBinary = BIN_linux_GTK2;
        } else if (WebBrowserUtil.IS_OS_SUNOS) {
            unixBinary = BIN_SOLARIS_GTK2;
        } else if (WebBrowserUtil.IS_OS_FREEBSD) {
            unixBinary = BIN_FREEBSD_GTK2;
        }
        if (unixBinary != null) {
            this.browserBinName = unixBinary;
            this.grantXToBin(unixBinary);
        } else {
            WebBrowserUtil.trace("Failed to grant executable privilege to bin file for your OS. You'd better grant all JDIC bin files with executable privilege manually. ");
        }
    }

    private void setToEnv() throws JdicInitException {
        String javaLibraryPath = System.getProperty("java.library.path", null);
        if (javaLibraryPath != null) {
            InitUtility.preAppendEnv(libPathEnv, javaLibraryPath);
        }
        InitUtility.preAppendEnv(libPathEnv, this.runningPath);
        InitUtility.preAppendEnv(libPathEnv, this.envXPComPath);
        InitUtility.setEnv(MOZILLA_FIVE_HOME, this.envXPComPath);
    }

    private boolean grantXToBin(String unixBinary) throws JdicInitException {
        Process p;
        block4: {
            WebBrowserUtil.trace("will grant a+x to " + this.runningPath + File.separator + unixBinary);
            p = Runtime.getRuntime().exec("chmod a+x " + this.runningPath + File.separator + unixBinary);
            int presult = p.waitFor();
            if (presult != 0) break block4;
            WebBrowserUtil.trace("grant executable privilege to " + unixBinary + " ok.");
            return true;
        }
        try {
            byte[] errContent = new byte[p.getErrorStream().available()];
            p.getErrorStream().read(errContent);
            WebBrowserUtil.trace("grant executable privilege to " + unixBinary + " failed with reason:" + errContent);
            return false;
        }
        catch (IOException ex) {
            WebBrowserUtil.error(ex.getMessage());
            ex.printStackTrace();
            throw new JdicInitException(ex.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new JdicInitException(e.getMessage());
        }
    }

    public String getEmbeddedBinaryName() {
        return this.browserBinName;
    }

    public void setEnginePath(String fullPath) {
        this.xpcomPathSetByUser = fullPath;
    }

    public String getCharsetName() {
        return "UTF-8";
    }

    public String getFileProtocolURLPrefix() {
        return "";
    }

    public boolean isInitialized() {
        return initialized;
    }

    public IWebBrowser getWebBrowser() {
        return new WebBrowser();
    }
}

