/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.DefaultLinkInterceptionHandler;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.ILinkInterceptionHandler;
import org.jdesktop.jdic.browser.IWebBrowser;
import org.jdesktop.jdic.browser.OpenLinkEvent;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;
import org.jdesktop.jdic.browser.internal.NativeEventThread;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;

public class WebBrowser
extends Canvas
implements IWebBrowser {
    private static final Logger logger = Logger.getLogger(WebBrowser.class);
    private static final String FILE_PROTOCOL = "file:///";
    private static final String FILE = "file";
    private static final String JAR = "jar";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String FTP = "ftp";
    private MyFocusListener focusListener = new MyFocusListener();
    private NativeEventThread eventThread;
    private Vector webBrowserListeners = new Vector();
    private int instanceNum;
    private static int lastInstanceNum = 0;
    private boolean isInitialized = false;
    private boolean isJSClose = false;
    private boolean isBackEnabled = false;
    private boolean isForwardEnabled = false;
    private boolean synchronize = false;
    private String initFailureMessage = "WebBrowser is not initialized.";
    private boolean autoDispose = true;
    private URL urlBeforeDispose = null;
    private ILinkInterceptionHandler linkHandler = new DefaultLinkInterceptionHandler();

    public void setInitialized(boolean b) {
        this.isInitialized = b;
    }

    public void setInitFailureMessage(String msg) {
        this.initFailureMessage = msg;
    }

    public WebBrowser() {
        this(true);
    }

    public WebBrowser(boolean autoDispose) {
        this(null, autoDispose);
    }

    public WebBrowser(URL url) {
        this(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBrowser(URL url, boolean autoDispose) {
        try {
            logger.info((Object)"init enventThread...");
            this.eventThread = NativeEventThread.getInstance();
            logger.info((Object)"finished enventThread...");
            logger.info((Object)this.eventThread);
        }
        catch (Exception e) {
            logger.info((Object)e);
            e.printStackTrace();
            return;
        }
        this.autoDispose = autoDispose;
        Class<WebBrowser> clazz = WebBrowser.class;
        synchronized (WebBrowser.class) {
            this.instanceNum = lastInstanceNum++;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            this.eventThread.attachWebBrowser(this);
            if (url != null) {
                this.setURL(url);
            }
            this.setFocusable(true);
            this.addFocusListener(this.focusListener);
            return;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isInitialized) {
            this.eventThread.fireNativeEvent(this.instanceNum, 1);
            if (this.urlBeforeDispose != null) {
                this.setURL(this.urlBeforeDispose);
                this.urlBeforeDispose = null;
            }
        }
        if (!this.autoDispose) {
            this.setVisible(true);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setVisible(true);
    }

    public void removeNotify() {
        if (this.autoDispose) {
            this.dispose();
        } else {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.isInitialized() && (!this.isJSClose || !WebBrowserUtil.IS_OS_LINUX && !WebBrowserUtil.IS_OS_SUNOS)) {
            this.urlBeforeDispose = this.getURL();
            WebBrowser webBrowser = this;
            synchronized (webBrowser) {
                this.eventThread.fireNativeEvent(this.instanceNum, 2);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.isJSClose) {
            this.isJSClose = false;
        }
        WebBrowser.super.removeNotify();
        this.setInitialized(false);
    }

    public boolean isAutoDispose() {
        return this.autoDispose;
    }

    public void setJSclose(boolean isJSClose) {
        this.isJSClose = isJSClose;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.eventThread == null) {
            logger.info((Object)"NativeThread is null...");
            JOptionPane.showMessageDialog(this, "NativeThread is null...");
        }
        this.eventThread.fireNativeEvent(this.instanceNum, 4, new Rectangle(x, y, width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchWebBrowserEvent(WebBrowserEvent e) {
        Vector tl;
        int size;
        Object data2;
        int eid = e.getID();
        WebBrowserUtil.trace("Dispatch event from NativeEventThread: " + eid);
        String msg = "@" + this.instanceNum + "," + eid + ",";
        if (3001 == eid) {
            msg = String.valueOf(msg) + (this.linkHandler.shouldOpenLink(new OpenLinkEvent(this, 1, e.getData())) ? "0" : "1");
            this.eventThread.getMessenger().sendMessage(msg);
            return;
        }
        if (3002 == eid) {
            msg = String.valueOf(msg) + (this.linkHandler.shouldOpenLink(new OpenLinkEvent(this, 2, e.getData())) ? "0" : "1");
            this.eventThread.getMessenger().sendMessage(msg);
            return;
        }
        if (3022 == eid) {
            String data2 = e.getData();
            if (data2.startsWith("forward")) {
                this.isForwardEnabled = data2.substring(8).equals("1");
                WebBrowserUtil.trace("Forward State changed = " + this.isForwardEnabled);
            } else if (data2.startsWith("back")) {
                this.isBackEnabled = data2.substring(5).equals("1");
                WebBrowserUtil.trace("Back State changed = " + this.isBackEnabled);
            }
            return;
        }
        if (3043 == eid) {
            WebBrowserUtil.trace("Got event from brower: Focus request.");
            this.requestFocus();
            return;
        }
        if (3044 == eid) {
            WebBrowserUtil.trace("Got event from brower: Destory window succeeds.");
            data2 = this;
            synchronized (data2) {
                this.notify();
            }
        } else if (3034 == eid && (data2 = e.getData()) != null) {
            int keyCode = 0;
            int modifer = 0;
            StringTokenizer tokenizer = new StringTokenizer((String)data2, " ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token == null) continue;
                if (token.startsWith("CtrlKeyDown=") && WebBrowser.isPressed("CtrlKeyDown=", token)) {
                    modifer = 2;
                    continue;
                }
                if (token.startsWith("AltKeyDown=") && WebBrowser.isPressed("AltKeyDown=", token)) {
                    modifer = 8;
                    continue;
                }
                if (token.startsWith("ShiftDown=") && WebBrowser.isPressed("ShiftDown=", token)) {
                    modifer = 1;
                    continue;
                }
                if (!token.startsWith("KeyCode=")) continue;
                keyCode = Integer.parseInt(token.replaceFirst("KeyCode=", ""));
            }
            WebBrowser.fireMenuKeyEvent(modifer, keyCode);
        }
        WebBrowser modifer = this;
        synchronized (modifer) {
            size = this.webBrowserListeners.size();
            if (size == 0) {
                return;
            }
            tl = (Vector)this.webBrowserListeners.clone();
        }
        int i = 0;
        while (i < size) {
            WebBrowserListener listener = (WebBrowserListener)tl.elementAt(i);
            switch (eid) {
                case 3042: {
                    listener.initializationCompleted(e);
                    break;
                }
                case 3003: {
                    listener.downloadStarted(e);
                    break;
                }
                case 3004: {
                    listener.downloadCompleted(e);
                    break;
                }
                case 3005: {
                    listener.downloadProgress(e);
                    break;
                }
                case 3006: {
                    listener.downloadError(e);
                    break;
                }
                case 3007: {
                    listener.documentCompleted(e);
                    break;
                }
                case 3023: {
                    listener.titleChange(e);
                    break;
                }
                case 3024: {
                    listener.statusTextChange(e);
                    break;
                }
                case 3037: {
                    this.isJSClose = true;
                    listener.windowClose(e);
                }
            }
            ++i;
        }
    }

    private static boolean isPressed(String keyEventMsg, String token) {
        return Integer.parseInt(token.replaceFirst(keyEventMsg, "")) == 1;
    }

    private static void fireMenuKeyEvent(int modifer, int keyCode) {
        WebBrowser webBrowser = new WebBrowser();
        KeyEvent ke = null;
        ke = new KeyEvent(webBrowser, 401, System.currentTimeMillis(), modifer, keyCode, '\u0000');
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.getSystemEventQueue().postEvent(ke);
    }

    public synchronized void addWebBrowserListener(WebBrowserListener listener) {
        if (!this.webBrowserListeners.contains(listener)) {
            this.webBrowserListeners.addElement(listener);
        }
    }

    public synchronized void removeWebBrowserListener(WebBrowserListener listener) {
        if (listener == null) {
            return;
        }
        this.webBrowserListeners.removeElement(listener);
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return this.webBrowserListeners.toArray(new WebBrowserListener[0]);
    }

    public URL getURL() {
        this.eventThread.fireNativeEvent(this.instanceNum, 12);
        if (this.waitForResult()) {
            try {
                return new URL(this.eventThread.getEventRetString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setURL() {
        this.eventThread.fireNativeEvent(this.instanceNum, 5, "about:blank");
    }

    public void setURL(URL url) {
        this.setURL(url, null);
    }

    public void setURL(URL url, String postData) {
        this.setURL(url, postData, null);
    }

    public void setURL(URL url, String postData, String headers) {
        if (url == null) {
            return;
        }
        String urlString = url.toString();
        if (url.getProtocol().equals(FILE)) {
            String fileName = url.getFile();
            if (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            File file = new File(fileName);
            try {
                String filePath = file.getCanonicalFile().getAbsolutePath();
                urlString = FILE_PROTOCOL + filePath;
            }
            catch (IOException e) {
                WebBrowserUtil.error(e.getMessage());
                e.printStackTrace();
            }
        }
        if (!WebBrowser.isNativeSafe(url) && url.getProtocol().equals(JAR)) {
            try {
                urlString = WebBrowser.toFileUrl(url).toString();
            }
            catch (IOException e) {
                WebBrowserUtil.error(e.getMessage());
                e.printStackTrace();
            }
        }
        if (postData == null && headers == null) {
            this.eventThread.fireNativeEvent(this.instanceNum, 5, urlString);
        } else {
            this.eventThread.fireNativeEvent(this.instanceNum, 6, String.valueOf(urlString) + this.instanceNum + "," + 6 + "," + (postData == null ? "" : postData) + this.instanceNum + "," + 6 + "," + (headers == null ? "" : headers));
        }
    }

    private static boolean isNativeSafe(URL location) {
        String protocol = location.getProtocol().intern();
        return protocol.equals(HTTP) || protocol.equals(HTTPS) || protocol.equals(FILE) || protocol.equals(FTP);
    }

    public static URL toFileUrl(URL location) throws IOException {
        File copiedFile = null;
        JarURLConnection juc = (JarURLConnection)location.openConnection();
        String toAccessEntryFullName = juc.getEntryName();
        String runningTmpPath = System.getProperty("java.io.tmpdir");
        WebBrowserUtil.trace("using system tmp path " + runningTmpPath);
        File sysTempDir = new File(runningTmpPath);
        File tempJarDir = new File(String.valueOf(sysTempDir.getCanonicalFile().getAbsolutePath()) + File.separator + "jartemp");
        if (!WebBrowserUtil.IS_OS_WINDOWS) {
            Runtime.getRuntime().exec("chmod a+wr " + sysTempDir);
        }
        if (!tempJarDir.exists()) {
            WebBrowserUtil.trace(String.valueOf(tempJarDir.getAbsolutePath()) + " doesn't exist.");
            tempJarDir.mkdirs();
            WebBrowserUtil.trace(String.valueOf(tempJarDir.getAbsolutePath()) + " is created.");
        }
        JarFile jarFile = juc.getJarFile();
        Enumeration<JarEntry> en = jarFile.entries();
        while (en.hasMoreElements()) {
            String entryPath;
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory() || !(entryPath = entry.getName()).equals(toAccessEntryFullName)) continue;
            copiedFile = new File(tempJarDir, entryPath);
            copiedFile.getParentFile().mkdirs();
            InputStream is = jarFile.getInputStream(entry);
            FileOutputStream os = new FileOutputStream(copiedFile);
            WebBrowserUtil.copyIsToOs(is, os);
        }
        WebBrowserUtil.trace("realFile.getAbsolutePath=" + copiedFile.getAbsolutePath());
        WebBrowserUtil.trace("realFile.toURL=" + copiedFile.toURI().toURL());
        return copiedFile.toURI().toURL();
    }

    public void syncSetURL(URL url) throws JdicInitException {
        this.syncSetURL(url, null, null);
    }

    public void syncSetURL(URL url, String postData) throws JdicInitException {
        this.syncSetURL(url, postData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncSetURL(URL url, String postData, String headers) throws JdicInitException {
        try {
            this.synchronize = true;
            if (!this.isInitialized) {
                WebBrowserUtil.error("You can't call this method before WebBrowser is initialized!");
                throw new JdicInitException("You can't call this method before WebBrowser is initialized!");
            }
            this.setURL(url, postData, headers);
            WebBrowser webBrowser = this;
            synchronized (webBrowser) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            }
        }
        finally {
            this.synchronize = false;
        }
    }

    public void back() {
        this.eventThread.fireNativeEvent(this.instanceNum, 8);
    }

    public void forward() {
        this.eventThread.fireNativeEvent(this.instanceNum, 9);
    }

    public void refresh() {
        this.eventThread.fireNativeEvent(this.instanceNum, 10);
    }

    public void stop() {
        this.eventThread.fireNativeEvent(this.instanceNum, 11);
    }

    public void shutdown() {
        this.eventThread.fireNativeEvent(this.instanceNum, 3);
    }

    public void print() {
        this.executeScript("window.print();");
    }

    public void setContent(String htmlContent) {
        this.eventThread.fireNativeEvent(this.instanceNum, 16, htmlContent);
    }

    public String getContent() {
        this.eventThread.fireNativeEvent(this.instanceNum, 15);
        if (this.waitForResult()) {
            try {
                return this.eventThread.getEventRetString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String executeScript(String javaScript) {
        this.eventThread.fireNativeEvent(this.instanceNum, 17, javaScript);
        if (this.waitForResult()) {
            try {
                return this.eventThread.getEventRetString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setDebug(boolean b) {
        WebBrowserUtil.enableDebugMessages(b);
    }

    public static String getBrowserBinary() {
        return BrowserEngineManager.instance().getActiveEngine().getEmbeddedBinaryName();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isBackEnabled() {
        return this.isBackEnabled;
    }

    public boolean isForwardEnabled() {
        return this.isForwardEnabled;
    }

    public int getInstanceNum() {
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResult() {
        if (!this.isInitialized) {
            WebBrowserUtil.trace("You can't call this method before WebBrowser is initialized!");
            return false;
        }
        boolean ret = false;
        WebBrowser webBrowser = this;
        synchronized (webBrowser) {
            try {
                this.wait();
                ret = true;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return ret;
    }

    public int getNativeWindow() {
        return this.nativeGetWindow(System.getProperty("java.home"));
    }

    private native int nativeGetWindow(String var1);

    public Component asComponent() {
        return this;
    }

    public IBrowserEngine getBrowserEngine() {
        return BrowserEngineManager.instance().getActiveEngine();
    }

    public String getInitFailureMessage() {
        return this.initFailureMessage;
    }

    public boolean isSynchronize() {
        return this.synchronize;
    }

    public void setLinkInterceptionHandler(ILinkInterceptionHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null");
        }
        this.linkHandler = handler;
    }

    public void setAutoDispose(boolean autoDispose) {
        this.autoDispose = autoDispose;
    }

    class MyFocusListener
    implements FocusListener {
        MyFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            WebBrowserUtil.trace("\nMyFocusListener: focusGained\n");
            WebBrowser.this.eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 13);
        }

        public void focusLost(FocusEvent e) {
            WebBrowserUtil.trace("\nMyFocusListener: focusLost\n");
            WebBrowser.this.eventThread.fireNativeEvent(WebBrowser.this.instanceNum, 14);
        }
    }
}

