/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

public class WinAPIWrapper {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int ERROR_SUCCESS = 0;
    public static final int MAX_KEY_LENGTH = 255;
    private static final int OPENED_KEY_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    private static final int SUBKEYS_NUMBER = 0;
    public static final int KEY_READ = 131097;

    static {
        System.loadLibrary("jdic");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WinAPIWrapper.shutDown();
            }
        });
    }

    private static native int[] RegOpenKey(int var0, byte[] var1, int var2);

    private static native int RegCloseKey(int var0);

    private static native byte[] RegQueryValueEx(int var0, byte[] var1);

    private static native byte[] AssocQueryString(byte[] var0, byte[] var1);

    private static native byte[] ExpandEnvironmentStrings(byte[] var0);

    private static native String resolveLinkFile(byte[] var0);

    private static native int shellExecute(byte[] var0, byte[] var1);

    private static synchronized native void openMapiMailer(String[] var0, String[] var1, String[] var2, String var3, String var4, String[] var5);

    protected static native void shutDown();

    private static native boolean nativeBrowseURLInIE(String var0, String var1);

    private static byte[] stringToByteArray(String str) {
        if (str == null) {
            return null;
        }
        byte[] srcByte = str.getBytes();
        int srcLength = srcByte.length;
        byte[] result = new byte[srcLength + 1];
        System.arraycopy(srcByte, 0, result, 0, srcLength);
        result[srcLength] = 0;
        return result;
    }

    private static String byteArrayToString(byte[] array) {
        String temString;
        if (array != null && (temString = new String(array)) != null) {
            return temString.substring(0, temString.length() - 1);
        }
        return null;
    }

    private WinAPIWrapper() {
    }

    public static String WinRegQueryValueEx(int hKey, String subKey, String valueName) {
        byte[] lpSubKey = WinAPIWrapper.stringToByteArray(subKey);
        int[] openResult = WinAPIWrapper.RegOpenKey(hKey, lpSubKey, 131097);
        if (openResult == null) {
            return null;
        }
        if (openResult[1] != 0) {
            return null;
        }
        byte[] lpValueName = WinAPIWrapper.stringToByteArray(valueName);
        byte[] valueBytes = WinAPIWrapper.RegQueryValueEx(openResult[0], lpValueName);
        WinAPIWrapper.RegCloseKey(openResult[0]);
        if (valueBytes != null) {
            if (valueBytes.length == 1 && valueBytes[0] == 0 && valueName.equals("")) {
                return null;
            }
            return WinAPIWrapper.byteArrayToString(valueBytes);
        }
        return null;
    }

    public static String WinAssocQueryString(String fileOrProtocal, String verb) {
        byte[] verbBytes;
        byte[] fileOrProtocalBytes = WinAPIWrapper.stringToByteArray(fileOrProtocal);
        byte[] queryResult = WinAPIWrapper.AssocQueryString(fileOrProtocalBytes, verbBytes = WinAPIWrapper.stringToByteArray(verb));
        if (queryResult != null) {
            if (queryResult.length == 1 && queryResult[0] == 0 && queryResult.equals("")) {
                return null;
            }
            return WinAPIWrapper.byteArrayToString(queryResult);
        }
        return null;
    }

    public static String WinResolveLinkFile(String filePath) {
        byte[] filePathBytes = WinAPIWrapper.stringToByteArray(filePath);
        return WinAPIWrapper.resolveLinkFile(filePathBytes);
    }

    public static boolean WinShellExecute(String filePath, String verb) {
        byte[] verbBytes;
        byte[] filePathBytes = WinAPIWrapper.stringToByteArray(filePath);
        int exeResult = WinAPIWrapper.shellExecute(filePathBytes, verbBytes = WinAPIWrapper.stringToByteArray(verb));
        return exeResult > 32;
    }

    public static boolean WinBrowseURLInIE(String urlStr, String target) {
        return WinAPIWrapper.nativeBrowseURLInIE(urlStr, target);
    }

    public static synchronized void WinOpenMapiMailer(String[] toArray, String[] ccArray, String[] bccArray, String subject, String body, String[] attachArray) {
        WinAPIWrapper.openMapiMailer(toArray, ccArray, bccArray, subject, body, attachArray);
    }
}

