/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.IOException;
import java.util.Iterator;
import org.jdesktop.jdic.desktop.Message;
import org.jdesktop.jdic.desktop.internal.LaunchFailedException;
import org.jdesktop.jdic.desktop.internal.MailerService;
import org.jdesktop.jdic.desktop.internal.impl.URLUTF8Encoder;

public class WinMozMailer
implements MailerService {
    private String mozLocation;

    public WinMozMailer() {
        this.mozLocation = "C:\\Program Files\\mozilla.org\\Mozilla\\mozilla.exe";
    }

    public WinMozMailer(String location) {
        this.mozLocation = location;
    }

    public void open(Message msg) throws LaunchFailedException {
        String[] cmdArray = new String[]{this.mozLocation, "-compose", this.constructArgs(msg.getToAddrs(), msg.getCcAddrs(), msg.getBccAddrs(), msg.getSubject(), msg.getBody(), msg.getAttachments())};
        try {
            Runtime.getRuntime().exec(cmdArray);
        }
        catch (IOException e) {
            throw new LaunchFailedException("Cannot launch Mozilla composer via -compose commandline:" + e.getMessage());
        }
    }

    public void open() throws LaunchFailedException {
        String[] cmdArray = new String[]{this.mozLocation, "-compose"};
        try {
            Runtime.getRuntime().exec(cmdArray);
        }
        catch (IOException e) {
            throw new LaunchFailedException("Cannot launch Mozilla composer via -compose commandline:" + e.getMessage());
        }
    }

    private String constructArgs(Iterator to, Iterator cc, Iterator bcc, String subject, String body, Iterator attach) {
        String argString = "";
        String tmp = "";
        if (to != null) {
            while (to.hasNext()) {
                tmp = String.valueOf(tmp) + (String)to.next() + ",";
            }
            argString = "to='" + tmp + "',";
        }
        if (cc != null) {
            tmp = "";
            while (cc.hasNext()) {
                tmp = String.valueOf(tmp) + (String)cc.next() + ",";
            }
            argString = String.valueOf(argString) + "cc='" + tmp + "',";
        }
        if (bcc != null) {
            tmp = "";
            while (bcc.hasNext()) {
                tmp = String.valueOf(tmp) + (String)bcc.next() + ",";
            }
            argString = String.valueOf(argString) + "bcc='" + tmp + "',";
        }
        if (subject != null) {
            argString = String.valueOf(argString) + "subject=" + this.parseSubject(URLUTF8Encoder.encode(subject)) + ",";
        }
        if (body != null) {
            argString = String.valueOf(argString) + "body=<body>" + this.parseBody(URLUTF8Encoder.encode(body)) + "</body>,";
        }
        if (attach != null) {
            tmp = "";
            while (attach.hasNext()) {
                tmp = String.valueOf(tmp) + "file://" + (String)attach.next() + ",";
            }
            argString = String.valueOf(argString) + "attachment='" + tmp + "'";
        }
        return argString;
    }

    private String parseSubject(String inString) {
        String tmp = inString;
        tmp = tmp.replaceAll("%0a", "%20");
        return tmp;
    }

    private String parseBody(String inString) {
        String tmp = inString;
        tmp = tmp.replaceAll("%3c", "&#60");
        tmp = tmp.replaceAll("%3e", "&#62");
        tmp = tmp.replaceAll("%0a", "<br>");
        return tmp;
    }
}

