/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.JdicInitException;

public class JdicManager {
    private boolean isShareNativeInitialized = false;
    String jdicNativeLibPath = null;
    private static JdicManager sSingleton = null;

    private JdicManager() {
    }

    public static synchronized JdicManager getManager() {
        if (sSingleton == null) {
            sSingleton = new JdicManager();
        }
        return sSingleton;
    }

    public void initShareNative() throws JdicInitException {
        WebBrowserUtil.trace("init share native..... ");
        if (this.isShareNativeInitialized) {
            return;
        }
        try {
            String jwsVersion = System.getProperty("javawebstart.version");
            if (jwsVersion != null) {
                WebBrowserUtil.trace("Loaded by JavaWebStart,version is " + jwsVersion);
                this.jdicNativeLibPath = this.caculateNativeLibPathBySunJWS();
                return;
            }
            WebBrowserUtil.trace("jar path......");
            String eas_path = String.valueOf(System.getProperty("EAS_HOME")) + "/client/deploy/client";
            WebBrowserUtil.trace(eas_path);
            WebBrowserUtil.trace("current runnning path " + eas_path);
            this.jdicNativeLibPath = eas_path;
            String JAVA_LIBRARY_PATH = String.valueOf(this.jdicNativeLibPath) + File.pathSeparator + System.getProperty("java.library.path");
            System.setProperty("java.library.path", JAVA_LIBRARY_PATH);
            try {
                Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                fieldSysPath.setAccessible(true);
                if (fieldSysPath != null) {
                    fieldSysPath.set(System.class.getClassLoader(), null);
                }
            }
            catch (NoSuchFieldException nfe) {
                WebBrowserUtil.trace("Current classloader doesn't have sys_paths field.\n" + nfe.getMessage());
            }
        }
        catch (Throwable e) {
            throw new JdicInitException(e);
        }
        this.isShareNativeInitialized = true;
    }

    private String dealExtensionMode(String jdicJarPath) {
        WebBrowserUtil.trace("check if loaded in extension mode");
        String jdic_native_jar = String.valueOf(jdicJarPath) + "/" + "jdic_native.jar";
        String jdic_cross_platform_jar = String.valueOf(jdicJarPath) + "/" + "jdic_crossplatform.jar";
        if (this.extractJarFile(jdic_cross_platform_jar, String.valueOf(jdicJarPath) + "/jdic_crossplatform")) {
            WebBrowserUtil.trace("loaded in extension mode with cross platform format");
            return String.valueOf(jdicJarPath) + "/jdic_crossplatform";
        }
        if (this.extractJarFile(jdic_native_jar, String.valueOf(jdicJarPath) + "/jdic_native")) {
            WebBrowserUtil.trace("loaded in extension mode with os specific format");
            return String.valueOf(jdicJarPath) + "/jdic_native";
        }
        WebBrowserUtil.trace("Not loaded in extension mode");
        return jdicJarPath;
    }

    private boolean extractJarFile(String jarPath, String jdicJarPath) {
        WebBrowserUtil.trace(" jar path to verify" + jarPath);
        if (new File(jarPath).exists()) {
            try {
                JarFile jarfile = new JarFile(jarPath);
                Enumeration<JarEntry> jarEntries = jarfile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    if (jarEntry.isDirectory()) continue;
                    String jarFileName = jarEntry.getName();
                    WebBrowserUtil.trace(" dealing with " + jarFileName);
                    File copyFile = new File(jdicJarPath, jarFileName);
                    if (copyFile.exists()) continue;
                    if (!copyFile.getParentFile().exists()) {
                        copyFile.getParentFile().mkdirs();
                    }
                    InputStream is = jarfile.getInputStream(jarEntry);
                    FileOutputStream os = new FileOutputStream(copyFile);
                    WebBrowserUtil.copyIsToOs(is, os);
                }
            }
            catch (Exception e) {
                WebBrowserUtil.error(e.getMessage());
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private String dealCrossPlatformVersion(String jdicJarPath) throws MalformedURLException, JdicInitException {
        String platformPath = String.valueOf(jdicJarPath) + File.separator + JdicManager.getPlatform();
        File jdicStubJarFile = new File(String.valueOf(platformPath) + File.separator + "jdic_stub.jar");
        if (!jdicStubJarFile.exists()) {
            return jdicJarPath;
        }
        String architecturePath = String.valueOf(platformPath) + File.separator + JdicManager.getArchitecture();
        ClassLoader cl = this.getClass().getClassLoader();
        if (!(cl instanceof URLClassLoader)) {
            String exceptionInfo = "We detect that you are not using java.net.URLClassLoader for cross platform versoin,you have to set jdic_stub.jar manually if JDIC can't work!";
            WebBrowserUtil.error(exceptionInfo);
            return architecturePath;
        }
        URLClassLoader urlCl = (URLClassLoader)cl;
        try {
            Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURLMethod.setAccessible(true);
            addURLMethod.invoke((Object)urlCl, jdicStubJarFile.toURL());
            return architecturePath;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new JdicInitException("Error, could not add URL to system classloader");
        }
    }

    public String getBinaryPath() {
        return this.jdicNativeLibPath;
    }

    private String caculateNativeLibPathBySunJWS() throws IOException, JdicInitException {
        String jdicLibFolder = null;
        ClassLoader cl = this.getClass().getClassLoader();
        WebBrowserUtil.trace("current class loader " + cl.getClass().getName());
        try {
            Class<?> jnlpClassLoaderClass = Class.forName("com.sun.jnlp.JNLPClassLoader");
            if (!cl.getClass().isAssignableFrom(jnlpClassLoaderClass)) {
                throw new JdicInitException("Unexpected ClassLoader for webstart, only Sun's com.sun.jnlp.JNLPClassLoader is supported,while current classloader is " + cl.getClass().getName());
            }
            Method findLibMethod = jnlpClassLoaderClass.getDeclaredMethod("findLibrary", String.class);
            findLibMethod.setAccessible(true);
            String jdicLibURL = (String)findLibMethod.invoke((Object)cl, "jdic");
            jdicLibFolder = new File(jdicLibURL).getParentFile().getCanonicalPath();
            WebBrowserUtil.trace("running path " + this.jdicNativeLibPath);
            this.isShareNativeInitialized = true;
        }
        catch (Exception e) {
            WebBrowserUtil.error(e.getMessage());
            e.printStackTrace();
            throw new JdicInitException(e.getMessage());
        }
        return jdicLibFolder;
    }

    private static String getPlatform() {
        String osname = System.getProperty("os.name");
        if (WebBrowserUtil.IS_OS_WINDOWS) {
            return "windows";
        }
        if (WebBrowserUtil.IS_OS_MAC) {
            return "mac";
        }
        return JdicManager.canonical(osname);
    }

    private static String getArchitecture() {
        String arch = System.getProperty("os.arch");
        if (WebBrowserUtil.IS_OS_MAC && arch.endsWith("86")) {
            return "ppc";
        }
        if (arch.endsWith("86")) {
            return "x86";
        }
        return JdicManager.canonical(arch);
    }

    private static String canonical(String value) {
        WebBrowserUtil.trace("value:" + value);
        WebBrowserUtil.trace("canonical:" + value.toLowerCase().replaceAll("[\\\\/ ]", "_"));
        return value.toLowerCase().replaceAll("[\\\\/ ]", "_");
    }
}

