/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.tray;

import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.jdesktop.jdic.tray.internal.ServiceManager;
import org.jdesktop.jdic.tray.internal.TrayIconService;

public class TrayIcon {
    TrayIconService tis = (TrayIconService)ServiceManager.getService("TrayIconService");
    public static final int INFO_MESSAGE_TYPE = 0;
    public static final int ERROR_MESSAGE_TYPE = 1;
    public static final int WARNING_MESSAGE_TYPE = 2;
    public static final int NONE_MESSAGE_TYPE = 3;

    public TrayIcon(Icon i) {
        this(i, null, null);
    }

    public TrayIcon(Icon icon, String caption) {
        this(icon, caption, null);
    }

    public TrayIcon(Icon icon, String tooltip, JPopupMenu popup) {
        this.setIcon(icon);
        this.setToolTip(tooltip);
        this.setPopupMenu(popup);
    }

    public void setIcon(Icon icon) {
        if (this.tis != null) {
            this.tis.setIcon(icon);
        }
    }

    public void setPopupMenu(JPopupMenu popup) {
        if (this.tis != null) {
            this.tis.setPopupMenu(popup);
        }
    }

    public void setToolTip(String tooltip) {
        if (this.tis != null) {
            this.tis.setToolTip(tooltip);
        }
    }

    public void addActionListener(ActionListener listener) {
        if (this.tis != null) {
            this.tis.addActionListener(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (this.tis != null) {
            this.tis.removeActionListener(listener);
        }
    }

    public void setCaption(String caption) {
        if (this.tis != null) {
            this.tis.setCaption(caption);
        }
    }

    public void setIconAutoSize(boolean autosize) {
        if (this.tis != null) {
            this.tis.setIconAutoSize(autosize);
        }
    }

    TrayIconService getTrayIconService() {
        return this.tis;
    }

    public Point getLocationOnScreen() {
        Point p = null;
        if (this.tis != null) {
            p = this.tis.getLocationOnScreen();
        }
        return p;
    }

    public void displayMessage(String caption, String text, int type) throws NullPointerException {
        if (caption == null && text == null) {
            throw new NullPointerException("Both caption and text are null.");
        }
        if (this.tis != null) {
            this.tis.showBalloonMessage(caption, text, type);
        }
    }

    public void addBalloonActionListener(ActionListener listener) {
        if (this.tis != null) {
            this.tis.addBalloonActionListener(listener);
        }
    }

    public void removeBalloonActionListener(ActionListener listener) {
        if (this.tis != null) {
            this.tis.removeBalloonActionListener(listener);
        }
    }
}

