/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jdesktop.swing.calendar.DateSpan;
import org.jdesktop.swing.calendar.DateUtils;
import org.jdesktop.swing.calendar.JXDatePickerFormatterFactory;
import org.jdesktop.swing.calendar.JXMonthView;

public class JXDatePicker
extends JComponent {
    protected JFormattedTextField _dateField = new JFormattedTextField(new JXDatePickerFormatterFactory());
    protected JXDatePickerPopup _popup;
    private JButton _popupButton;
    private int _popupButtonWidth = 20;
    private JXMonthView _monthView;
    private Handler _handler;
    private String _actionCommand = "selectionChanged";
    static /* synthetic */ Class class$0;

    public JXDatePicker() {
        this(System.currentTimeMillis());
    }

    public JXDatePicker(long millis) {
        this._dateField.setName("dateField");
        this._dateField.setBorder(null);
        this._handler = new Handler();
        this._popupButton = new JButton();
        this._popupButton.setName("popupButton");
        this._popupButton.setRolloverEnabled(false);
        this._popupButton.addMouseListener(this._handler);
        this._popupButton.addMouseMotionListener(this._handler);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, false);
        InputMap inputMap = this._dateField.getInputMap(0);
        inputMap.put(enterKey, "COMMIT_EDIT");
        ActionMap actionMap = this._dateField.getActionMap();
        actionMap.put("COMMIT_EDIT", new CommitEditAction());
        KeyStroke spaceKey = KeyStroke.getKeyStroke(32, 0, false);
        inputMap = this._popupButton.getInputMap(0);
        inputMap.put(spaceKey, "TOGGLE_POPUP");
        actionMap = this._popupButton.getActionMap();
        actionMap.put("TOGGLE_POPUP", new TogglePopupAction());
        this.add(this._dateField);
        this.add(this._popupButton);
        this.updateUI();
        this._dateField.setValue(new Date(millis));
    }

    public void updateUI() {
        int cols = UIManager.getInt("JXDatePicker.numColumns");
        if (cols == -1) {
            cols = 10;
        }
        this._dateField.setColumns(cols);
        String str = UIManager.getString("JXDatePicker.arrowDown.tooltip");
        if (str == null) {
            str = "Show Calendar";
        }
        this._popupButton.setToolTipText(str);
        Icon icon = UIManager.getIcon("JXDatePicker.arrowDown.image");
        if (icon == null) {
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down24.gif"));
        }
        this._popupButton.setIcon(icon);
        Border border = UIManager.getBorder("JXDatePicker.border");
        if (border == null) {
            border = BorderFactory.createCompoundBorder(LineBorder.createGrayLineBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
        this._dateField.setBorder(border);
    }

    public void setDate(Date date) {
        this._dateField.setValue(date);
    }

    public void setDateInMillis(long millis) {
        this._dateField.setValue(new Date(millis));
    }

    public Date getDate() {
        return (Date)this._dateField.getValue();
    }

    public long getDateInMillis() {
        return ((Date)this._dateField.getValue()).getTime();
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    public JFormattedTextField.AbstractFormatterFactory getDateFormatterFactory() {
        return this._dateField.getFormatterFactory();
    }

    public void setDateFormatterFactory(JFormattedTextField.AbstractFormatterFactory dateFormatterFactory) {
        this._dateField.setFormatterFactory(dateFormatterFactory);
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
    }

    public void setEnabled(boolean value) {
        if (this.isEnabled() == value) {
            return;
        }
        super.setEnabled(value);
        this._dateField.setEnabled(value);
        this._popupButton.setEnabled(value);
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this._actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new ActionEvent(this, 1001, this._actionCommand);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        this._dateField.setBounds(insets.left, insets.bottom, width - this._popupButtonWidth, height);
        this._popupButton.setBounds(width - this._popupButtonWidth + insets.left, insets.bottom, this._popupButtonWidth, height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dim = this._dateField.getPreferredSize();
        dim.width += this._popupButton.getPreferredSize().width;
        Insets insets = this.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        public void actionPerformed(ActionEvent ev) {
            JXDatePicker.this._handler.toggleShowPopup();
        }
    }

    private class CommitEditAction
    extends AbstractAction {
        public CommitEditAction() {
            super("CommitEditPopup");
        }

        public void actionPerformed(ActionEvent ev) {
            try {
                JXDatePicker.this._dateField.commitEdit();
                JXDatePicker.this._dateField.setValue(JXDatePicker.this._dateField.getValue());
                JXDatePicker.this.fireActionPerformed();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener {
        private boolean _forwardReleaseEvent = false;

        private Handler() {
        }

        public void mouseClicked(MouseEvent ev) {
        }

        public void mousePressed(MouseEvent ev) {
            if (!JXDatePicker.this.isEnabled()) {
                return;
            }
            if (JXDatePicker.this._dateField.isEditValid()) {
                try {
                    JXDatePicker.this._dateField.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.toggleShowPopup();
        }

        public void mouseReleased(MouseEvent ev) {
            if (this._forwardReleaseEvent) {
                ev = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, ev, JXDatePicker.this._monthView);
                JXDatePicker.this._monthView.dispatchEvent(ev);
                this._forwardReleaseEvent = false;
            }
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent ev) {
        }

        public void mouseDragged(MouseEvent ev) {
            this._forwardReleaseEvent = true;
            if (!JXDatePicker.this._popup.isShowing()) {
                return;
            }
            ev = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, ev, JXDatePicker.this._monthView);
            JXDatePicker.this._monthView.dispatchEvent(ev);
        }

        public void mouseMoved(MouseEvent ev) {
        }

        public void toggleShowPopup() {
            if (JXDatePicker.this._popup == null) {
                JXDatePicker.this._popup = new JXDatePickerPopup();
            }
            if (!JXDatePicker.this._popup.isVisible()) {
                if (JXDatePicker.this._dateField.getValue() == null) {
                    JXDatePicker.this._dateField.setValue(new Date(System.currentTimeMillis()));
                }
                DateSpan span = new DateSpan((Date)JXDatePicker.this._dateField.getValue(), (Date)JXDatePicker.this._dateField.getValue());
                JXDatePicker.this._monthView.setSelectedDateSpan(span);
                JXDatePicker.this._monthView.ensureDateVisible(((Date)JXDatePicker.this._dateField.getValue()).getTime());
                Point loc = JXDatePicker.this._dateField.getLocationOnScreen();
                JXDatePicker.this._popup.show(JXDatePicker.this, 0, JXDatePicker.this.getHeight());
            } else {
                JXDatePicker.this._popup.setVisible(false);
            }
        }
    }

    private class JXDatePickerPopup
    extends JPopupMenu
    implements ActionListener {
        private JButton _nextButton;
        private JButton _previousButton;
        private JButton _todayButton;

        public JXDatePickerPopup() {
            JXDatePicker.this._monthView = new JXMonthView();
            JXDatePicker.this._monthView.setActionCommand("MONTH_VIEW");
            JXDatePicker.this._monthView.addActionListener(this);
            JPanel panel = new JPanel(new FlowLayout());
            Icon icon = UIManager.getIcon("JXMonthView.monthUp.image");
            if (icon == null) {
                icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up24.gif"));
            }
            this._previousButton = new JButton(icon);
            this._previousButton.setActionCommand("PREVIOUS_MONTH");
            this._previousButton.addActionListener(this);
            icon = UIManager.getIcon("JXMonthView.monthDown.image");
            if (icon == null) {
                icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down24.gif"));
            }
            this._nextButton = new JButton(icon);
            this._nextButton.setActionCommand("NEXT_MONTH");
            this._nextButton.addActionListener(this);
            icon = UIManager.getIcon("JXMonthView.monthCurrent.image");
            if (icon == null) {
                icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Stop24.gif"));
            }
            this._todayButton = new JButton(icon);
            this._todayButton.setActionCommand("TODAY");
            this._todayButton.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)JXDatePicker.this._monthView, "Center");
            panel.add(this._previousButton);
            panel.add(this._todayButton);
            panel.add(this._nextButton);
            this.add((Component)panel, "North");
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if ("MONTH_VIEW" == command) {
                DateSpan span = JXDatePicker.this._monthView.getSelectedDateSpan();
                JXDatePicker.this._dateField.setValue(span.getStartAsDate());
                JXDatePicker.this._popup.setVisible(false);
                JXDatePicker.this.fireActionPerformed();
            } else if ("PREVIOUS_MONTH" == command) {
                JXDatePicker.this._monthView.setFirstDisplayedDate(DateUtils.getPreviousMonth(JXDatePicker.this._monthView.getFirstDisplayedDate()));
            } else if ("NEXT_MONTH" == command) {
                JXDatePicker.this._monthView.setFirstDisplayedDate(DateUtils.getNextMonth(JXDatePicker.this._monthView.getFirstDisplayedDate()));
            } else if ("TODAY" == command) {
                DateSpan span = new DateSpan(System.currentTimeMillis(), System.currentTimeMillis());
                JXDatePicker.this._monthView.ensureDateVisible(span.getStart());
            }
        }
    }
}

