/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JXImagePanel
extends JPanel {
    private JLabel imageLabel;
    private String TEXT = "<html><i><b>Click on the pane<br>To set the image</b></i></html>";

    public JXImagePanel() {
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.imageLabel = new JLabel(this.TEXT);
        this.imageLabel.setPreferredSize(new Dimension(200, 200));
        this.imageLabel.addMouseListener(new MouseHandler());
        this.imageLabel.setToolTipText(this.TEXT);
        this.add(this.imageLabel);
    }

    public void setIcon(Icon icon) {
        this.imageLabel.setIcon(icon);
        if (icon != null) {
            this.imageLabel.setText(null);
        } else {
            this.imageLabel.setText(this.TEXT);
        }
    }

    public Icon getIcon() {
        return this.imageLabel.getIcon();
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setIcon(new ImageIcon(image));
        } else {
            this.setIcon(null);
        }
    }

    public Image getImage() {
        ImageIcon icon = (ImageIcon)this.imageLabel.getIcon();
        if (icon != null) {
            return icon.getImage();
        }
        return null;
    }

    private class MouseHandler
    extends MouseAdapter {
        private Cursor oldCursor;
        private JFileChooser chooser;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int retVal;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            if ((retVal = this.chooser.showOpenDialog(JXImagePanel.this)) == 0) {
                File file = this.chooser.getSelectedFile();
                try {
                    JXImagePanel.this.setIcon(new ImageIcon(file.toURL()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mouseEntered(MouseEvent evt) {
            JLabel label = (JLabel)evt.getSource();
            if (this.oldCursor == null) {
                this.oldCursor = label.getCursor();
                label.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseExited(MouseEvent evt) {
            JLabel label = (JLabel)evt.getSource();
            if (this.oldCursor != null) {
                label.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }
    }
}

