/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JXRadioGroup
extends JPanel {
    private ButtonGroup buttonGroup;
    private ArrayList values = new ArrayList();
    private ActionListener actionHandler;
    private ArrayList actionListeners;

    public JXRadioGroup() {
        this.setLayout(new BoxLayout(this, 0));
        this.buttonGroup = new ButtonGroup();
    }

    public JXRadioGroup(Object[] radioValues) {
        this();
        int i = 0;
        while (i < radioValues.length) {
            this.add(radioValues[i]);
            ++i;
        }
    }

    public void add(Object radioValue) {
        this.values.add(radioValue);
        this.addButton(new JRadioButton(radioValue.toString()));
    }

    public void add(AbstractButton button) {
        this.values.add(button.getText());
        this.addButton(button);
    }

    private void addButton(AbstractButton button) {
        this.buttonGroup.add(button);
        super.add(button);
        if (this.actionHandler == null) {
            this.actionHandler = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JXRadioGroup.this.fireActionEvent(e);
                }
            };
        }
        button.addActionListener(this.actionHandler);
    }

    public AbstractButton getSelectedButton() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        Component[] children = this.getComponents();
        int i = 0;
        while (i < children.length) {
            AbstractButton button = (AbstractButton)children[i];
            if (button.getModel() == selectedModel) {
                return button;
            }
            ++i;
        }
        return null;
    }

    private int getSelectedIndex() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        Component[] children = this.getComponents();
        int i = 0;
        while (i < children.length) {
            AbstractButton button = (AbstractButton)children[i];
            if (button.getModel() == selectedModel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getSelectedValue() {
        int index = this.getSelectedIndex();
        return this.values.get(index);
    }

    public void setSelectedValue(Object value) {
        int index = this.values.indexOf(value);
        AbstractButton button = (AbstractButton)this.getComponent(index);
        button.setSelected(true);
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList();
        }
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(l);
        }
    }

    public ActionListener[] getActionListeners() {
        if (this.actionListeners != null) {
            return this.actionListeners.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    protected void fireActionEvent(ActionEvent e) {
        if (this.actionListeners != null) {
            int i = 0;
            while (i < this.actionListeners.size()) {
                ActionListener l = (ActionListener)this.actionListeners.get(i);
                l.actionPerformed(e);
                ++i;
            }
        }
    }
}

