/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.TableCellRenderer;

public class LabelProperties
extends JLabel {
    private static final int BACKGROUND_SET = 1;
    private static final int FOREGROUND_SET = 2;
    private static final int FONT_SET = 4;
    private static final int HORIZONTAL_ALIGNMENT_SET = 8;
    private static final int HORIZONTAL_TEXT_POSITION_SET = 16;
    private static final int ICON_SET = 32;
    private static final int ICON_TEXT_GAP_SET = 64;
    private static final int TEXT_SET = 128;
    private static final int VERTICAL_ALIGNMENT_SET = 256;
    private static final int VERTICAL_TEXT_POSITION_SET = 512;
    private int setFlags = 0;

    public LabelProperties() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                Object value = e.getNewValue();
                if (propertyName.equals("background")) {
                    if (value != null) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 1;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFFFE;
                    }
                } else if (propertyName.equals("font")) {
                    if (value != null) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 4;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFFFB;
                    }
                } else if (propertyName.equals("foreground")) {
                    if (value != null) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 2;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFFFD;
                    }
                } else if (propertyName.equals("horizontalAlignment")) {
                    if (value != null && (Integer)value != -1) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 8;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFFF7;
                    }
                } else if (propertyName.equals("horizontalTextPosition")) {
                    if (value != null && (Integer)value != -1) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 0x10;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFFEF;
                    }
                } else if (propertyName.equals("icon")) {
                    if (value != null) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 0x20;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFFDF;
                    }
                } else if (propertyName.equals("iconTextGap")) {
                    if (value != null && (Integer)value != -1) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 0x40;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFFBF;
                    }
                } else if (propertyName.equals("text")) {
                    if (value != null) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 0x80;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFF7F;
                    }
                } else if (propertyName.equals("verticalAlignment")) {
                    if (value != null && (Integer)value != -1) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 0x100;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFEFF;
                    }
                } else if (propertyName.equals("verticalTextPosition")) {
                    if (value != null && (Integer)value != -1) {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags | 0x200;
                    } else {
                        LabelProperties labelProperties = LabelProperties.this;
                        labelProperties.setFlags = labelProperties.setFlags & 0xFFFFFDFF;
                    }
                }
            }
        });
    }

    public LabelProperties(Color background, Color foreground, Font font, int horizontalAlignment, int horizontalTextPosition, int verticalAlignment, int verticalTextPosition, Icon icon, int iconTextGap, String text) {
        this();
        this.setBackground(background);
        this.setForeground(foreground);
        this.setFont(font);
        this.setHorizontalAlignment(horizontalAlignment);
        this.setHorizontalTextPosition(horizontalTextPosition);
        this.setVerticalAlignment(verticalAlignment);
        this.setVerticalTextPosition(verticalTextPosition);
        this.setIcon(icon);
        this.setIconTextGap(iconTextGap);
        this.setText(text);
    }

    public boolean isBackgroundSet() {
        return (this.setFlags & 1) > 0;
    }

    public boolean isForegroundSet() {
        return (this.setFlags & 2) > 0;
    }

    public boolean isFontSet() {
        return (this.setFlags & 4) > 0;
    }

    public boolean isHorizontalAlignmentSet() {
        return (this.setFlags & 8) > 0;
    }

    public boolean isHorizontalTextPositionSet() {
        return (this.setFlags & 0x10) > 0;
    }

    public boolean isIconSet() {
        return (this.setFlags & 0x20) > 0;
    }

    public boolean isIconTextGapSet() {
        return (this.setFlags & 0x40) > 0;
    }

    public boolean isTextSet() {
        return (this.setFlags & 0x80) > 0;
    }

    public boolean isVerticalAlignmentSet() {
        return (this.setFlags & 0x100) > 0;
    }

    public boolean isVerticalTextPositionSet() {
        return (this.setFlags & 0x200) > 0;
    }

    public boolean noPropertiesSet() {
        return this.setFlags == 0;
    }

    public void applyPropertiesTo(JLabel label) {
        if (this.noPropertiesSet()) {
            return;
        }
        if (this.isBackgroundSet()) {
            label.setBackground(this.getBackground());
        }
        if (this.isForegroundSet()) {
            label.setForeground(this.getForeground());
        }
        if (this.isFontSet()) {
            label.setFont(this.getFont());
        }
        if (this.isHorizontalAlignmentSet()) {
            label.setHorizontalAlignment(this.getHorizontalAlignment());
        }
        if (this.isHorizontalTextPositionSet()) {
            label.setHorizontalTextPosition(this.getHorizontalTextPosition());
        }
        if (this.isIconSet()) {
            label.setIcon(this.getIcon());
        }
        if (this.isIconTextGapSet()) {
            label.setIconTextGap(this.getIconTextGap());
        }
        if (this.isTextSet()) {
            label.setText(this.getText());
        }
        if (this.isVerticalAlignmentSet()) {
            label.setVerticalAlignment(this.getVerticalAlignment());
        }
        if (this.isVerticalTextPositionSet()) {
            label.setVerticalTextPosition(this.getVerticalTextPosition());
        }
    }

    public void applyPropertiesTo(AbstractButton button) {
        if (this.noPropertiesSet()) {
            return;
        }
        if (this.isBackgroundSet()) {
            button.setBackground(this.getBackground());
        }
        if (this.isForegroundSet()) {
            button.setForeground(this.getForeground());
        }
        if (this.isFontSet()) {
            button.setFont(this.getFont());
        }
        if (this.isHorizontalAlignmentSet()) {
            button.setHorizontalAlignment(this.getHorizontalAlignment());
        }
        if (this.isHorizontalTextPositionSet()) {
            button.setHorizontalTextPosition(this.getHorizontalTextPosition());
        }
        if (this.isIconSet()) {
            button.setIcon(this.getIcon());
        }
        if (this.isIconTextGapSet()) {
            button.setIconTextGap(this.getIconTextGap());
        }
        if (this.isTextSet()) {
            button.setText(this.getText());
        }
        if (this.isVerticalAlignmentSet()) {
            button.setVerticalAlignment(this.getVerticalAlignment());
        }
        if (this.isVerticalTextPositionSet()) {
            button.setVerticalTextPosition(this.getVerticalTextPosition());
        }
    }

    public void applyPropertiesTo(LabelProperties props) {
        if (this.noPropertiesSet()) {
            return;
        }
        if (this.isBackgroundSet()) {
            props.setBackground(this.getBackground());
        }
        if (this.isForegroundSet()) {
            props.setForeground(this.getForeground());
        }
        if (this.isFontSet()) {
            props.setFont(this.getFont());
        }
        if (this.isHorizontalAlignmentSet()) {
            props.setHorizontalAlignment(this.getHorizontalAlignment());
        }
        if (this.isHorizontalTextPositionSet()) {
            props.setHorizontalTextPosition(this.getHorizontalTextPosition());
        }
        if (this.isIconSet()) {
            props.setIcon(this.getIcon());
        }
        if (this.isIconTextGapSet()) {
            props.setIconTextGap(this.getIconTextGap());
        }
        if (this.isTextSet()) {
            props.setText(this.getText());
        }
        if (this.isVerticalAlignmentSet()) {
            props.setVerticalAlignment(this.getVerticalAlignment());
        }
        if (this.isVerticalTextPositionSet()) {
            props.setVerticalTextPosition(this.getVerticalTextPosition());
        }
    }

    public void applyPropertiesTo(TableCellRenderer renderer) {
        if (renderer instanceof JLabel) {
            this.applyPropertiesTo((JLabel)((Object)renderer));
        } else if (renderer instanceof AbstractButton) {
            this.applyPropertiesTo((AbstractButton)((Object)renderer));
        }
    }
}

