/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing;

import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

class WebStartContext {
    private static WebStartContext INSTANCE;

    private WebStartContext() {
    }

    public static WebStartContext getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebStartContext();
        }
        return INSTANCE;
    }

    BasicService getBasicService() {
        BasicService bs = null;
        try {
            bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException ex) {
            System.err.println("WebStartContext - BasicServiceUnavaiable");
        }
        return bs;
    }

    public void showDocument(URL url, String target) {
        BasicService bs = this.getBasicService();
        if (bs != null && !bs.showDocument(url)) {
            System.err.println("WebStartContext - Error showing url: " + url);
        }
    }

    public URL getDocumentBase() {
        BasicService bs = this.getBasicService();
        if (bs != null) {
            return bs.getCodeBase();
        }
        return null;
    }
}

