/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swing.calendar;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdesktop.swing.calendar.DateSpan;

public class JXMonthView
extends JComponent {
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int WEEK_SELECTION = 3;
    protected Insets _monthStringInsets = new Insets(0, 8, 0, 8);
    private static final int MONTH_DROP_SHADOW = 1;
    private static final int MONTH_LINE_DROP_SHADOW = 2;
    private static final int WEEK_DROP_SHADOW = 4;
    private int _boxPaddingX = 3;
    private int _boxPaddingY = 3;
    private static final int CALENDAR_SPACING = 10;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MONTHS_IN_YEAR = 12;
    private long _firstDisplayedDate;
    private int _firstDisplayedMonth;
    private int _firstDisplayedYear;
    private long _lastDisplayedDate;
    private Font _derivedFont;
    private long _startSelectedDate = -1L;
    private long _endSelectedDate = -1L;
    private long _pivotDate = -1L;
    private Rectangle _selectedDateRect = new Rectangle();
    private int _numCalCols = 1;
    private int _numCalRows = 1;
    private int _minCalCols = 1;
    private int _minCalRows = 1;
    private long _today;
    private long[] _flaggedDates;
    private int _selectionMode = 1;
    private int _boxHeight;
    private int _boxWidth;
    private int _calendarWidth;
    private int _calendarHeight;
    private int _firstDayOfWeek = 1;
    private int _startX;
    private int _startY;
    private int _dropShadowMask = 1;
    private boolean _dirty = false;
    private boolean _antiAlias = false;
    private boolean _ltr;
    private boolean _asKirkWouldSay_FIRE = false;
    private final Calendar _cal;
    private String[] _daysOfTheWeek;
    private static String[] _monthsOfTheYear;
    private Dimension _dim = new Dimension();
    private Rectangle _bounds = new Rectangle();
    private Rectangle _dirtyRect = new Rectangle();
    private Color _todayBackgroundColor;
    private Color _monthStringBackground = Color.LIGHT_GRAY;
    private Color _selectedBackground = Color.LIGHT_GRAY;
    private SimpleDateFormat _dayOfMonthFormatter = new SimpleDateFormat("d");
    private String _actionCommand = "selectionChanged";
    private Timer _todayTimer = null;
    static /* synthetic */ Class class$0;

    public JXMonthView() {
        this(new Date().getTime());
    }

    public JXMonthView(long initialTime) {
        this._ltr = this.getComponentOrientation().isLeftToRight();
        this._cal = Calendar.getInstance(this.getLocale());
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(initialTime);
        this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        _monthsOfTheYear = new String[12];
        SimpleDateFormat fullMonthNameFormatter = new SimpleDateFormat("MMMM");
        int i = 0;
        while (i < 12) {
            JXMonthView._monthsOfTheYear[i] = fullMonthNameFormatter.format(this._cal.getTime());
            this._cal.add(2, 1);
            ++i;
        }
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Dialog", 0, 12));
        this._todayBackgroundColor = this.getForeground();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.updateUI();
    }

    public void updateUI() {
        super.updateUI();
        String[] daysOfTheWeek = (String[])UIManager.get("JXMonthView.daysOfTheWeek");
        if (daysOfTheWeek == null) {
            daysOfTheWeek = new String[]{"S", "M", "T", "W", "R", "F", "S"};
        }
        this.setDaysOfTheWeek(daysOfTheWeek);
        Color color = UIManager.getColor("JXMonthView.monthStringBackground");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        this.setMonthStringBackground(color);
        color = UIManager.getColor("JXMonthView.selectedBackground");
        if (color == null) {
            color = Color.LIGHT_GRAY;
        }
        this.setSelectedBackground(color);
    }

    public long getFirstDisplayedDate() {
        return this._firstDisplayedDate;
    }

    public void setFirstDisplayedDate(long date) {
        long old = this._firstDisplayedDate;
        this._cal.setTimeInMillis(date);
        this._cal.set(5, 1);
        this._cal.set(11, 0);
        this._cal.set(12, 0);
        this._cal.set(13, 0);
        this._cal.set(14, 0);
        this._firstDisplayedDate = this._cal.getTimeInMillis();
        this._firstDisplayedMonth = this._cal.get(2);
        this._firstDisplayedYear = this._cal.get(1);
        this.calculateLastDisplayedDate();
        this.firePropertyChange("firstDisplayedDate", old, this._firstDisplayedDate);
        this.repaint();
    }

    public long getLastDisplayedDate() {
        return this._lastDisplayedDate;
    }

    private void calculateLastDisplayedDate() {
        long old = this._lastDisplayedDate;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, this._numCalCols * this._numCalRows - 1);
        this._cal.set(5, this._cal.getActualMaximum(5));
        this._cal.set(11, 23);
        this._cal.set(12, 59);
        this._cal.set(13, 59);
        this._lastDisplayedDate = this._cal.getTimeInMillis();
        this.firePropertyChange("lastDisplayedDate", old, this._lastDisplayedDate);
    }

    public void ensureDateVisible(long date) {
        if (date < this._firstDisplayedDate) {
            this.setFirstDisplayedDate(date);
        } else if (date > this._lastDisplayedDate) {
            this._cal.setTimeInMillis(date);
            int month = this._cal.get(2);
            int year = this._cal.get(1);
            this._cal.setTimeInMillis(this._lastDisplayedDate);
            int lastMonth = this._cal.get(2);
            int lastYear = this._cal.get(1);
            int diffMonths = month - lastMonth + (year - lastYear) * 12;
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this._cal.add(2, diffMonths);
            this.setFirstDisplayedDate(this._cal.getTimeInMillis());
        }
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            this.calculateDirtyRectForSelection();
        }
    }

    public DateSpan getSelectedDateSpan() {
        DateSpan result = null;
        if (this._startSelectedDate != -1L) {
            result = new DateSpan(new Date(this._startSelectedDate), new Date(this._endSelectedDate));
        }
        return result;
    }

    public void setSelectedDateSpan(DateSpan dateSpan) {
        DateSpan oldSpan = null;
        if (this._startSelectedDate != -1L && this._endSelectedDate != -1L) {
            oldSpan = new DateSpan(this._startSelectedDate, this._endSelectedDate);
        }
        if (dateSpan == null) {
            this._startSelectedDate = -1L;
            this._endSelectedDate = -1L;
        } else {
            this._cal.setTimeInMillis(dateSpan.getStart());
            this._cal.set(11, 0);
            this._cal.set(12, 0);
            this._cal.set(13, 0);
            this._cal.set(14, 0);
            this._startSelectedDate = this._cal.getTimeInMillis();
            if (this._selectionMode == 1) {
                this._endSelectedDate = this._startSelectedDate;
            } else {
                this._cal.setTimeInMillis(dateSpan.getEnd());
                this._cal.set(11, 0);
                this._cal.set(12, 0);
                this._cal.set(13, 0);
                this._cal.set(14, 0);
                this._endSelectedDate = this._cal.getTimeInMillis();
                if (this._selectionMode == 3) {
                    this._cal.setTimeInMillis(this._startSelectedDate);
                    int count = 1;
                    while (this._cal.getTimeInMillis() < this._endSelectedDate) {
                        this._cal.add(5, 1);
                        ++count;
                    }
                    if (count > 7) {
                        int remainder;
                        this._cal.setTimeInMillis(this._startSelectedDate);
                        int dayOfWeek = this._cal.get(7);
                        if (dayOfWeek != this._firstDayOfWeek) {
                            int daysFromStart = dayOfWeek - this._firstDayOfWeek;
                            if (daysFromStart < 0) {
                                daysFromStart += 7;
                            }
                            this._cal.add(5, -daysFromStart);
                            count += daysFromStart;
                            this._startSelectedDate = this._cal.getTimeInMillis();
                        }
                        if ((remainder = count % 7) != 0) {
                            this._cal.setTimeInMillis(this._endSelectedDate);
                            this._cal.add(5, 7 - remainder);
                            this._endSelectedDate = this._cal.getTimeInMillis();
                        }
                    }
                }
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
        this.repaint(this._dirtyRect);
        this.calculateDirtyRectForSelection();
        this.repaint(this._dirtyRect);
        this.firePropertyChange("selectedDates", oldSpan, dateSpan);
    }

    public int getSelectionMode() {
        return this._selectionMode;
    }

    public void setSelectionMode(int mode) throws IllegalArgumentException {
        if (mode != 1 && mode != 2 && mode != 3 && mode != 0) {
            throw new IllegalArgumentException(String.valueOf(mode) + " is not a valid selection mode");
        }
        this._selectionMode = mode;
    }

    public void setFlaggedDates(long[] flaggedDates) {
        this._flaggedDates = flaggedDates;
        if (this._flaggedDates == null) {
            this.repaint();
            return;
        }
        int i = 0;
        while (i < this._flaggedDates.length) {
            this._cal.setTimeInMillis(this._flaggedDates[i]);
            this._cal.set(11, 0);
            this._cal.set(12, 0);
            this._cal.set(13, 0);
            this._cal.set(14, 0);
            this._flaggedDates[i] = this._cal.getTimeInMillis();
            ++i;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public int getBoxPaddingX() {
        return this._boxPaddingX;
    }

    public void setBoxPaddingX(int _boxPaddingX) {
        this._boxPaddingX = _boxPaddingX;
        this._dirty = true;
    }

    public int getBoxPaddingY() {
        return this._boxPaddingY;
    }

    public void setBoxPaddingY(int _boxPaddingY) {
        this._boxPaddingY = _boxPaddingY;
        this._dirty = true;
    }

    public void setDaysOfTheWeek(String[] days) throws IllegalArgumentException, NullPointerException {
        if (days == null) {
            throw new NullPointerException("Array of days is null.");
        }
        if (days.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        this._daysOfTheWeek = days;
    }

    public String[] getDaysOfTheWeek() {
        String[] days = new String[7];
        System.arraycopy(this._daysOfTheWeek, 0, days, 0, 7);
        return days;
    }

    public int getFirstDayOfWeek() {
        return this._firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == this._firstDayOfWeek) {
            return;
        }
        this._firstDayOfWeek = firstDayOfWeek;
        this._cal.setFirstDayOfWeek(this._firstDayOfWeek);
        this.repaint();
    }

    public TimeZone getTimeZone() {
        return this._cal.getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        this._cal.setTimeZone(tz);
    }

    public boolean getAntialiased() {
        return this._antiAlias;
    }

    public void setAntialiased(boolean antiAlias) {
        if (this._antiAlias == antiAlias) {
            return;
        }
        this._antiAlias = antiAlias;
        this.repaint();
    }

    public Color getSelectedBackground() {
        return this._selectedBackground;
    }

    public void setSelectedBackground(Color c) {
        this._selectedBackground = c;
    }

    public Color getTodayBackground() {
        return this._todayBackgroundColor;
    }

    public void setTodayBackground(Color c) {
        this._todayBackgroundColor = c;
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this._monthStringBackground;
    }

    public void setMonthStringBackground(Color c) {
        this._monthStringBackground = c;
        this.repaint();
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.repaint();
    }

    public int getPreferredCols() {
        return this._minCalCols;
    }

    public void setPreferredCols(int cols) {
        if (cols <= 0) {
            return;
        }
        this._minCalCols = cols;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRows() {
        return this._minCalRows;
    }

    public void setPreferredRows(int rows) {
        if (rows <= 0) {
            return;
        }
        this._minCalRows = rows;
        this._dirty = true;
        this.revalidate();
        this.repaint();
    }

    private void updateIfNecessary() {
        if (this._dirty) {
            this.update();
            this._dirty = false;
        }
    }

    private void update() {
        int currWidth;
        int longestMonth = 0;
        int daysInLongestMonth = 0;
        int longestMonthWidth = 0;
        this._derivedFont = this.getFont().deriveFont(1);
        FontMetrics fm = this.getFontMetrics(this._derivedFont);
        this._cal.set(2, this._cal.getMinimum(2));
        this._cal.set(5, this._cal.getActualMinimum(5));
        int i = 0;
        while (i < this._cal.getMaximum(2)) {
            int currDays;
            currWidth = fm.stringWidth(_monthsOfTheYear[i]);
            if (currWidth > longestMonthWidth) {
                longestMonthWidth = currWidth;
            }
            if ((currDays = this._cal.getActualMaximum(5)) > daysInLongestMonth) {
                longestMonth = this._cal.get(2);
                daysInLongestMonth = currDays;
            }
            this._cal.add(2, 1);
            ++i;
        }
        this._cal.set(2, longestMonth);
        this._cal.set(5, this._cal.getActualMinimum(5));
        this._boxHeight = fm.getHeight();
        i = 0;
        while (i < daysInLongestMonth) {
            currWidth = fm.stringWidth(this._dayOfMonthFormatter.format(this._cal.getTime()));
            if (currWidth > this._boxWidth) {
                this._boxWidth = currWidth;
            }
            this._cal.add(5, 1);
            ++i;
        }
        this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        if (this._dim.width < longestMonthWidth) {
            double diff = longestMonthWidth - this._dim.width;
            this._boxWidth = (int)((double)this._boxWidth + Math.ceil(diff / 7.0));
            this._dim.width = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        }
        this._calendarWidth = (this._boxWidth + 2 * this._boxPaddingX) * 7;
        this._calendarHeight = (this._boxPaddingY + this._boxHeight + this._boxPaddingY) * 8;
        this._dim.height = this._calendarHeight * this._minCalRows + 10 * (this._minCalRows - 1);
        this._dim.width = this._calendarWidth * this._minCalCols + 10 * (this._minCalCols - 1);
        Insets insets = this.getInsets();
        this._dim.width += insets.left + insets.right;
        this._dim.height += insets.top + insets.bottom;
        this._cal.setTimeInMillis(this._firstDisplayedDate);
    }

    private void updateToday() {
        this._cal.setTimeInMillis(this._today);
        this._cal.add(5, 1);
        this._today = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        this.updateIfNecessary();
        return new Dimension(this._dim);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        this._dirty = true;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.calculateNumDisplayedCals();
        this.calculateStartPosition();
        if (this._startSelectedDate != -1L || this._endSelectedDate != -1L) {
            if (this._startSelectedDate > this._lastDisplayedDate || this._startSelectedDate < this._firstDisplayedDate) {
                this.ensureDateVisible(this._startSelectedDate);
            } else {
                this.calculateDirtyRectForSelection();
            }
        }
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        this._ltr = o.isLeftToRight();
        this.calculateStartPosition();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._dirty = true;
    }

    public void removeNotify() {
        this._todayTimer.stop();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        int secondsTillTomorrow = 86400;
        if (this._todayTimer == null) {
            this._todayTimer = new Timer(secondsTillTomorrow * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JXMonthView.this.updateToday();
                }
            });
        }
        secondsTillTomorrow = secondsTillTomorrow - this._cal.get(11) * 3600 - this._cal.get(12) * 60 - this._cal.get(13);
        this._todayTimer.setInitialDelay(secondsTillTomorrow * 1000);
        this._todayTimer.start();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2;
        Object oldAAValue = null;
        Graphics2D graphics2D = g2 = g instanceof Graphics2D ? (Graphics2D)g : null;
        if (g2 != null && this._antiAlias) {
            oldAAValue = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Rectangle clip = g.getClipBounds();
        this.updateIfNecessary();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        g.setColor(this.getForeground());
        Color shadowColor = g.getColor();
        shadowColor = new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), 51);
        FontMetrics fm = g.getFontMetrics();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        int y = this._startY;
        int row = 0;
        while (row < this._numCalRows) {
            int x = this._startX;
            this._bounds.x = 0;
            this._bounds.y = this._startY + row * (this._calendarHeight + 10);
            this._bounds.width = this.getWidth();
            this._bounds.height = this._calendarHeight;
            if (!this._bounds.intersects(clip)) {
                this._cal.add(2, this._numCalCols);
                y += this._calendarHeight + 10;
            } else {
                int column = 0;
                while (column < this._numCalCols) {
                    int tmpY;
                    int tmpX;
                    String monthName = _monthsOfTheYear[this._cal.get(2)];
                    monthName = String.valueOf(monthName) + " " + this._cal.get(1);
                    this._bounds.x = this._ltr ? x : x - this._calendarWidth;
                    this._bounds.y = y + this._boxPaddingY;
                    this._bounds.width = this._calendarWidth;
                    this._bounds.height = this._boxHeight;
                    if (this._bounds.intersects(clip)) {
                        this.paintMonthStringBackground(g, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                        g.setColor(this.getForeground());
                        tmpX = this._ltr ? x + this._calendarWidth / 2 - fm.stringWidth(monthName) / 2 : x - this._calendarWidth / 2 - fm.stringWidth(monthName) / 2 - 1;
                        tmpY = y + this._boxPaddingY + this._boxHeight - fm.getDescent();
                        g.drawString(monthName, tmpX, tmpY);
                        if ((this._dropShadowMask & 1) != 0) {
                            g.setColor(shadowColor);
                            g.drawString(monthName, tmpX + 1, tmpY + 1);
                            g.setColor(this.getForeground());
                        }
                    }
                    this._bounds.x = this._ltr ? x : x - this._calendarWidth;
                    this._bounds.y = y + this._boxPaddingY + this._boxHeight + this._boxPaddingY + this._boxPaddingY;
                    this._bounds.width = this._calendarWidth;
                    this._bounds.height = this._boxHeight;
                    if (this._bounds.intersects(clip)) {
                        this._cal.set(5, this._cal.getActualMinimum(5));
                        int dayIndex = this._firstDayOfWeek - 1;
                        int i = 0;
                        while (i < 7) {
                            tmpX = this._ltr ? x + i * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) + this._boxPaddingX + this._boxWidth / 2 - fm.stringWidth(this._daysOfTheWeek[dayIndex]) / 2 : x - i * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) - this._boxPaddingX - this._boxWidth / 2 - fm.stringWidth(this._daysOfTheWeek[dayIndex]) / 2;
                            tmpY = y + this._boxPaddingY + this._boxHeight + this._boxPaddingY + this._boxPaddingY + fm.getAscent();
                            g.drawString(this._daysOfTheWeek[dayIndex], tmpX, tmpY);
                            if ((this._dropShadowMask & 4) != 0) {
                                g.setColor(shadowColor);
                                g.drawString(this._daysOfTheWeek[dayIndex], tmpX + 1, tmpY + 1);
                                g.setColor(this.getForeground());
                            }
                            if (++dayIndex == 7) {
                                dayIndex = 0;
                            }
                            ++i;
                        }
                        g.drawLine(this._ltr ? x + 2 : x - 3, y + this._boxPaddingY * 3 + this._boxHeight * 2, this._ltr ? x + this._calendarWidth - 3 : x - this._calendarWidth + 2, y + this._boxPaddingY * 3 + this._boxHeight * 2);
                        if ((this._dropShadowMask & 2) != 0) {
                            g.setColor(shadowColor);
                            g.drawLine(this._ltr ? x + 3 : x - 2, y + this._boxPaddingY * 3 + this._boxHeight * 2 + 1, this._ltr ? x + this._calendarWidth - 2 : x - this._calendarWidth + 3, y + this._boxPaddingY * 3 + this._boxHeight * 2 + 1);
                            g.setColor(this.getForeground());
                        }
                    }
                    this._bounds.x = this._startX + (this._ltr ? column * (this._calendarWidth + 10) : -(column * (this._calendarWidth + 10) + this._calendarWidth));
                    this._bounds.y = this._startY + row * (this._calendarHeight + 10);
                    this._bounds.width = this._calendarWidth;
                    this._bounds.height = this._calendarHeight;
                    if (this._bounds.intersects(clip)) {
                        this.paintMonth(g, column, row);
                    } else {
                        this._cal.add(2, 1);
                    }
                    x += this._ltr ? this._calendarWidth + 10 : -(this._calendarWidth + 10);
                    ++column;
                }
                y += this._calendarHeight + 10;
            }
            ++row;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        if (g2 != null && this._antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    private void paintMonth(Graphics g, int col, int row) {
        int days = this._cal.getActualMaximum(5);
        FontMetrics fm = g.getFontMetrics();
        Rectangle clip = g.getClipBounds();
        long nextFlaggedDate = -1L;
        int flaggedDateIndex = 0;
        if (this._flaggedDates != null && this._flaggedDates.length > 0) {
            nextFlaggedDate = this._flaggedDates[flaggedDateIndex];
        }
        int i = 0;
        while (i < days) {
            this.calculateBoundsForDay(this._bounds);
            if (this._bounds.intersects(clip)) {
                String numericDay = this._dayOfMonthFormatter.format(this._cal.getTime());
                if (this.isSelectedDate(this._cal.getTimeInMillis())) {
                    if (this._selectionMode == 1) {
                        this._dirtyRect.x = this._bounds.x;
                        this._dirtyRect.y = this._bounds.y;
                        this._dirtyRect.width = this._bounds.width;
                        this._dirtyRect.height = this._bounds.height;
                    }
                    this.paintSelectedDayBackground(g, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    g.setColor(this.getForeground());
                }
                if (this._cal.getTimeInMillis() == this._today) {
                    this.paintTodayBackground(g, this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                    g.setColor(this.getForeground());
                }
                while (nextFlaggedDate != -1L && nextFlaggedDate < this._cal.getTimeInMillis()) {
                    nextFlaggedDate = ++flaggedDateIndex < this._flaggedDates.length ? this._flaggedDates[flaggedDateIndex] : -1L;
                }
                if (nextFlaggedDate != -1L && this._cal.getTimeInMillis() == nextFlaggedDate) {
                    Font oldFont = this.getFont();
                    g.setFont(this._derivedFont);
                    g.drawString(numericDay, this._ltr ? this._bounds.x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) : this._bounds.x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) - 1, this._bounds.y + this._boxPaddingY + fm.getAscent());
                    g.setFont(oldFont);
                } else {
                    g.drawString(numericDay, this._ltr ? this._bounds.x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) : this._bounds.x + this._boxPaddingX + this._boxWidth - fm.stringWidth(numericDay) - 1, this._bounds.y + this._boxPaddingY + fm.getAscent());
                }
            }
            this._cal.add(5, 1);
            ++i;
        }
    }

    protected void paintMonthStringBackground(Graphics g, int x, int y, int width, int height) {
        x = this._ltr ? x + this._monthStringInsets.left : x + this._monthStringInsets.left;
        width = width - this._monthStringInsets.left - this._monthStringInsets.right;
        height = height - this._monthStringInsets.top - this._monthStringInsets.bottom;
        g.setColor(this._monthStringBackground);
        g.fillRect(x, y += this._monthStringInsets.top, width, height);
    }

    protected void paintTodayBackground(Graphics g, int x, int y, int width, int height) {
        g.setColor(this._todayBackgroundColor);
        g.drawRect(x, y, width - 1, height - 1);
    }

    protected void paintSelectedDayBackground(Graphics g, int x, int y, int width, int height) {
        g.setColor(this.getSelectedBackground());
        g.fillRect(x, y, width, height);
    }

    private boolean isSelectedDate(long time) {
        return time >= this._startSelectedDate && time <= this._endSelectedDate;
    }

    private void calculateNumDisplayedCals() {
        int oldNumCalCols = this._numCalCols;
        int oldNumCalRows = this._numCalRows;
        this._numCalCols = 1;
        this._numCalCols += (this.getWidth() - this._calendarWidth) / (this._calendarWidth + 10);
        this._numCalRows = 1;
        this._numCalRows += (this.getHeight() - this._calendarHeight) / (this._calendarHeight + 10);
        if (oldNumCalCols != this._numCalCols || oldNumCalRows != this._numCalRows) {
            this.calculateLastDisplayedDate();
        }
    }

    private void calculateStartPosition() {
        this._startX = (this.getWidth() - (this._calendarWidth * this._numCalCols + 10 * (this._numCalCols - 1))) / 2;
        if (!this._ltr) {
            this._startX = this.getWidth() - this._startX;
        }
        this._startY = (this.getHeight() - (this._calendarHeight * this._numCalRows + 10 * (this._numCalRows - 1))) / 2;
    }

    private void calculateBoundsForDay(Rectangle bounds) {
        int year = this._cal.get(1);
        int month = this._cal.get(2);
        int dayOfWeek = this._cal.get(7);
        int weekOfMonth = this._cal.get(4);
        int diffMonths = month - this._firstDisplayedMonth + (year - this._firstDisplayedYear) * 12;
        int calRowIndex = diffMonths / this._numCalCols;
        int calColIndex = diffMonths - calRowIndex * this._numCalCols;
        bounds.x = dayOfWeek - this._firstDayOfWeek;
        if (bounds.x < 0) {
            bounds.x += 7;
        }
        bounds.x = this._ltr ? bounds.x * (this._boxPaddingX + this._boxWidth + this._boxPaddingX) : (bounds.x + 1) * (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        bounds.x += calColIndex * (this._calendarWidth + 10);
        bounds.x = this._ltr ? this._startX + bounds.x : this._startX - bounds.x;
        bounds.y = 2 * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        bounds.y += this._startY + calRowIndex * (this._calendarHeight + 10);
        long oldDate = this._cal.getTimeInMillis();
        this._cal.set(5, 1);
        int weekOffset = this._cal.get(4);
        this._cal.setTimeInMillis(oldDate);
        bounds.y += (weekOfMonth - weekOffset) * (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        bounds.width = this._boxPaddingX + this._boxWidth + this._boxPaddingX;
        bounds.height = this._boxPaddingY + this._boxHeight + this._boxPaddingY;
    }

    public long getDayAt(int x, int y) {
        int daysToAdd;
        if (this._ltr ? this._startX > x : this._startX < x || this._startY > y) {
            return -1L;
        }
        int calCol = (this._ltr ? x - this._startX : this._startX - x) / (this._calendarWidth + 10);
        int calRow = (y - this._startY) / (this._calendarHeight + 10);
        if (calRow > this._numCalRows - 1 || calCol > this._numCalCols - 1) {
            return -1L;
        }
        int row = (y - this._startY - calRow * (this._calendarHeight + 10)) / (this._boxPaddingY + this._boxHeight + this._boxPaddingY);
        if ((row -= 2) < 0 || row > 5) {
            return -1L;
        }
        int col = ((this._ltr ? x - this._startX : this._startX - x) - calCol * (this._calendarWidth + 10)) / (this._boxPaddingX + this._boxWidth + this._boxPaddingX);
        if (col > 6) {
            return -1L;
        }
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        this._cal.add(2, calCol + calRow * this._numCalCols);
        int dayOfWeek = this._cal.get(7);
        int firstDayIndex = dayOfWeek - this._firstDayOfWeek;
        if (firstDayIndex < 0) {
            firstDayIndex += 7;
        }
        if ((daysToAdd = row * 7 + (col - firstDayIndex)) < 0 || daysToAdd > this._cal.getActualMaximum(5) - 1) {
            return -1L;
        }
        this._cal.add(5, daysToAdd);
        long selected = this._cal.getTimeInMillis();
        this._cal.setTimeInMillis(this._firstDisplayedDate);
        return selected;
    }

    private void calculateDirtyRectForSelection() {
        if (this._startSelectedDate == -1L || this._endSelectedDate == -1L) {
            this._dirtyRect.x = 0;
            this._dirtyRect.y = 0;
            this._dirtyRect.width = 0;
            this._dirtyRect.height = 0;
        } else {
            this._cal.setTimeInMillis(this._startSelectedDate);
            this.calculateBoundsForDay(this._dirtyRect);
            this._cal.add(5, 1);
            while (this._cal.getTimeInMillis() <= this._endSelectedDate) {
                this.calculateBoundsForDay(this._bounds);
                Rectangle tmpRect = this._dirtyRect.union(this._bounds);
                this._dirtyRect.x = tmpRect.x;
                this._dirtyRect.y = tmpRect.y;
                this._dirtyRect.width = tmpRect.width;
                this._dirtyRect.height = tmpRect.height;
                this._cal.add(5, 1);
            }
            this._cal.setTimeInMillis(this._firstDisplayedDate);
        }
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this._actionCommand = actionCommand;
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeActionListener(ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (e == null) {
                    e = new ActionEvent(this, 1001, this._actionCommand);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled() || this._selectionMode == 0) {
            return;
        }
        int id = e.getID();
        if (id == 501) {
            int y;
            int x = e.getX();
            long selected = this.getDayAt(x, y = e.getY());
            if (selected == -1L) {
                return;
            }
            this._startSelectedDate = selected;
            this._endSelectedDate = selected;
            if (this._selectionMode == 2 || this._selectionMode == 3) {
                this._pivotDate = selected;
            }
            this._cal.setTimeInMillis(selected);
            this.calculateBoundsForDay(this._bounds);
            this._cal.setTimeInMillis(this._firstDisplayedDate);
            this.repaint(this._dirtyRect);
            this.repaint(this._bounds);
            this._dirtyRect.x = this._bounds.x;
            this._dirtyRect.y = this._bounds.y;
            this._dirtyRect.width = this._bounds.width;
            this._dirtyRect.height = this._bounds.height;
            this._asKirkWouldSay_FIRE = true;
        } else if (id == 502) {
            if (this._asKirkWouldSay_FIRE) {
                this.fireActionPerformed();
            }
            this._asKirkWouldSay_FIRE = false;
        }
        super.processMouseEvent(e);
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled() || this._selectionMode == 0) {
            return;
        }
        int id = e.getID();
        if (id == 506) {
            int y;
            int x = e.getX();
            long selected = this.getDayAt(x, y = e.getY());
            if (selected == -1L) {
                return;
            }
            long oldStart = this._startSelectedDate;
            long oldEnd = this._endSelectedDate;
            if (this._selectionMode == 1) {
                if (selected == oldStart) {
                    return;
                }
                this._startSelectedDate = selected;
                this._endSelectedDate = selected;
            } else if (selected <= this._pivotDate) {
                this._startSelectedDate = selected;
                this._endSelectedDate = this._pivotDate;
            } else if (selected > this._pivotDate) {
                this._startSelectedDate = this._pivotDate;
                this._endSelectedDate = selected;
            }
            if (this._selectionMode == 3) {
                long start = selected > this._pivotDate ? this._pivotDate : selected;
                long end = selected > this._pivotDate ? selected : this._pivotDate;
                this._cal.setTimeInMillis(start);
                int count = 1;
                while (this._cal.getTimeInMillis() < end) {
                    this._cal.add(5, 1);
                    ++count;
                }
                if (count > 7) {
                    int daysTillEnd;
                    this._cal.setTimeInMillis(start);
                    int dayOfWeek = this._cal.get(7);
                    int daysFromStart = dayOfWeek - this._firstDayOfWeek;
                    if (daysFromStart < 0) {
                        daysFromStart += 7;
                    }
                    this._cal.add(5, -daysFromStart);
                    this._startSelectedDate = this._cal.getTimeInMillis();
                    this._cal.setTimeInMillis(end);
                    dayOfWeek = this._cal.get(7);
                    int lastDayOfWeek = this._firstDayOfWeek - 1;
                    if (lastDayOfWeek == 0) {
                        lastDayOfWeek = 7;
                    }
                    if ((daysTillEnd = lastDayOfWeek - dayOfWeek) < 0) {
                        daysTillEnd += 7;
                    }
                    this._cal.add(5, daysTillEnd);
                    this._endSelectedDate = this._cal.getTimeInMillis();
                }
            }
            if (oldStart == this._startSelectedDate && oldEnd == this._endSelectedDate) {
                return;
            }
            this.repaint(this._dirtyRect);
            this.calculateDirtyRectForSelection();
            this.repaint(this._dirtyRect);
            this._asKirkWouldSay_FIRE = true;
        }
        super.processMouseMotionEvent(e);
    }
}

